/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.audit.dm.api;

import com.finconsgroup.itserr.marketplace.audit.dm.dto.InputCreateAuditLogDto;
import com.finconsgroup.itserr.marketplace.audit.dm.dto.OutputAuditLogDto;
import com.finconsgroup.itserr.marketplace.audit.dm.validation.ValidInputCreateAuditLogDto;
import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="AuditLogApi", description="The AuditLogApi API: it provides endpoints for retrieving and creating audit logs.")
@SecurityRequirement(name="BearerAuth")
public interface AuditLogApi {
    @Operation(summary="find all the audit log", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/audit/audit-logs"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Page<OutputAuditLogDto> findAll(@RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var1, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var2, @RequestParam(name="sort", defaultValue="id", required=false) String var3, @RequestParam(name="direction", defaultValue="DESC", required=false) Sort.Direction var4);

    @Operation(summary="find audit log by id", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @GetMapping(value={"/audit/audit-logs/{id}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputAuditLogDto findById(@PathVariable(value="id") UUID var1);

    @Operation(summary="create an audit log", responses={@ApiResponse(responseCode="201", description="Created")})
    @PostMapping(value={"/audit/audit-logs"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public OutputAuditLogDto createAuditLog(@Valid @ValidInputCreateAuditLogDto @RequestBody InputCreateAuditLogDto var1);
}

