/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.audit.bs.mapper;

import com.finconsgroup.itserr.marketplace.audit.bs.dto.InputCreateAuditLogDto;
import com.finconsgroup.itserr.marketplace.audit.bs.dto.OutputAuditLogDto;
import com.finconsgroup.itserr.marketplace.audit.bs.mapper.MapperConfiguration;
import com.finconsgroup.itserr.messaging.dto.UntypedMessagingEventDto;
import io.cloudevents.CloudEvent;
import java.net.URI;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;

@Mapper(config=MapperConfiguration.class)
public interface AuditLogMapper {
    public static final String NAME_CLOUD_EVENT_SOURCE_TO_STRING = "cloudEventSourceToString";

    @Mappings(value={@Mapping(target="eventSource", source="cloudEvent.source", qualifiedByName={"cloudEventSourceToString"}), @Mapping(target="eventType", source="cloudEvent.type"), @Mapping(target="user", source="messagingEventDto.user"), @Mapping(target="resource.id", source="messagingEventDto.id"), @Mapping(target="resource.name", source="messagingEventDto.name"), @Mapping(target="resource.title", source="messagingEventDto.title"), @Mapping(target="resource.status", source="messagingEventDto.status"), @Mapping(target="resource.category", source="messagingEventDto.category"), @Mapping(target="eventMessage", source="messagingEventDto.message"), @Mapping(target="eventActionTime", source="messagingEventDto.timestamp"), @Mapping(target="eventAdditionalData", source="messagingEventDto.additionalData"), @Mapping(target="eventCreationTime", source="cloudEvent.time")})
    public InputCreateAuditLogDto messagingEventToInputCreateAuditLogDto(UntypedMessagingEventDto var1, CloudEvent var2);

    public OutputAuditLogDto auditLogDmDtoToBsDto(com.finconsgroup.itserr.marketplace.audit.dm.dto.OutputAuditLogDto var1);

    @Named(value="cloudEventSourceToString")
    default public String cloudEventSourceToString(URI source) {
        return source != null ? source.toString() : null;
    }

    default public Instant offsetDateTimeToInstant(OffsetDateTime offsetDateTime) {
        return Optional.ofNullable(offsetDateTime).map(OffsetDateTime::toInstant).orElse(null);
    }
}

