package com.finconsgroup.itserr.marketplace.audit.bs.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.finconsgroup.itserr.marketplace.audit.bs.dto.OutputAuditLogDto;
import com.finconsgroup.itserr.marketplace.audit.bs.service.AuditLogService;
import com.finconsgroup.itserr.messaging.consumer.CloudEventConsumer;
import com.finconsgroup.itserr.messaging.dto.UntypedMessagingEventDto;
import io.cloudevents.CloudEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

import static com.finconsgroup.itserr.messaging.consumer.handler.CloudEventTypeHandler.ANY_EVENT_TYPE;

/**
 * Concrete implementation of {@link CloudEventConsumer} for handling all related resource events.
 */
@Component("messagingEventConsumer")
@Slf4j
public class MessagingEventConsumer extends CloudEventConsumer {

    private final AuditLogService auditLogService;

    public MessagingEventConsumer(AuditLogService auditLogService) {
        this.addHandler(ANY_EVENT_TYPE, new TypeReference<>() {
        }, this::handleEvent);
        this.auditLogService = auditLogService;
    }

    private void handleEvent(UntypedMessagingEventDto eventPayload, @NonNull CloudEvent cloudEvent) {
        OutputAuditLogDto outputAuditLogDto = auditLogService.createFromMessagingEvent(eventPayload, cloudEvent);
        log.info("Created audit log with id: {}", outputAuditLogDto.getId());
    }

}
