/*
 * Decompiled with CFR 0.152.
 */
package org.finconsgroup.itserr.criterion.security.service;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.retry.Retry;
import java.util.function.Supplier;
import lombok.Generated;
import org.finconsgroup.itserr.criterion.security.config.ExternalAuthProperties;
import org.finconsgroup.itserr.criterion.security.dto.AuthorizationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ExternalAuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExternalAuthService.class);
    private final RestTemplate restTemplate;
    private final ExternalAuthProperties properties;
    private final CircuitBreaker circuitBreaker;
    private final Retry retry;

    public ExternalAuthService(RestTemplate restTemplate, ExternalAuthProperties properties, CircuitBreaker circuitBreaker, Retry retry) {
        this.restTemplate = restTemplate;
        this.properties = properties;
        this.circuitBreaker = circuitBreaker;
        this.retry = retry;
    }

    public boolean checkAuthorization(String authUrl, AuthorizationRequest authRequest) {
        String url = authUrl == null || authUrl.isEmpty() ? this.properties.getUrl() : authUrl;
        log.debug("Checking authorization at: {}", (Object)url);
        if (authRequest.getAuthorizationHeader() == null || authRequest.getAuthorizationHeader().isEmpty()) {
            log.warn("No Authorization header present in request");
            return false;
        }
        Supplier authCall = () -> this.executeAuthCall(url, authRequest);
        if (this.properties.getRetry().isEnabled()) {
            authCall = Retry.decorateSupplier((Retry)this.retry, authCall);
        }
        if (this.properties.getCircuitBreaker().isEnabled()) {
            authCall = CircuitBreaker.decorateSupplier((CircuitBreaker)this.circuitBreaker, (Supplier)authCall);
        }
        try {
            return (Boolean)authCall.get();
        }
        catch (CallNotPermittedException e) {
            log.warn("Circuit breaker is OPEN. Auth service appears to be unavailable.");
            return this.handleFallback("Circuit breaker open");
        }
        catch (Exception e) {
            log.error("Authorization check failed: {}", (Object)e.getMessage());
            return this.handleFallback("Authorization check failed: " + e.getMessage());
        }
    }

    private Boolean executeAuthCall(String url, AuthorizationRequest authRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", authRequest.getAuthorizationHeader());
        log.debug("Forwarding Authorization header to auth service");
        HttpEntity requestEntity = new HttpEntity((Object)authRequest, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)requestEntity, Boolean.class, new Object[0]);
        Boolean authorized = (Boolean)response.getBody();
        if (authorized == null) {
            log.warn("Auth service returned null response, treating as unauthorized");
            return false;
        }
        log.debug("Authorization response: {}", (Object)authorized);
        return authorized;
    }

    private boolean handleFallback(String reason) {
        if (this.properties.isFailOpen()) {
            log.warn("Fail-open mode: allowing access despite auth failure. Reason: {}", (Object)reason);
            return true;
        }
        log.warn("Fail-close mode: denying access due to auth failure. Reason: {}", (Object)reason);
        return false;
    }

    public CircuitBreaker.State getCircuitBreakerState() {
        return this.circuitBreaker.getState();
    }

    public CircuitBreaker.Metrics getCircuitBreakerMetrics() {
        return this.circuitBreaker.getMetrics();
    }
}

