/**
 * Ext GWT 3.0.0-rc2 - Ext for GWT
 * Copyright(c) 2007-2012, Sencha, Inc.
 * licensing@sencha.com
 *
 * http://sencha.com/license
 */
package com.sencha.gxt.chart.client.chart.series;

import com.sencha.gxt.chart.client.draw.DrawFx;
import com.sencha.gxt.chart.client.draw.sprite.Sprite;

public class LineHighlighter implements SeriesHighlighter {

  @Override
  public void highlight(Sprite sprite) {
    if (sprite.getComponent().isAnimated()) {
      DrawFx.createStrokeWidthAnimator(sprite, 3).run(250);
    } else {
      sprite.setStrokeWidth(3);
      sprite.redraw();
    }
  }

  @Override
  public void unHighlight(Sprite sprite) {
    if (sprite.getComponent().isAnimated()) {
      DrawFx.createStrokeWidthAnimator(sprite, 1).run(250);
    } else {
      sprite.setStrokeWidth(1);
      sprite.redraw();
    }
  }

}
