/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxrs.writers;

import com.lunatech.doclets.jax.JAXConfiguration;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxrs.JAXRSConfiguration;
import com.lunatech.doclets.jax.jaxrs.JAXRSDoclet;
import com.lunatech.doclets.jax.jaxrs.model.MethodParameter;
import com.lunatech.doclets.jax.jaxrs.model.Resource;
import com.lunatech.doclets.jax.jaxrs.model.ResourceMethod;
import com.lunatech.doclets.jax.jaxrs.writers.DocletWriter;
import com.lunatech.doclets.jax.jaxrs.writers.MethodWriter;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceWriter
extends DocletWriter {
    public ResourceWriter(JAXConfiguration configuration, Resource resource, JAXRSDoclet doclet) {
        super(configuration, ResourceWriter.getWriter(configuration, resource), resource, doclet);
    }

    private static HtmlDocletWriter getWriter(JAXConfiguration configuration, Resource resource) {
        String pathName = Utils.urlToPath(resource);
        Utils.log(pathName);
        try {
            return new HtmlDocletWriter(configuration.parentConfiguration, pathName, "index.html", Utils.urlToRoot(resource));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write() {
        boolean isRoot = this.resource.getParent() == null;
        String selected = isRoot ? "Root resource" : "";
        this.printHeader(isRoot);
        this.printMenu(selected);
        this.printResourceInfo();
        this.printSubresources();
        this.printMethods();
        this.tag("hr");
        this.printMenu(selected);
        this.printFooter();
        this.writer.flush();
    }

    private void printMethods() {
        if (!this.resource.hasRealMethods()) {
            return;
        }
        List<ResourceMethod> methods = this.resource.getMethods();
        this.printMethodOverview(methods);
        this.printMethodDetails(methods);
    }

    private void printMethodOverview(List<ResourceMethod> methods) {
        this.tag("hr");
        this.open("table class='info' id='methods-summary'");
        this.around("caption class='TableCaption'", "Method Summary");
        this.open("tbody");
        this.open("tr");
        this.around("th class='TableHeader'", "Resource");
        this.around("th class='TableHeader'", "Description");
        this.close("tr");
        for (ResourceMethod method : methods) {
            if (method.isResourceLocator()) continue;
            for (String httpMethod : method.getMethods()) {
                this.open("tr");
                this.open("td");
                this.open("tt");
                this.around("a href='#" + httpMethod + "'", httpMethod + " " + Utils.getDisplayURL(this, this.resource, method));
                this.close("tt");
                this.close("td");
                this.open("td");
                MethodDoc javaDoc = method.getJavaDoc();
                if (javaDoc != null && javaDoc.firstSentenceTags() != null) {
                    this.writer.printSummaryComment((Doc)javaDoc);
                }
                this.close("td");
                this.close("tr");
            }
        }
        this.close("tbody");
        this.close("table");
    }

    private void printMethodDetails(List<ResourceMethod> methods) {
        this.tag("hr");
        this.open("table class='info' id='methods-details'");
        this.around("caption class='TableCaption'", "Method Detail");
        this.open("tbody");
        this.close("tr");
        for (ResourceMethod method : methods) {
            if (method.isResourceLocator()) continue;
            this.open("tr");
            this.open("td");
            new MethodWriter(method, this, this.doclet).print();
            this.close("td");
            this.close("tr");
        }
        this.close("tbody");
        this.close("table");
    }

    private void printSubresources() {
        Map<String, Resource> resources = this.resource.getResources();
        if (resources.isEmpty()) {
            return;
        }
        this.tag("hr");
        this.open("table class='info' id='resources'");
        this.around("caption class='TableCaption'", "Resources");
        this.open("tbody");
        this.open("tr");
        this.around("th class='TableHeader'", "Name");
        this.around("th class='TableHeader'", "Description");
        this.close("tr");
        for (String subResourceKey : resources.keySet()) {
            Resource realSubResource = resources.get(subResourceKey);
            Resource subResource = this.deepFilter(realSubResource);
            this.open("tr");
            this.open("td");
            String path = subResource.getPathFrom(this.resource);
            if (subResource != realSubResource) {
                String realPath = realSubResource.getName();
                this.around("a href='" + realPath + "/index.html'", realPath);
                this.tag("br");
                this.print(" \u21b3 ");
                this.open("span class='deep-resource'");
                this.around("a href='" + path + "/index.html'", path);
                this.close("span");
            } else {
                this.around("a href='" + path + "/index.html'", path);
            }
            this.close("td");
            this.open("td");
            Doc javaDoc = subResource.getJavaDoc();
            if (javaDoc != null && javaDoc.firstSentenceTags() != null) {
                this.writer.printSummaryComment(javaDoc);
            }
            this.close("td");
            this.close("tr");
        }
        this.close("tbody");
        this.close("table");
    }

    private Resource deepFilter(Resource resource) {
        if (resource.hasRealMethods()) {
            return resource;
        }
        if (resource.getResources().size() > 1) {
            return resource;
        }
        return this.deepFilter(resource.getResources().values().iterator().next());
    }

    private void printResourceInfo() {
        this.open("h2");
        this.print("Path: ");
        String jaxrscontext = ((JAXRSConfiguration)this.configuration).jaxrscontext;
        String name = this.resource.getName();
        if (Utils.isEmptyOrNull(name)) {
            name = Utils.unStartSlashify(Utils.unEndSlashify(jaxrscontext));
        }
        StringBuffer buf = new StringBuffer(name);
        Resource _resource = this.resource;
        String rel = "";
        while ((_resource = _resource.getParent()) != null) {
            rel = "../" + rel;
            String resourceName = _resource.getName();
            if (Utils.isEmptyOrNull(resourceName)) {
                resourceName = !Utils.isEmptyOrNull(jaxrscontext) ? Utils.unStartSlashify(Utils.unEndSlashify(jaxrscontext)) : "/";
            }
            String href = "<a href='" + rel + "index.html'>" + resourceName;
            href = resourceName.equals("/") ? href + "</a> " : href + "</a> / ";
            buf.insert(0, href);
        }
        if (!Utils.isEmptyOrNull(jaxrscontext)) {
            this.print("/ ");
        }
        if (buf.length() == 0) {
            this.print("/");
        } else {
            this.print(buf.toString());
        }
        this.close("h2");
        Doc javaDoc = this.resource.getJavaDoc();
        if (javaDoc != null && javaDoc.tags() != null) {
            this.writer.printInlineComment(javaDoc);
        }
        boolean needsPathHeading = true;
        List<ResourceMethod> lrm = this.resource.getMethods();
        if (lrm.size() != 0) {
            ResourceMethod rm = lrm.get(0);
            Map<String, MethodParameter> parameters = rm.getPathParameters();
            for (MethodParameter param : parameters.values()) {
                if (needsPathHeading) {
                    this.open("dl");
                    this.open("dt");
                    this.around("b", "Path parameters:");
                    this.close("dt");
                    needsPathHeading = false;
                }
                this.open("dd");
                this.around("b", param.getName());
                String regex = rm.getPathParamRegex(param.getName());
                if (regex != null) {
                    this.around("tt", " (" + regex + ")");
                }
                this.print(" - " + param.getDoc());
                this.close("dd");
            }
            if (!needsPathHeading) {
                this.close("dl");
            }
        }
    }

    private void printHeader(boolean isRoot) {
        if (isRoot) {
            this.printHeader("Root Resource");
        } else {
            this.printHeader("Resource " + this.resource.getName());
        }
    }

    @Override
    protected void printThirdMenu() {
        this.open("tr");
        this.open("td class='NavBarCell3'");
        this.print("summary: ");
        this.printLink(!this.resource.getResources().isEmpty(), "#resources", "resource");
        this.print(" | ");
        this.printLink(this.resource.hasRealMethods(), "#methods-summary", "method");
        this.close("td");
        this.open("td class='NavBarCell3'");
        this.print("detail: ");
        this.printLink(this.resource.hasRealMethods(), "#methods-details", "method");
        this.close("td", "tr");
    }
}

