/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxrs.writers;

import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxrs.JAXRSDoclet;
import com.lunatech.doclets.jax.jaxrs.model.MethodOutput;
import com.lunatech.doclets.jax.jaxrs.model.MethodParameter;
import com.lunatech.doclets.jax.jaxrs.model.ResourceMethod;
import com.lunatech.doclets.jax.jaxrs.writers.DocletWriter;
import com.lunatech.doclets.jax.jaxrs.writers.ResourceWriter;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.TagletOutputImpl;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.taglets.TagletOutput;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodWriter
extends DocletWriter {
    private ResourceMethod method;

    public MethodWriter(ResourceMethod method, ResourceWriter resourceWriter, JAXRSDoclet doclet) {
        super(resourceWriter.getConfiguration(), resourceWriter.getWriter(), resourceWriter.getResource(), doclet);
        this.method = method;
    }

    public void print() {
        for (String httpMethod : this.method.getMethods()) {
            this.printMethod(httpMethod);
        }
    }

    private void printMethod(String httpMethod) {
        this.around("a name='" + httpMethod + "'", "");
        this.open("table class='examples'", "tr", "td");
        this.printHTTPExample(httpMethod);
        this.close("td");
        this.open("td");
        this.printAPIExample();
        this.close("td", "tr", "table");
        if (!Utils.isEmptyOrNull(this.method.getDoc())) {
            this.open("p");
            this.print(this.method.getDoc());
            this.close("p");
        }
        this.printIncludes();
        this.open("dl");
        this.printInput();
        this.printOutput();
        this.printParameters(this.method.getQueryParameters(), "Query");
        this.printParameters(this.method.getMatrixParameters(), "Matrix");
        this.printParameters(this.method.getFormParameters(), "Form");
        this.printParameters(this.method.getCookieParameters(), "Cookie");
        this.printParameters(this.method.getHeaderParameters(), "Header");
        this.printMIMEs(this.method.getProduces(), "Produces");
        this.printMIMEs(this.method.getConsumes(), "Consumes");
        this.printHTTPCodes();
        this.printHTTPRequestHeaders();
        this.printHTTPResponseHeaders();
        this.close("dl");
    }

    private void printIncludes() {
        MethodDoc javaDoc = this.method.getJavaDoc();
        Tag[] includes = Utils.getTags((Doc)javaDoc, "include");
        if (includes == null) {
            return;
        }
        File relativeTo = javaDoc.containingClass().position().file().getParentFile();
        for (Tag include : includes) {
            String fileName = include.text();
            File file = new File(relativeTo, fileName);
            if (!file.exists()) {
                this.doclet.printError(include.position(), "Missing included file: " + fileName);
                continue;
            }
            String text = Utils.readResource(file);
            this.print(text);
        }
    }

    private void printTaglets(String tagletName) {
        MethodDoc javaDoc = this.method.getJavaDoc();
        TagletOutputImpl output = new TagletOutputImpl("");
        HashSet<String> tagletsSet = new HashSet<String>();
        tagletsSet.add(tagletName);
        Utils.genTagOuput(this.configuration.parentConfiguration.tagletManager, (Doc)javaDoc, this.configuration.parentConfiguration.tagletManager.getCustomTags((Doc)javaDoc), this.writer.getTagletWriterInstance(false), (TagletOutput)output, tagletsSet);
        this.writer.print(output.toString());
    }

    private void printHTTPRequestHeaders() {
        this.printTaglets("ResponseHeader");
    }

    private void printHTTPResponseHeaders() {
        this.printTaglets("RequestHeader");
    }

    private void printHTTPCodes() {
        this.printTaglets("HTTP");
    }

    private void printOutput() {
        this.open("dt");
        this.around("b", "Output:");
        this.close("dt");
        MethodOutput output = this.method.getOutput();
        if (output.isOutputWrapped()) {
            for (int i = 0; i < output.getOutputWrappedCount(); ++i) {
                this.open("dd");
                String typeName = output.getWrappedOutputType(i);
                Utils.JaxType returnType = null;
                try {
                    returnType = Utils.parseType(typeName, this.method.getJavaDoc().containingClass(), this.doclet);
                }
                catch (Utils.InvalidJaxTypeException e) {
                    this.doclet.warn("Invalid @returnWrapped type: " + typeName);
                    e.printStackTrace();
                }
                if (returnType != null) {
                    this.printOutputType(returnType);
                } else {
                    this.around("tt", this.escape(typeName));
                }
                if (output.getOutputDoc(i) != null) {
                    this.print(" - ");
                    this.print(output.getOutputDoc(i));
                }
                this.close("dd");
            }
        } else {
            this.open("dd");
            Type returnType = output.getOutputType();
            this.printOutputType(returnType);
            if (output.getOutputDoc() != null) {
                this.print(" - ");
                this.print(output.getOutputDoc());
            }
            this.close("dd");
        }
    }

    private void printOutputType(Type type) {
        this.open("tt");
        this.printOutputGenericType(type);
        this.close("tt");
    }

    private void printOutputGenericType(Type type) {
        String link = null;
        if (!type.isPrimitive()) {
            link = Utils.getExternalLink((Configuration)this.configuration.parentConfiguration, type, this.writer);
        }
        if (link == null) {
            this.print(type.qualifiedTypeName());
        } else {
            this.around("a href='" + link + "'", type.typeName());
        }
        ParameterizedType pType = type.asParameterizedType();
        if (pType != null) {
            boolean first = true;
            this.print("&lt;");
            for (Type genericType : pType.typeArguments()) {
                if (first) {
                    first = false;
                } else {
                    this.print(",");
                }
                this.printOutputGenericType(genericType);
            }
            this.print("&gt;");
        }
        this.print(type.dimension());
    }

    private void printOutputType(Utils.JaxType type) {
        this.open("tt");
        this.printOutputGenericType(type);
        this.close("tt");
    }

    private void printOutputGenericType(Utils.JaxType type) {
        String link = null;
        if (type.getType() == null) {
            this.doclet.warn("Type information not found: " + type.getTypeName());
            this.print(type.getTypeName());
            return;
        }
        if (!type.getType().isPrimitive()) {
            link = Utils.getExternalLink((Configuration)this.configuration.parentConfiguration, type.getType(), this.writer);
        }
        if (link == null) {
            this.print(type.getType().qualifiedTypeName());
        } else {
            this.around("a href='" + link + "'", type.getType().typeName());
        }
        if (type.hasParameters()) {
            boolean first = true;
            this.print("&lt;");
            for (Utils.JaxType genericType : type.getParameters()) {
                if (first) {
                    first = false;
                } else {
                    this.print(",");
                }
                this.printOutputGenericType(genericType);
            }
            this.print("&gt;");
        }
        this.print(type.getDimension());
    }

    private void printInput() {
        MethodParameter inputParameter = this.method.getInputParameter();
        if (inputParameter == null) {
            return;
        }
        this.open("dt");
        this.around("b", "Input:");
        this.close("dt");
        if (inputParameter.isWrapped()) {
            this.open("dd");
            String typeName = inputParameter.getWrappedType();
            Utils.JaxType returnType = null;
            try {
                returnType = Utils.parseType(typeName, this.method.getJavaDoc().containingClass(), this.doclet);
            }
            catch (Utils.InvalidJaxTypeException e) {
                this.doclet.warn("Invalid @returnWrapped type: " + typeName);
                e.printStackTrace();
            }
            if (returnType != null) {
                this.printOutputType(returnType);
            } else {
                this.around("tt", this.escape(typeName));
            }
        } else {
            this.open("dd");
            Type returnType = inputParameter.getType();
            this.printOutputType(returnType);
        }
        String doc = inputParameter.getDoc();
        if (!Utils.isEmptyOrNull(doc)) {
            this.print(" - ");
            this.print(doc);
        }
        this.close("dd");
    }

    private void printParameters(Map<String, MethodParameter> parameters, String header) {
        if (parameters.isEmpty()) {
            return;
        }
        this.open("dt");
        this.around("b", header + " parameters:");
        this.close("dt");
        for (MethodParameter param : parameters.values()) {
            this.open("dd");
            this.around("b", param.getName());
            String doc = param.getDoc();
            if (!Utils.isEmptyOrNull(doc)) {
                this.print(" - " + param.getDoc());
            }
            this.close("dd");
        }
    }

    private void printMIMEs(List<String> mimes, String header) {
        if (!mimes.isEmpty()) {
            this.open("dt");
            this.around("b", header + ":");
            this.close("dt");
            for (String mime : mimes) {
                this.open("dd");
                this.print(mime);
                this.close("dd");
            }
        }
    }

    private void printAPIExample() {
        this.around("b", "API Example:");
        this.open("p");
        this.open("tt");
        this.print(this.method.getAPIFunctionName());
        this.print("({");
        boolean hasOne = this.printAPIParameters(this.method.getMatrixParameters(), false);
        hasOne |= this.printAPIParameters(this.method.getQueryParameters(), hasOne);
        hasOne |= this.printAPIParameters(this.method.getPathParameters(), hasOne);
        hasOne |= this.printAPIParameters(this.method.getHeaderParameters(), hasOne);
        hasOne |= this.printAPIParameters(this.method.getCookieParameters(), hasOne);
        hasOne |= this.printAPIParameters(this.method.getFormParameters(), hasOne);
        MethodParameter input = this.method.getInputParameter();
        if (input != null) {
            this.printAPIParameter("$entity", input, hasOne);
        }
        this.print("});");
        this.close("tt");
        this.close("p");
    }

    private boolean printAPIParameters(Map<String, MethodParameter> parameters, boolean hasOne) {
        for (String name : parameters.keySet()) {
            this.printAPIParameter(name, parameters.get(name), hasOne);
            hasOne = true;
        }
        return hasOne;
    }

    private void printAPIParameter(String name, MethodParameter param, boolean hasOne) {
        if (hasOne) {
            this.print(",");
            this.tag("br");
            this.print("&nbsp;&nbsp;");
        }
        hasOne = true;
        this.print("'" + name + "': ");
        Tag[] tags = param.getFirstSentenceTags();
        if (tags != null && tags.length > 0) {
            this.open("span class='comment'");
            this.print("/* ");
            this.writer.printSummaryComment(param.getParameterDoc(), tags);
            this.print(" */");
            this.close("span");
        } else {
            this.print("\u2026");
        }
    }

    private void printHTTPExample(String httpMethod) {
        Map<String, MethodParameter> formParameters;
        Map<String, MethodParameter> cookieParameters;
        Map<String, MethodParameter> queryParameters;
        this.around("b", "HTTP Example:");
        this.open("pre");
        String absPath = Utils.getAbsolutePath(this, this.resource);
        this.print(httpMethod + " " + absPath);
        Map<String, MethodParameter> matrixParameters = this.method.getMatrixParameters();
        if (!matrixParameters.isEmpty()) {
            for (String name : matrixParameters.keySet()) {
                this.print(";");
                this.print(name);
                this.print("=\u2026");
            }
        }
        if (!(queryParameters = this.method.getQueryParameters()).isEmpty()) {
            this.print("?");
            boolean first = true;
            for (String name : queryParameters.keySet()) {
                if (!first) {
                    this.print("&");
                }
                this.print(name);
                this.print("=\u2026");
                first = false;
            }
        }
        this.print("\n");
        Map<String, MethodParameter> headerParameters = this.method.getHeaderParameters();
        if (!headerParameters.isEmpty()) {
            for (String name : headerParameters.keySet()) {
                this.print(name);
                this.print(": \u2026\n");
            }
        }
        if (!(cookieParameters = this.method.getCookieParameters()).isEmpty()) {
            for (String name : cookieParameters.keySet()) {
                this.print("Cookie: ");
                this.print(name);
                this.print("=\u2026\n");
            }
        }
        if (!(formParameters = this.method.getFormParameters()).isEmpty()) {
            this.print("\n");
            boolean first = true;
            for (String name : formParameters.keySet()) {
                if (!first) {
                    this.print("&");
                }
                this.print(name);
                this.print("=\u2026");
                first = false;
            }
        }
        this.print("\n");
        this.close("pre");
    }
}

