/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxrs.model;

import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxrs.model.FormFieldParameter;
import com.lunatech.doclets.jax.jaxrs.model.FormMethodParameter;
import com.lunatech.doclets.jax.jaxrs.model.MethodOutput;
import com.lunatech.doclets.jax.jaxrs.model.MethodParameter;
import com.lunatech.doclets.jax.jaxrs.model.MethodParameterType;
import com.lunatech.doclets.jax.jaxrs.model.RealMethodParameter;
import com.lunatech.doclets.jax.jaxrs.model.Resource;
import com.lunatech.doclets.jax.jaxrs.model.ResourceClass;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMethod
implements Comparable<ResourceMethod> {
    public static final Class<?>[] MethodAnnotations = new Class[]{GET.class, POST.class, PUT.class, HEAD.class, DELETE.class};
    private MethodDoc declaringMethod;
    private String path;
    private Map<String, String> regexFragments = new HashMap<String, String>();
    private ResourceClass resource;
    private ClassDoc declaringClass;
    private MethodDoc method;
    final Map<String, MethodParameter> pathParameters = new HashMap<String, MethodParameter>();
    final Map<String, MethodParameter> matrixParameters = new HashMap<String, MethodParameter>();
    final Map<String, MethodParameter> queryParameters = new HashMap<String, MethodParameter>();
    final Map<String, MethodParameter> headerParameters = new HashMap<String, MethodParameter>();
    final Map<String, MethodParameter> cookieParameters = new HashMap<String, MethodParameter>();
    final Map<String, MethodParameter> formParameters = new HashMap<String, MethodParameter>();
    private List<AnnotationDesc> methods = new LinkedList<AnnotationDesc>();
    private AnnotationDesc producesAnnotation;
    private AnnotationDesc consumesAnnotation;
    private MethodParameter inputParameter;
    private MethodOutput output;
    private ResourceClass resourceLocator;
    private Class<?> formClass;

    public ResourceMethod(MethodDoc method, MethodDoc declaringMethod, ResourceClass resource) {
        this.resource = resource;
        this.method = method;
        this.declaringClass = resource.getDeclaringClass();
        this.declaringMethod = declaringMethod;
        this.output = new MethodOutput(declaringMethod);
        try {
            this.formClass = Class.forName("org.jboss.resteasy.annotations.Form");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        this.setupPath();
        this.setupParameters();
        this.setupMethods();
        this.setupMIMEs();
        if (this.methods.isEmpty() && !declaringMethod.returnType().isPrimitive()) {
            this.resourceLocator = new ResourceClass(declaringMethod.returnType().asClassDoc(), this);
        }
    }

    public MethodOutput getOutput() {
        return this.output;
    }

    private void setupMIMEs() {
        this.producesAnnotation = Utils.findMethodAnnotation(this.declaringClass, this.method, Utils.getProducesClass());
        this.consumesAnnotation = Utils.findMethodAnnotation(this.declaringClass, this.method, Utils.getConsumesClass());
        if (this.producesAnnotation == null) {
            this.producesAnnotation = this.resource.getProducesAnnotation();
        }
        if (this.consumesAnnotation == null) {
            this.consumesAnnotation = this.resource.getConsumesAnnotation();
        }
    }

    private void setupMethods() {
        for (Class<?> methodAnnotation : MethodAnnotations) {
            AnnotationDesc annotation = Utils.findMethodAnnotation(this.declaringClass, this.method, methodAnnotation);
            if (annotation == null) continue;
            this.methods.add(annotation);
        }
    }

    private void setupParameters() {
        int i = -1;
        for (Parameter parameter : this.method.parameters()) {
            AnnotationDesc formAnnotation;
            AnnotationDesc pathParamAnnotation;
            if ((pathParamAnnotation = Utils.findParameterAnnotation(this.declaringMethod, parameter, ++i, PathParam.class)) != null) {
                String name = (String)Utils.getAnnotationValue(pathParamAnnotation);
                this.pathParameters.put(name, new RealMethodParameter(parameter, i, pathParamAnnotation, MethodParameterType.Path, this.declaringMethod));
                continue;
            }
            AnnotationDesc matrixParamAnnotation = Utils.findParameterAnnotation(this.declaringMethod, parameter, i, MatrixParam.class);
            if (matrixParamAnnotation != null) {
                String name = (String)Utils.getAnnotationValue(matrixParamAnnotation);
                this.matrixParameters.put(name, new RealMethodParameter(parameter, i, matrixParamAnnotation, MethodParameterType.Matrix, this.declaringMethod));
                continue;
            }
            AnnotationDesc queryParamAnnotation = Utils.findParameterAnnotation(this.declaringMethod, parameter, i, QueryParam.class);
            if (queryParamAnnotation != null) {
                String name = (String)Utils.getAnnotationValue(queryParamAnnotation);
                this.queryParameters.put(name, new RealMethodParameter(parameter, i, queryParamAnnotation, MethodParameterType.Query, this.declaringMethod));
                continue;
            }
            AnnotationDesc cookieParamAnnotation = Utils.findParameterAnnotation(this.declaringMethod, parameter, i, CookieParam.class);
            if (cookieParamAnnotation != null) {
                String name = (String)Utils.getAnnotationValue(cookieParamAnnotation);
                this.cookieParameters.put(name, new RealMethodParameter(parameter, i, cookieParamAnnotation, MethodParameterType.Cookie, this.declaringMethod));
                continue;
            }
            AnnotationDesc formParamAnnotation = Utils.findParameterAnnotation(this.declaringMethod, parameter, i, FormParam.class);
            if (formParamAnnotation != null) {
                String name = (String)Utils.getAnnotationValue(formParamAnnotation);
                this.formParameters.put(name, new RealMethodParameter(parameter, i, formParamAnnotation, MethodParameterType.Form, this.declaringMethod));
                continue;
            }
            AnnotationDesc headerParamAnnotation = Utils.findParameterAnnotation(this.declaringMethod, parameter, i, HeaderParam.class);
            if (headerParamAnnotation != null) {
                String name = (String)Utils.getAnnotationValue(headerParamAnnotation);
                this.headerParameters.put(name, new RealMethodParameter(parameter, i, headerParamAnnotation, MethodParameterType.Header, this.declaringMethod));
                continue;
            }
            if (this.formClass != null && (formAnnotation = Utils.findParameterAnnotation(this.declaringMethod, parameter, i, this.formClass)) != null) {
                this.walkFormParameter(parameter.type().asClassDoc());
                continue;
            }
            AnnotationDesc contextAnnotation = Utils.findParameterAnnotation(this.declaringMethod, parameter, i, Context.class);
            if (contextAnnotation != null) continue;
            this.inputParameter = new RealMethodParameter(parameter, i, null, MethodParameterType.Input, this.declaringMethod);
        }
    }

    private void walkFormParameter(ClassDoc formDoc) {
        String name;
        for (FieldDoc fieldDoc : formDoc.fields(false)) {
            AnnotationDesc pathParamAnnotation = Utils.findAnnotation((ProgramElementDoc)fieldDoc, PathParam.class);
            if (pathParamAnnotation != null) {
                String name6 = (String)Utils.getAnnotationValue(pathParamAnnotation);
                this.pathParameters.put(name6, new FormFieldParameter(fieldDoc, pathParamAnnotation, MethodParameterType.Path));
                continue;
            }
            AnnotationDesc matrixParamAnnotation = Utils.findAnnotation((ProgramElementDoc)fieldDoc, MatrixParam.class);
            if (matrixParamAnnotation != null) {
                String name5 = (String)Utils.getAnnotationValue(matrixParamAnnotation);
                this.matrixParameters.put(name5, new FormFieldParameter(fieldDoc, matrixParamAnnotation, MethodParameterType.Matrix));
                continue;
            }
            AnnotationDesc queryParamAnnotation = Utils.findAnnotation((ProgramElementDoc)fieldDoc, QueryParam.class);
            if (queryParamAnnotation != null) {
                String name4 = (String)Utils.getAnnotationValue(queryParamAnnotation);
                this.queryParameters.put(name4, new FormFieldParameter(fieldDoc, queryParamAnnotation, MethodParameterType.Query));
                continue;
            }
            AnnotationDesc headerParamAnnotation = Utils.findAnnotation((ProgramElementDoc)fieldDoc, HeaderParam.class);
            if (headerParamAnnotation != null) {
                String name3 = (String)Utils.getAnnotationValue(headerParamAnnotation);
                this.headerParameters.put(name3, new FormFieldParameter(fieldDoc, headerParamAnnotation, MethodParameterType.Header));
                continue;
            }
            AnnotationDesc cookieParamAnnotation = Utils.findAnnotation((ProgramElementDoc)fieldDoc, CookieParam.class);
            if (cookieParamAnnotation != null) {
                String name2 = (String)Utils.getAnnotationValue(cookieParamAnnotation);
                this.cookieParameters.put(name2, new FormFieldParameter(fieldDoc, cookieParamAnnotation, MethodParameterType.Cookie));
                continue;
            }
            AnnotationDesc formParamAnnotation = Utils.findAnnotation((ProgramElementDoc)fieldDoc, FormParam.class);
            if (formParamAnnotation != null) {
                name = (String)Utils.getAnnotationValue(formParamAnnotation);
                this.formParameters.put(name, new FormFieldParameter(fieldDoc, formParamAnnotation, MethodParameterType.Form));
                continue;
            }
            AnnotationDesc contextAnnotation = Utils.findAnnotation((ProgramElementDoc)fieldDoc, Context.class);
            if (contextAnnotation != null) continue;
            this.inputParameter = new FormFieldParameter(fieldDoc, null, MethodParameterType.Input);
        }
        for (FieldDoc fieldDoc : formDoc.methods(false)) {
            if (!fieldDoc.returnType().qualifiedTypeName().equals("void") || fieldDoc.parameters().length != 1 || !fieldDoc.name().startsWith("set")) continue;
            Parameter parameter = fieldDoc.parameters()[0];
            AnnotationDesc pathParamAnnotation = Utils.findParameterAnnotation((MethodDoc)fieldDoc, parameter, 0, PathParam.class);
            if (pathParamAnnotation != null) {
                String name2 = (String)Utils.getAnnotationValue(pathParamAnnotation);
                this.pathParameters.put(name2, new FormMethodParameter((MethodDoc)fieldDoc, pathParamAnnotation, MethodParameterType.Path));
                continue;
            }
            AnnotationDesc matrixParamAnnotation = Utils.findParameterAnnotation((MethodDoc)fieldDoc, parameter, 0, MatrixParam.class);
            if (matrixParamAnnotation != null) {
                String name3 = (String)Utils.getAnnotationValue(matrixParamAnnotation);
                this.matrixParameters.put(name3, new FormMethodParameter((MethodDoc)fieldDoc, matrixParamAnnotation, MethodParameterType.Matrix));
                continue;
            }
            AnnotationDesc queryParamAnnotation = Utils.findParameterAnnotation((MethodDoc)fieldDoc, parameter, 0, QueryParam.class);
            if (queryParamAnnotation != null) {
                String name4 = (String)Utils.getAnnotationValue(queryParamAnnotation);
                this.queryParameters.put(name4, new FormMethodParameter((MethodDoc)fieldDoc, queryParamAnnotation, MethodParameterType.Query));
                continue;
            }
            AnnotationDesc headerParamAnnotation = Utils.findParameterAnnotation((MethodDoc)fieldDoc, parameter, 0, HeaderParam.class);
            if (headerParamAnnotation != null) {
                String name5 = (String)Utils.getAnnotationValue(headerParamAnnotation);
                this.headerParameters.put(name5, new FormMethodParameter((MethodDoc)fieldDoc, headerParamAnnotation, MethodParameterType.Header));
                continue;
            }
            AnnotationDesc cookieParamAnnotation = Utils.findParameterAnnotation((MethodDoc)fieldDoc, parameter, 0, CookieParam.class);
            if (cookieParamAnnotation != null) {
                name = (String)Utils.getAnnotationValue(cookieParamAnnotation);
                this.cookieParameters.put(name, new FormMethodParameter((MethodDoc)fieldDoc, cookieParamAnnotation, MethodParameterType.Cookie));
                continue;
            }
            AnnotationDesc formParamAnnotation = Utils.findParameterAnnotation((MethodDoc)fieldDoc, parameter, 0, FormParam.class);
            if (formParamAnnotation != null) {
                String name7 = (String)Utils.getAnnotationValue(formParamAnnotation);
                this.formParameters.put(name7, new FormMethodParameter((MethodDoc)fieldDoc, formParamAnnotation, MethodParameterType.Form));
                continue;
            }
            AnnotationDesc contextAnnotation = Utils.findParameterAnnotation((MethodDoc)fieldDoc, parameter, 0, Context.class);
            if (contextAnnotation != null) continue;
            this.inputParameter = new FormMethodParameter((MethodDoc)fieldDoc, null, MethodParameterType.Input);
        }
    }

    private void setupPath() {
        AnnotationDesc pathAnnotation = Utils.findMethodAnnotation(this.declaringClass, this.method, Path.class);
        String rootPath = this.resource.getPath();
        if (pathAnnotation != null) {
            String path = (String)Utils.getAnnotationValue(pathAnnotation);
            path = Utils.removeFragmentRegexes(path, this.regexFragments);
            this.path = Utils.appendURLFragments(rootPath, path);
        } else {
            this.path = rootPath;
        }
    }

    @Override
    public int compareTo(ResourceMethod other) {
        return this.path.compareTo(other.path);
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer(this.path);
        strbuf.append(" ");
        for (AnnotationDesc method : this.methods) {
            strbuf.append(method.annotationType().name());
            strbuf.append(" ");
        }
        return strbuf.toString();
    }

    public List<String> getMethods() {
        ArrayList<String> httpMethods = new ArrayList<String>(this.methods.size());
        for (AnnotationDesc method : this.methods) {
            httpMethods.add(method.annotationType().name());
        }
        return httpMethods;
    }

    public List<String> getProduces() {
        if (this.getProducesAnnotation() == null) {
            return Collections.emptyList();
        }
        ArrayList<String> producedMIMEs = new ArrayList<String>();
        for (String mime : Utils.getAnnotationValues(this.getProducesAnnotation())) {
            producedMIMEs.add(mime);
        }
        return producedMIMEs;
    }

    public List<String> getConsumes() {
        if (this.getConsumesAnnotation() == null) {
            return Collections.emptyList();
        }
        ArrayList<String> consumedMIMEs = new ArrayList<String>();
        for (String mime : Utils.getAnnotationValues(this.getConsumesAnnotation())) {
            consumedMIMEs.add(mime);
        }
        return consumedMIMEs;
    }

    public MethodDoc getJavaDoc() {
        return this.declaringMethod;
    }

    public String getDoc() {
        return this.declaringMethod.commentText();
    }

    public Tag[] getDocFirstSentence() {
        return this.declaringMethod.firstSentenceTags();
    }

    public Map<String, MethodParameter> getQueryParameters() {
        if (this.resource.isSubResource()) {
            HashMap<String, MethodParameter> allQueryParameters = new HashMap<String, MethodParameter>(this.resource.getParentMethod().getQueryParameters());
            allQueryParameters.putAll(this.queryParameters);
            return allQueryParameters;
        }
        return this.queryParameters;
    }

    public Map<String, MethodParameter> getPathParameters() {
        if (this.resource.isSubResource()) {
            HashMap<String, MethodParameter> allPathParameters = new HashMap<String, MethodParameter>(this.resource.getParentMethod().getPathParameters());
            allPathParameters.putAll(this.pathParameters);
            return allPathParameters;
        }
        return this.pathParameters;
    }

    public Map<String, MethodParameter> getMatrixParameters() {
        if (this.resource.isSubResource()) {
            HashMap<String, MethodParameter> allMatrixParameters = new HashMap<String, MethodParameter>(this.resource.getParentMethod().getMatrixParameters());
            allMatrixParameters.putAll(this.matrixParameters);
            return allMatrixParameters;
        }
        return this.matrixParameters;
    }

    public Map<String, MethodParameter> getCookieParameters() {
        if (this.resource.isSubResource()) {
            HashMap<String, MethodParameter> allCookieParameters = new HashMap<String, MethodParameter>(this.resource.getParentMethod().getCookieParameters());
            allCookieParameters.putAll(this.cookieParameters);
            return allCookieParameters;
        }
        return this.cookieParameters;
    }

    public Map<String, MethodParameter> getHeaderParameters() {
        if (this.resource.isSubResource()) {
            HashMap<String, MethodParameter> allHeaderParameters = new HashMap<String, MethodParameter>(this.resource.getParentMethod().getHeaderParameters());
            allHeaderParameters.putAll(this.headerParameters);
            return allHeaderParameters;
        }
        return this.headerParameters;
    }

    public Map<String, MethodParameter> getFormParameters() {
        if (this.resource.isSubResource()) {
            HashMap<String, MethodParameter> allFormParameters = new HashMap<String, MethodParameter>(this.resource.getParentMethod().getFormParameters());
            allFormParameters.putAll(this.formParameters);
            return allFormParameters;
        }
        return this.formParameters;
    }

    public String getPath() {
        return this.path;
    }

    public MethodParameter getInputParameter() {
        return this.inputParameter;
    }

    public boolean isGET() {
        return this.hasHTTPMethod(GET.class);
    }

    public boolean hasHTTPMethod(Class<? extends Annotation> method) {
        return Utils.findAnnotation(this.methods.toArray(new AnnotationDesc[0]), method) != null;
    }

    public String getURL(Resource resource) {
        Map<String, MethodParameter> queryParameters;
        StringBuffer strbuf = new StringBuffer(resource.getAbsolutePath());
        Map<String, MethodParameter> matrixParameters = this.getMatrixParameters();
        if (!matrixParameters.isEmpty()) {
            boolean first = true;
            for (String name : matrixParameters.keySet()) {
                strbuf.append(";");
                strbuf.append(name);
                strbuf.append("=\u2026");
                first = false;
            }
        }
        if (!(queryParameters = this.getQueryParameters()).isEmpty()) {
            strbuf.append("?");
            boolean first = true;
            for (String name : queryParameters.keySet()) {
                if (!first) {
                    strbuf.append("&");
                }
                strbuf.append(name);
                strbuf.append("=\u2026");
                first = false;
            }
        }
        return strbuf.toString();
    }

    public AnnotationDesc getProducesAnnotation() {
        if (this.producesAnnotation != null) {
            return this.producesAnnotation;
        }
        if (this.resource.isSubResource()) {
            return this.resource.getProducesAnnotation();
        }
        return null;
    }

    public AnnotationDesc getConsumesAnnotation() {
        if (this.consumesAnnotation != null) {
            return this.consumesAnnotation;
        }
        if (this.resource.isSubResource()) {
            return this.resource.getConsumesAnnotation();
        }
        return null;
    }

    public ResourceClass getResourceLocator() {
        return this.resourceLocator;
    }

    public boolean isResourceLocator() {
        return this.resourceLocator != null;
    }

    public String getAPIFunctionName() {
        return this.declaringClass.name() + "." + this.declaringMethod.name();
    }

    public String getPathParamRegex(String name) {
        if (this.regexFragments.containsKey(name)) {
            return this.regexFragments.get(name);
        }
        return this.resource.getPathParamRegex(name);
    }
}

