/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxrs.model;

import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxrs.model.ResourceMethod;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceClass {
    private List<ResourceMethod> methods = new LinkedList<ResourceMethod>();
    private ClassDoc declaringClass;
    private AnnotationDesc rootPathAnnotation;
    private AnnotationDesc rootProducesAnnotation;
    private AnnotationDesc rootConsumesAnnotation;
    private ResourceMethod parentMethod;
    private String path;
    private Map<String, String> regexFragments = new HashMap<String, String>();

    public ResourceClass(ClassDoc resourceClass, ResourceMethod methodLocator) {
        this.parentMethod = methodLocator;
        this.declaringClass = Utils.findAnnotatedClass(resourceClass, Path.class);
        if (this.declaringClass == null) {
            this.declaringClass = resourceClass;
        }
        this.rootPathAnnotation = Utils.findAnnotation((ProgramElementDoc)this.declaringClass, Path.class);
        this.rootProducesAnnotation = Utils.findAnnotation((ProgramElementDoc)this.declaringClass, Utils.getProducesClass());
        this.rootConsumesAnnotation = Utils.findAnnotation((ProgramElementDoc)this.declaringClass, Utils.getConsumesClass());
        this.setupPath();
        HashMap<String, LinkedList<MethodDoc>> handledMethods = new HashMap<String, LinkedList<MethodDoc>>();
        do {
            block1: for (MethodDoc method : resourceClass.methods(false)) {
                MethodDoc declaringMethod;
                LinkedList<MethodDoc> overridingMethods = (LinkedList<MethodDoc>)handledMethods.get(method.name());
                if (overridingMethods != null) {
                    for (MethodDoc overridingMethod : overridingMethods) {
                        if (!overridingMethod.overrides(method)) continue;
                        continue block1;
                    }
                }
                if ((declaringMethod = Utils.findAnnotatedMethod(this.declaringClass, method, Path.class, GET.class, PUT.class, DELETE.class, HEAD.class, POST.class)) == null) continue;
                this.methods.add(new ResourceMethod(method, declaringMethod, this));
                if (overridingMethods == null) {
                    overridingMethods = new LinkedList<MethodDoc>();
                    handledMethods.put(method.name(), overridingMethods);
                }
                overridingMethods.add(method);
            }
        } while ((resourceClass = resourceClass.superclass()) != null);
    }

    private void setupPath() {
        if (this.rootPathAnnotation != null) {
            this.path = (String)Utils.getAnnotationValue(this.rootPathAnnotation);
            this.path = Utils.removeFragmentRegexes(this.path, this.regexFragments);
            if (!this.path.startsWith("/")) {
                this.path = "/" + this.path;
            }
        } else {
            this.path = null;
        }
        if (this.parentMethod != null) {
            this.path = Utils.appendURLFragments(this.parentMethod.getPath(), this.path);
        }
    }

    public ClassDoc getDeclaringClass() {
        return this.declaringClass;
    }

    public String getPath() {
        return this.path;
    }

    public AnnotationDesc getProducesAnnotation() {
        if (this.rootProducesAnnotation != null) {
            return this.rootProducesAnnotation;
        }
        if (this.parentMethod != null) {
            return this.parentMethod.getProducesAnnotation();
        }
        return null;
    }

    public AnnotationDesc getConsumesAnnotation() {
        if (this.rootConsumesAnnotation != null) {
            return this.rootConsumesAnnotation;
        }
        if (this.parentMethod != null) {
            return this.parentMethod.getConsumesAnnotation();
        }
        return null;
    }

    public Collection<ResourceMethod> getMethods() {
        LinkedList<ResourceMethod> allMethods = new LinkedList<ResourceMethod>(this.methods);
        for (ResourceMethod method : this.methods) {
            if (!method.isResourceLocator()) continue;
            allMethods.addAll(method.getResourceLocator().getMethods());
        }
        return allMethods;
    }

    public ResourceMethod getParentMethod() {
        return this.parentMethod;
    }

    public boolean isSubResource() {
        return this.parentMethod != null;
    }

    public String getPathParamRegex(String name) {
        if (this.regexFragments.containsKey(name)) {
            return this.regexFragments.get(name);
        }
        if (this.isSubResource()) {
            return this.parentMethod.getPathParamRegex(name);
        }
        return null;
    }
}

