/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxrs.model;

import com.lunatech.doclets.jax.JAXConfiguration;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxrs.JAXRSDoclet;
import com.lunatech.doclets.jax.jaxrs.model.ResourceMethod;
import com.lunatech.doclets.jax.jaxrs.writers.ResourceWriter;
import com.sun.javadoc.Doc;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource {
    static final Class<? extends Annotation>[] PreferredHttpMethods = new Class[]{GET.class, HEAD.class, POST.class, PUT.class, DELETE.class};
    Map<String, Resource> subResources = new TreeMap<String, Resource>();
    List<ResourceMethod> methods = new LinkedList<ResourceMethod>();
    String fragment;
    String fragmentWithNoRegex;
    Map<String, String> regexFragments = new HashMap<String, String>();
    private Resource parent;

    public Resource(String fragment, Resource parent) {
        this.fragment = fragment;
        this.parent = parent;
        this.parseFragment();
    }

    private void parseFragment() {
        this.fragmentWithNoRegex = Utils.removeFragmentRegexes(this.fragment, this.regexFragments);
    }

    private ResourceMethod getDocMethod() {
        for (Class<? extends Annotation> httpMethod : PreferredHttpMethods) {
            ResourceMethod method = this.getMethodForHTTPMethod(httpMethod);
            if (method == null) continue;
            return method;
        }
        if (this.methods.isEmpty() && this.subResources.size() == 1) {
            return this.subResources.values().iterator().next().getDocMethod();
        }
        return null;
    }

    private ResourceMethod getMethodForHTTPMethod(Class<? extends Annotation> type) {
        for (ResourceMethod resourceMethod : this.methods) {
            String doc;
            if (!resourceMethod.hasHTTPMethod(type) || Utils.isEmptyOrNull(doc = resourceMethod.getDoc())) continue;
            return resourceMethod;
        }
        return null;
    }

    public String getDoc() {
        ResourceMethod docMethod = this.getDocMethod();
        if (docMethod == null) {
            return "";
        }
        return docMethod.getDoc();
    }

    public Doc getJavaDoc() {
        ResourceMethod docMethod = this.getDocMethod();
        if (docMethod == null) {
            return null;
        }
        return docMethod.getJavaDoc();
    }

    public String getAbsolutePath() {
        if (this.parent != null) {
            return Utils.appendURLFragments(this.parent.getAbsolutePath(), this.getName());
        }
        return "/";
    }

    public static Resource getRootResource(List<ResourceMethod> resourceMethods) {
        Resource rootResource = new Resource("", null);
        for (ResourceMethod resourceMethod : resourceMethods) {
            rootResource.addResourceMethod(resourceMethod);
        }
        return rootResource;
    }

    private void addSubResource(String firstFragment, ResourceMethod resourceMethod) {
        Resource subResource;
        if (this.subResources.containsKey(firstFragment)) {
            subResource = this.subResources.get(firstFragment);
        } else {
            subResource = new Resource(firstFragment, this);
            this.subResources.put(firstFragment, subResource);
        }
        subResource.addResourceMethod(resourceMethod);
    }

    private void addResourceMethod(ResourceMethod resourceMethod) {
        String firstFragment = Utils.getFirstURLFragment(resourceMethod.getPath().substring(this.getAbsolutePath().length()));
        if (firstFragment == null) {
            this.methods.add(resourceMethod);
        } else {
            this.addSubResource(firstFragment, resourceMethod);
        }
    }

    public void dump(int offset) {
        this.dump(offset, "+ /" + this.fragment);
        for (ResourceMethod method : this.methods) {
            this.dump(offset + 1, "+ [M]" + method.toString());
        }
        for (String subResourceKey : this.subResources.keySet()) {
            Resource subResource = this.subResources.get(subResourceKey);
            subResource.dump(offset + 1);
        }
    }

    private void dump(int offset, String fragment) {
        for (int i = 0; i < offset; ++i) {
            System.err.print("| ");
        }
        System.err.println(fragment);
    }

    public String getName() {
        return this.fragmentWithNoRegex;
    }

    public void write(JAXRSDoclet doclet, JAXConfiguration configuration) {
        ResourceWriter writer = new ResourceWriter(configuration, this, doclet);
        writer.write();
        for (String subResourceKey : this.subResources.keySet()) {
            Resource subResource = this.subResources.get(subResourceKey);
            subResource.write(doclet, configuration);
        }
    }

    public Map<String, Resource> getResources() {
        return this.subResources;
    }

    public List<ResourceMethod> getMethods() {
        return this.methods;
    }

    public boolean hasRealMethods() {
        if (this.methods.isEmpty()) {
            return false;
        }
        for (ResourceMethod method : this.methods) {
            if (method.isResourceLocator()) continue;
            return true;
        }
        return false;
    }

    public Resource getParent() {
        return this.parent;
    }

    public String getPathFrom(Resource parent) {
        StringBuffer strbuf = new StringBuffer();
        Resource resource = this;
        while (resource != parent) {
            strbuf.insert(0, resource.getName());
            if ((resource = resource.getParent()) == parent) continue;
            strbuf.insert(0, "/");
        }
        return strbuf.toString();
    }
}

