/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxrs;

import com.lunatech.doclets.jax.JAXDoclet;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxrs.JAXRSConfiguration;
import com.lunatech.doclets.jax.jaxrs.model.Resource;
import com.lunatech.doclets.jax.jaxrs.model.ResourceClass;
import com.lunatech.doclets.jax.jaxrs.model.ResourceMethod;
import com.lunatech.doclets.jax.jaxrs.tags.HTTPTaglet;
import com.lunatech.doclets.jax.jaxrs.tags.IncludeTaglet;
import com.lunatech.doclets.jax.jaxrs.tags.InputWrappedTaglet;
import com.lunatech.doclets.jax.jaxrs.tags.RequestHeaderTaglet;
import com.lunatech.doclets.jax.jaxrs.tags.ResponseHeaderTaglet;
import com.lunatech.doclets.jax.jaxrs.tags.ReturnWrappedTaglet;
import com.lunatech.doclets.jax.jaxrs.writers.IndexWriter;
import com.lunatech.doclets.jax.jaxrs.writers.SummaryWriter;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDoclet;
import com.sun.tools.doclets.internal.toolkit.AbstractDoclet;
import com.sun.tools.doclets.internal.toolkit.taglets.LegacyTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.Taglet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSDoclet
extends JAXDoclet<JAXRSConfiguration> {
    public final HtmlDoclet htmlDoclet = new HtmlDoclet();
    private static final Class<?>[] jaxrsAnnotations = new Class[]{Path.class};
    private List<ResourceMethod> jaxrsMethods = new LinkedList<ResourceMethod>();

    public static int optionLength(String option) {
        if ("-jaxrscontext".equals(option)) {
            return 2;
        }
        return HtmlDoclet.optionLength((String)option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        return HtmlDoclet.validOptions((String[][])options, (DocErrorReporter)reporter);
    }

    public static LanguageVersion languageVersion() {
        return AbstractDoclet.languageVersion();
    }

    public static boolean start(RootDoc rootDoc) {
        new JAXRSDoclet(rootDoc).start();
        return true;
    }

    public JAXRSDoclet(RootDoc rootDoc) {
        super(rootDoc);
        this.htmlDoclet.configuration.tagletManager.addCustomTag((Taglet)new LegacyTaglet((com.sun.tools.doclets.Taglet)new ResponseHeaderTaglet()));
        this.htmlDoclet.configuration.tagletManager.addCustomTag((Taglet)new LegacyTaglet((com.sun.tools.doclets.Taglet)new RequestHeaderTaglet()));
        this.htmlDoclet.configuration.tagletManager.addCustomTag((Taglet)new LegacyTaglet((com.sun.tools.doclets.Taglet)new HTTPTaglet()));
        this.htmlDoclet.configuration.tagletManager.addCustomTag((Taglet)new LegacyTaglet((com.sun.tools.doclets.Taglet)new ReturnWrappedTaglet()));
        this.htmlDoclet.configuration.tagletManager.addCustomTag((Taglet)new LegacyTaglet((com.sun.tools.doclets.Taglet)new InputWrappedTaglet()));
        this.htmlDoclet.configuration.tagletManager.addCustomTag((Taglet)new LegacyTaglet((com.sun.tools.doclets.Taglet)new IncludeTaglet()));
    }

    @Override
    protected JAXRSConfiguration makeConfiguration(ConfigurationImpl configuration) {
        return new JAXRSConfiguration(configuration);
    }

    public void start() {
        ClassDoc[] classes;
        for (ClassDoc klass : classes = ((JAXRSConfiguration)this.conf).parentConfiguration.root.classes()) {
            if (Utils.findAnnotatedClass(klass, jaxrsAnnotations) == null) continue;
            this.handleJAXRSClass(klass);
        }
        Collections.sort(this.jaxrsMethods);
        Resource rootResource = Resource.getRootResource(this.jaxrsMethods);
        rootResource.write(this, this.conf);
        new IndexWriter(this.conf, rootResource).write();
        new SummaryWriter(this.conf, rootResource).write();
        Utils.copyResources(this.conf);
    }

    private void handleJAXRSClass(ClassDoc klass) {
        this.jaxrsMethods.addAll(new ResourceClass(klass, null).getMethods());
    }

    public void warn(String warning) {
        ((JAXRSConfiguration)this.conf).parentConfiguration.root.printWarning(warning);
    }

    public void printError(SourcePosition position, String error) {
        ((JAXRSConfiguration)this.conf).parentConfiguration.root.printError(position, error);
    }
}

