/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxb.writers;

import com.lunatech.doclets.jax.JAXConfiguration;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxb.JAXBConfiguration;
import com.lunatech.doclets.jax.jaxb.model.Attribute;
import com.lunatech.doclets.jax.jaxb.model.Element;
import com.lunatech.doclets.jax.jaxb.model.JAXBClass;
import com.lunatech.doclets.jax.jaxb.model.JAXBMember;
import com.lunatech.doclets.jax.jaxb.model.MemberType;
import com.lunatech.doclets.jax.jaxb.model.Value;
import com.lunatech.doclets.jax.jaxb.writers.DocletWriter;
import com.sun.javadoc.Doc;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import java.io.IOException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBClassWriter
extends DocletWriter {
    public JAXBClassWriter(JAXConfiguration configuration, JAXBClass jaxbClass) {
        super(configuration, JAXBClassWriter.getWriter(configuration, jaxbClass), jaxbClass);
    }

    private static HtmlDocletWriter getWriter(JAXConfiguration configuration, JAXBClass jaxbClass) {
        try {
            return new HtmlDocletWriter(configuration.parentConfiguration, Utils.classToPath(jaxbClass), jaxbClass.getShortClassName() + ".html", Utils.classToRoot(jaxbClass));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void write() {
        this.printHeader();
        this.printMenu("");
        this.printSummary();
        this.printElements();
        this.printAttributes();
        this.printValues();
        this.tag("hr");
        this.printMenu("");
        this.printFooter();
        this.writer.flush();
        this.writer.close();
    }

    private void printElements() {
        this.printMembers(this.jaxbClass.getElements(), "Elements", MemberType.Element);
    }

    private void printAttributes() {
        this.printMembers(this.jaxbClass.getAttributes(), "Attributes", MemberType.Attribute);
    }

    private void printValues() {
        this.printMembers(this.jaxbClass.getValues(), "Value", MemberType.Value);
    }

    private void printMembers(Collection<? extends JAXBMember> members, String title, MemberType type) {
        if (members.isEmpty()) {
            return;
        }
        this.tag("hr");
        this.open("table class='info' id='" + title + "'");
        boolean isValue = type == MemberType.Value;
        this.around("caption class='TableCaption'", title);
        this.open("tbody");
        this.open("tr");
        if (!isValue) {
            this.around("th class='TableHeader'", "Name");
        }
        this.around("th class='TableHeader'", "Type");
        this.around("th class='TableHeader'", "Description");
        this.close("tr");
        for (JAXBMember jAXBMember : members) {
            this.open("tr");
            if (!isValue) {
                this.open("td id='m_" + jAXBMember.getName() + "'");
                this.print(jAXBMember.getName());
                if (type == MemberType.Element && ((Element)jAXBMember).isWrapped()) {
                    this.print(" (wrapped by " + ((Element)jAXBMember).getWrapperName() + ")");
                }
                this.close("td");
            }
            this.open("td");
            this.printXMLMemberType(jAXBMember, true);
            this.close("td");
            this.open("td");
            Doc javaDoc = jAXBMember.getJavaDoc();
            if (javaDoc != null && javaDoc.firstSentenceTags() != null) {
                this.writer.printSummaryComment(javaDoc);
            }
            this.close("td");
            this.close("tr");
        }
        this.close("tbody");
        this.close("table");
    }

    private void printXMLMemberType(JAXBMember member, boolean markCollections) {
        if (markCollections && member.isCollection()) {
            this.print("xsd:list[");
        }
        if (member.isIDREF()) {
            this.print("xsd:IDREF[");
        }
        if (member.isID()) {
            this.print("xsd:ID[");
        }
        if (member.isJAXBType()) {
            String name = member.getJavaTypeName();
            JAXBClass typeClass = this.jaxbClass.getRegistry().getJAXBClass(name);
            this.around("a href='" + Utils.urlToClass(this.jaxbClass, typeClass) + "'", typeClass.getName());
        } else {
            this.print(member.getXSDType());
        }
        if (member.isID()) {
            this.print("]");
        }
        if (member.isIDREF()) {
            this.print("]");
        }
        if (markCollections && member.isCollection()) {
            this.print("]");
        }
    }

    private void printJSONMemberType(JAXBMember member, boolean markCollections) {
        if (markCollections && member.isCollection()) {
            this.print("[");
        }
        if (member.isJAXBType()) {
            String name = member.getJavaTypeName();
            JAXBClass typeClass = this.jaxbClass.getRegistry().getJAXBClass(name);
            this.around("a href='" + Utils.urlToClass(this.jaxbClass, typeClass) + "'", typeClass.getName());
        } else {
            this.print(member.getJSONType());
        }
        if (member.isID()) {
            this.print(" /* ID */");
        }
        if (member.isIDREF()) {
            this.print(" /* IDREF */");
        }
        if (markCollections && member.isCollection()) {
            this.print("]");
        }
    }

    private void printSummary() {
        this.open("h2");
        this.around("h2", "Name: " + this.jaxbClass.getName());
        Doc javaDoc = this.jaxbClass.getJavaDoc();
        if (javaDoc != null && javaDoc.tags() != null) {
            this.writer.printInlineComment(javaDoc);
        }
        this.open("table class='examples'", "tr", "td");
        this.printXMLExample();
        this.close("td");
        this.open("td");
        this.printJSONExample();
        this.close("td", "tr", "table");
        this.open("dl");
        JAXBMember idMember = this.jaxbClass.getID();
        if (idMember != null) {
            this.open("dt");
            this.around("b", "ID");
            this.close("dt");
            this.open("dd");
            this.around("a href='#m_" + idMember.getName() + "'", idMember.getName());
            this.close("dd");
        }
        this.close("dl");
    }

    private void printXMLExample() {
        this.around("b", "XML Example:");
        this.open("pre");
        this.print("&lt;" + this.jaxbClass.getName());
        Collection<Attribute> attributes = this.jaxbClass.getAttributes();
        for (Attribute attribute : attributes) {
            this.print("\n ");
            this.around("a href='#m_" + attribute.getName() + "'", attribute.getName());
            this.print("=\"");
            this.printXMLMemberType(attribute, false);
            this.print("\"");
        }
        this.print(">\n");
        Collection<Element> elements = this.jaxbClass.getElements();
        for (Element element : elements) {
            if (element.isWrapped()) {
                this.print("  &lt;" + element.getWrapperName() + ">\n ");
            }
            this.print("  ");
            if (element.isCollection()) {
                this.print("xsd:list[");
            }
            this.print("&lt;");
            this.around("a href='#m_" + element.getName() + "'", element.getName());
            this.print(">");
            this.printXMLMemberType(element, false);
            this.print("&lt;/" + element.getName() + ">");
            if (element.isCollection()) {
                this.print("]");
            }
            if (element.isWrapped()) {
                this.print("\n  &lt;/" + element.getWrapperName() + ">");
            }
            this.print("\n");
        }
        for (Value value : this.jaxbClass.getValues()) {
            this.print(" ");
            this.printXMLMemberType(value, true);
            this.print("\n");
        }
        this.print("&lt;/" + this.jaxbClass.getName() + ">\n");
        this.close("pre");
    }

    private void printJSONExample() {
        this.around("b", "JSON Example:");
        this.open("pre");
        if (((JAXBConfiguration)this.configuration).enableJSONTypeName) {
            this.print("{'" + this.jaxbClass.getName() + "':\n");
        }
        this.print(" {\n");
        Collection<Attribute> attributes = this.jaxbClass.getAttributes();
        for (Attribute attribute : attributes) {
            this.print("  '@");
            this.around("a href='#m_" + attribute.getName() + "'", attribute.getName());
            this.print("': ");
            this.printJSONMemberType(attribute, false);
            this.print(",\n");
        }
        Collection<Element> elements = this.jaxbClass.getElements();
        for (Element element : elements) {
            this.print("   '");
            this.around("a href='#m_" + element.getName() + "'", element.isWrapped() ? element.getWrapperName() : element.getName());
            this.print("': ");
            this.printJSONMemberType(element, true);
            this.print(",\n");
        }
        for (Value value : this.jaxbClass.getValues()) {
            this.print("   ");
            this.printJSONMemberType(value, true);
            this.print(",\n");
        }
        this.print(" }\n");
        if (((JAXBConfiguration)this.configuration).enableJSONTypeName) {
            this.print("}\n");
        }
        this.close("pre");
    }

    protected void printHeader() {
        this.printHeader("XML element " + this.jaxbClass.getName());
    }

    @Override
    protected void printThirdMenu() {
        this.open("tr");
        this.open("td class='NavBarCell3' colspan='2'");
        this.print("detail: ");
        this.printLink(!this.jaxbClass.getElements().isEmpty(), "#Elements", "element");
        this.print(" | ");
        this.printLink(!this.jaxbClass.getAttributes().isEmpty(), "#Attributes", "attribute");
        this.print(" | ");
        this.printLink(!this.jaxbClass.getValues().isEmpty(), "#Value", "value");
        this.close("td", "tr");
    }
}

