/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxb.model;

import com.lunatech.doclets.jax.JAXConfiguration;
import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxb.JAXBConfiguration;
import com.lunatech.doclets.jax.jaxb.JAXBDoclet;
import com.lunatech.doclets.jax.jaxb.model.Attribute;
import com.lunatech.doclets.jax.jaxb.model.Element;
import com.lunatech.doclets.jax.jaxb.model.JAXBMember;
import com.lunatech.doclets.jax.jaxb.model.Registry;
import com.lunatech.doclets.jax.jaxb.model.Value;
import com.lunatech.doclets.jax.jaxb.writers.JAXBClassWriter;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBClass
implements Comparable<JAXBClass> {
    private Set<Value> values = new TreeSet<Value>();
    private Set<Attribute> attributes = new TreeSet<Attribute>();
    private Set<Element> elements = new TreeSet<Element>();
    private ClassDoc klass;
    private String name;
    private Registry registry;
    private JAXBDoclet doclet;
    private Map<String, JAXBMember> members = new HashMap<String, JAXBMember>();

    public JAXBClass(ClassDoc klass, Registry registry, JAXBDoclet doclet) {
        this.klass = klass;
        this.registry = registry;
        this.doclet = doclet;
        AnnotationDesc rootAnnotation = Utils.findAnnotation((ProgramElementDoc)klass, XmlRootElement.class);
        if (rootAnnotation != null) {
            this.name = (String)Utils.getAnnotationValue(rootAnnotation, "name");
        }
        if (this.name == null) {
            this.name = klass.simpleTypeName();
        }
        this.setupMembers(klass);
    }

    private void setupMembers(ClassDoc klass) {
        ClassDoc accessorAnnotationType = Utils.findAnnotatedClass(klass, XmlAccessorType.class);
        AnnotationDesc accessorAnnotation = null;
        if (accessorAnnotationType != null) {
            accessorAnnotation = Utils.findAnnotation((ProgramElementDoc)accessorAnnotationType, XmlAccessorType.class);
        }
        XmlAccessType accessType = XmlAccessType.PUBLIC_MEMBER;
        if (accessorAnnotation != null) {
            FieldDoc value = (FieldDoc)Utils.getAnnotationValue(accessorAnnotation);
            accessType = XmlAccessType.valueOf((String)value.name());
        }
        for (FieldDoc fieldDoc : klass.fields(false)) {
            this.addProperty((ProgramElementDoc)fieldDoc, accessType);
        }
        for (FieldDoc fieldDoc : klass.methods(false)) {
            this.addProperty((ProgramElementDoc)fieldDoc, accessType);
        }
        ClassDoc superClass = klass.superclass();
        if (superClass != null && !superClass.qualifiedTypeName().startsWith("java.")) {
            this.setupMembers(superClass);
        }
    }

    private void addProperty(ProgramElementDoc property, XmlAccessType accessType) {
        boolean isTransient;
        if (property.isMethod() && !this.isProperty((MethodDoc)property)) {
            return;
        }
        if (property.isStatic()) {
            return;
        }
        AnnotationDesc xmlElementAnnotation = Utils.findAnnotation(property, XmlElement.class);
        AnnotationDesc xmlAttributeAnnotation = Utils.findAnnotation(property, XmlAttribute.class);
        AnnotationDesc xmlValueAnnotation = Utils.findAnnotation(property, XmlValue.class);
        AnnotationDesc xmlTransientAnnotation = Utils.findAnnotation(property, XmlTransient.class);
        boolean hasXmlAnnotation = xmlElementAnnotation != null || xmlAttributeAnnotation != null || xmlValueAnnotation != null;
        boolean bl = isTransient = xmlTransientAnnotation != null;
        if (property.isField()) {
            isTransient |= ((FieldDoc)property).isTransient();
        }
        boolean include = false;
        switch (accessType) {
            case NONE: {
                include = hasXmlAnnotation && !isTransient;
                break;
            }
            case FIELD: {
                boolean bl2 = include = !isTransient;
                if (!property.isMethod()) break;
                include &= hasXmlAnnotation;
                break;
            }
            case PROPERTY: {
                boolean bl3 = include = !isTransient;
                if (!property.isField()) break;
                include &= hasXmlAnnotation;
                break;
            }
            case PUBLIC_MEMBER: {
                boolean bl4 = include = !(!property.isPublic() && !hasXmlAnnotation || !((JAXBConfiguration)this.doclet.conf).enableJaxBMethodOutput && property.isMethod());
            }
        }
        if (include) {
            this.addElement(property, xmlElementAnnotation, xmlAttributeAnnotation, xmlValueAnnotation);
        }
    }

    private boolean isProperty(MethodDoc method) {
        String name = method.name();
        if (method.parameters().length != 0) {
            return false;
        }
        if (name.startsWith("get")) {
            return name.length() > 3;
        }
        if (name.startsWith("is") && method.returnType().toString().equals("boolean")) {
            return name.length() > 2;
        }
        return false;
    }

    private void addElement(ProgramElementDoc property, AnnotationDesc xmlElementAnnotation, AnnotationDesc xmlAttributeAnnotation, AnnotationDesc xmlValueAnnotation) {
        String name = property.name();
        if (property.isMethod()) {
            name = name.startsWith("get") ? name.substring(3) : name.substring(2);
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        if (!this.members.containsKey(name)) {
            this.addElement(property, name, xmlElementAnnotation, xmlAttributeAnnotation, xmlValueAnnotation);
        }
    }

    private void addElement(ProgramElementDoc property, String name, AnnotationDesc xmlElementAnnotation, AnnotationDesc xmlAttributeAnnotation, AnnotationDesc xmlValueAnnotation) {
        if (xmlAttributeAnnotation != null) {
            this.addAttribute(property, name, xmlAttributeAnnotation);
        } else if (xmlValueAnnotation != null) {
            this.addValue(property, name, xmlValueAnnotation);
        } else {
            this.addElement(property, name, xmlElementAnnotation);
        }
    }

    private void addValue(ProgramElementDoc property, String name, AnnotationDesc xmlValueAnnotation) {
        Value value = new Value(this, property, name, xmlValueAnnotation);
        this.members.put(name, value);
        this.values.add(value);
    }

    private void addAttribute(ProgramElementDoc property, String propertyName, AnnotationDesc xmlAttributeAnnotation) {
        String name = propertyName;
        String overriddenName = (String)Utils.getAnnotationValue(xmlAttributeAnnotation, "name");
        if (overriddenName != null) {
            name = overriddenName;
        }
        Attribute attribute = new Attribute(this, property, name, xmlAttributeAnnotation);
        this.members.put(propertyName, attribute);
        this.attributes.add(attribute);
    }

    private void addElement(ProgramElementDoc property, String propertyName, AnnotationDesc xmlElementAnnotation) {
        String overriddenName;
        AnnotationDesc xmlElementWrapperAnnotation = Utils.findAnnotation(property, XmlElementWrapper.class);
        String name = propertyName;
        if (xmlElementAnnotation != null && (overriddenName = (String)Utils.getAnnotationValue(xmlElementAnnotation, "name")) != null) {
            name = overriddenName;
        }
        String wrapperName = null;
        if (xmlElementWrapperAnnotation != null && (wrapperName = (String)Utils.getAnnotationValue(xmlElementWrapperAnnotation, "name")) == null) {
            wrapperName = name + "s";
        }
        Element element = wrapperName == null ? new Element(this, property, name, xmlElementAnnotation) : new Element(this, property, name, wrapperName, xmlElementAnnotation);
        this.members.put(propertyName, element);
        this.elements.add(element);
    }

    public String getQualifiedClassName() {
        return this.klass.qualifiedName();
    }

    public JAXBDoclet getDoclet() {
        return this.doclet;
    }

    public String getName() {
        return this.name;
    }

    public void write(JAXConfiguration configuration) {
        new JAXBClassWriter(configuration, this).write();
    }

    public Doc getJavaDoc() {
        return this.klass;
    }

    public Collection<Element> getElements() {
        return this.elements;
    }

    public Collection<Attribute> getAttributes() {
        return this.attributes;
    }

    public Collection<Value> getValues() {
        return this.values;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public String getPackageName() {
        return this.klass.containingPackage().name();
    }

    public String getShortClassName() {
        return this.klass.name();
    }

    @Override
    public int compareTo(JAXBClass other) {
        return this.name.compareToIgnoreCase(other.name);
    }

    public List<JAXBMember> getMembers() {
        ArrayList<JAXBMember> list = new ArrayList<JAXBMember>(this.values.size() + this.elements.size() + this.attributes.size());
        list.addAll(this.values);
        list.addAll(this.attributes);
        list.addAll(this.elements);
        return list;
    }

    public JAXBMember getID() {
        for (JAXBMember member : this.getMembers()) {
            if (!member.isID()) continue;
            return member;
        }
        return null;
    }
}

