/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package net.opengis.wfs;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Inserted Feature Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link net.opengis.wfs.InsertedFeatureType#getFeatureId <em>Feature Id</em>}</li>
 *   <li>{@link net.opengis.wfs.InsertedFeatureType#getHandle <em>Handle</em>}</li>
 * </ul>
 *
 * @see net.opengis.wfs.WfsPackage#getInsertedFeatureType()
 * @model extendedMetaData="name='InsertedFeatureType' kind='elementOnly'"
 * @generated
 */
public interface InsertedFeatureType extends EObject {
	/**
	 * Returns the value of the '<em><b>Feature Id</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.Object}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 *                   This is the feature identifier for the newly created
	 *                   feature.  The feature identifier may be generated by
	 *                   the WFS or provided by the client (depending on the 
	 *                   value of the idgen attribute).  In all cases of idgen
	 *                   values, the feature id must be reported here.
	 *                
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Feature Id</em>' attribute list.
	 * @see net.opengis.wfs.WFSPackage#getInsertedFeatureType_FeatureId()
	 * @model type="org.opengis.filter.identity.FeatureId"
	 */
	EList getFeatureId();

	/**
   * Returns the value of the '<em><b>Handle</b></em>' attribute.
   * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * 
   *                If the insert element that generated this feature
   *                had a value for the "handle" attribute then a WFS
   *                may report it using this attribute to correlate
   *                the feature created with the action that created it.
   * <!-- end-model-doc -->
   * @return the value of the '<em>Handle</em>' attribute.
   * @see #setHandle(String)
   * @see net.opengis.wfs.WfsPackage#getInsertedFeatureType_Handle()
   * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String"
   *        extendedMetaData="kind='attribute' name='handle'"
   * @generated
   */
	String getHandle();

	/**
   * Sets the value of the '{@link net.opengis.wfs.InsertedFeatureType#getHandle <em>Handle</em>}' attribute.
   * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
   * @param value the new value of the '<em>Handle</em>' attribute.
   * @see #getHandle()
   * @generated
   */
	void setHandle(String value);

} // InsertedFeatureType
