/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.util.logging.Logger;
import org.geotools.util.WeakValueHashMap;

public abstract class LoggerFactory {
    private final Class loggerClass;
    private final WeakValueHashMap loggers;

    protected LoggerFactory(Class loggerClass) {
        this.loggerClass = loggerClass;
        this.loggers = new WeakValueHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger(String name) {
        Object target = this.getImplementation(name);
        if (target == null) {
            return null;
        }
        WeakValueHashMap weakValueHashMap = this.loggers;
        synchronized (weakValueHashMap) {
            Logger logger = (Logger)this.loggers.get(name);
            if (logger == null || !target.equals(this.unwrap(logger))) {
                logger = this.wrap(name, target);
                this.loggers.put(name, logger);
            }
            return logger;
        }
    }

    public Class getImplementationClass() {
        return this.loggerClass;
    }

    protected abstract Object getImplementation(String var1);

    protected abstract Logger wrap(String var1, Object var2) throws ClassCastException;

    protected abstract Object unwrap(Logger var1);
}

