/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public abstract class LoggerAdapter
extends Logger {
    private static final Pattern MESSAGE_FORMAT = Pattern.compile("\\{\\d+\\}");

    protected LoggerAdapter(String name) {
        super(name, null);
        super.setUseParentHandlers(false);
        super.setLevel(Level.ALL);
    }

    public abstract void setLevel(Level var1);

    public abstract Level getLevel();

    protected Level getDebugLevel() {
        return Level.FINER;
    }

    public abstract boolean isLoggable(Level var1);

    public abstract void severe(String var1);

    public abstract void warning(String var1);

    public abstract void info(String var1);

    public abstract void config(String var1);

    public abstract void fine(String var1);

    public abstract void finer(String var1);

    public abstract void finest(String var1);

    public void entering(String sourceClass, String sourceMethod) {
        this.logp(this.getDebugLevel(), sourceClass, sourceMethod, "ENTRY");
    }

    public void entering(String sourceClass, String sourceMethod, Object param) {
        this.logp(this.getDebugLevel(), sourceClass, sourceMethod, "ENTRY {0}", param);
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        String message;
        if (params == null) {
            message = "ENTRY";
        } else {
            switch (params.length) {
                case 0: {
                    message = "ENTRY";
                    break;
                }
                case 1: {
                    message = "ENTRY {0}";
                    break;
                }
                case 2: {
                    message = "ENTRY {0} {1}";
                    break;
                }
                default: {
                    StringBuffer builder = new StringBuffer("ENTRY");
                    for (int i = 0; i < params.length; ++i) {
                        builder.append(" {").append(i).append('}');
                    }
                    message = builder.toString();
                    break;
                }
            }
        }
        this.logp(this.getDebugLevel(), sourceClass, sourceMethod, message, params);
    }

    public void exiting(String sourceClass, String sourceMethod) {
        this.logp(this.getDebugLevel(), sourceClass, sourceMethod, "RETURN");
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        this.logp(this.getDebugLevel(), sourceClass, sourceMethod, "RETURN {0}", result);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.logp(this.getDebugLevel(), sourceClass, sourceMethod, "THROW", thrown);
    }

    public void log(LogRecord record) {
        boolean useThrown;
        Filter filter = this.getFilter();
        if (filter != null && !filter.isLoggable(record)) {
            return;
        }
        Level level = record.getLevel();
        String sourceClass = record.getSourceClassName();
        String sourceMethod = record.getSourceMethodName();
        String bundleName = record.getResourceBundleName();
        String message = record.getMessage();
        Object[] params = record.getParameters();
        Throwable thrown = record.getThrown();
        ResourceBundle bundle = record.getResourceBundle();
        boolean localized = false;
        if (bundle != null) {
            try {
                message = bundle.getString(message);
                localized = true;
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        boolean bl = useThrown = thrown != null && (params == null || params.length == 0);
        if (localized) {
            if (useThrown) {
                this.logp(level, sourceClass, sourceMethod, message, thrown);
            } else {
                this.logp(level, sourceClass, sourceMethod, message, params);
            }
        } else if (useThrown) {
            this.logrb(level, sourceClass, sourceMethod, bundleName, message, thrown);
        } else {
            this.logrb(level, sourceClass, sourceMethod, bundleName, message, params);
        }
    }

    public void log(Level level, String message) {
        int n = level.intValue();
        switch (n / 100) {
            default: {
                if (n < 0 || n == Integer.MAX_VALUE) break;
            }
            case 10: {
                this.severe(message);
                break;
            }
            case 9: {
                this.warning(message);
                break;
            }
            case 8: {
                this.info(message);
                break;
            }
            case 7: {
                this.config(message);
                break;
            }
            case 5: 
            case 6: {
                this.fine(message);
                break;
            }
            case 4: {
                this.finer(message);
                break;
            }
            case 3: {
                this.finest(message);
            }
            case 0: 
            case 1: 
            case 2: 
        }
    }

    public void log(Level level, String message, Throwable thrown) {
        this.log(level, message);
    }

    public void log(Level level, String message, Object param) {
        if (this.isLoggable(level)) {
            this.log(level, message, LoggerAdapter.asArray(param));
        }
    }

    public void log(Level level, String message, Object[] params) {
        if (this.isLoggable(level)) {
            this.log(level, LoggerAdapter.format(message, params));
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String message) {
        this.log(level, message);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String message, Throwable thrown) {
        this.log(level, message, thrown);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String message, Object param) {
        if (this.isLoggable(level)) {
            this.logp(level, sourceClass, sourceMethod, message, LoggerAdapter.asArray(param));
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String message, Object[] params) {
        if (this.isLoggable(level)) {
            this.logp(level, sourceClass, sourceMethod, LoggerAdapter.format(message, params));
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String message) {
        if (this.isLoggable(level)) {
            this.logp(level, sourceClass, sourceMethod, LoggerAdapter.localize(bundleName, message));
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String message, Throwable thrown) {
        if (this.isLoggable(level)) {
            this.logp(level, sourceClass, sourceMethod, LoggerAdapter.localize(bundleName, message), thrown);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String message, Object param) {
        if (this.isLoggable(level)) {
            this.logp(level, sourceClass, sourceMethod, LoggerAdapter.localize(bundleName, message), param);
        }
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String message, Object[] params) {
        if (this.isLoggable(level)) {
            this.logp(level, sourceClass, sourceMethod, LoggerAdapter.localize(bundleName, message), params);
        }
    }

    public void addHandler(Handler handler) {
    }

    public void removeHandler(Handler handler) {
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
    }

    public void setParent(Logger parent) {
    }

    public void setFilter(Filter filter) {
    }

    private static Object[] asArray(Object param) {
        Object[] objectArray;
        if (param != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = param;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    private static String format(String message, Object[] params) {
        if (params != null && params.length != 0 && MESSAGE_FORMAT.matcher(message).find()) {
            try {
                message = MessageFormat.format(message, params);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return message;
    }

    private static String localize(String bundleName, String message) {
        if (bundleName != null) {
            try {
                message = ResourceBundle.getBundle(bundleName).getString(message);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return message;
    }
}

