/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;

public class LoggedFormat
extends Format {
    private static final long serialVersionUID = 4578880360344271325L;
    private final Format format;
    private final Class type;
    private String logger;
    private String className;
    private String methodName;

    protected LoggedFormat(Format format, Class type) {
        this.format = format;
        this.type = type;
    }

    public static LoggedFormat getInstance(Format format, Class type) {
        return new LoggedFormat(format, type);
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public void setCaller(Class caller, String method) {
        this.className = caller != null ? caller.getName() : null;
        this.methodName = method;
    }

    public Object parse(String text) {
        if (text == null || (text = text.trim()).length() == 0) {
            return null;
        }
        ParsePosition position = new ParsePosition(0);
        Object value = this.parseObject(text, position);
        int index = position.getIndex();
        int error = position.getErrorIndex();
        if (error >= 0 && error < index) {
            index = error;
        }
        if (index < text.length()) {
            this.logWarning(139, text, text.substring(index));
        } else if (value != null && !this.type.isInstance(value)) {
            this.logWarning(45, value.getClass(), this.type);
            return null;
        }
        return value;
    }

    public Object parseObject(String text) throws ParseException {
        return this.format.parseObject(text);
    }

    public Object parseObject(String text, ParsePosition position) {
        return this.format.parseObject(text, position);
    }

    public StringBuffer format(Object value, StringBuffer toAppendTo, FieldPosition position) {
        return this.format.format(value, toAppendTo, position);
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object value) {
        return this.format.formatToCharacterIterator(value);
    }

    private void logWarning(int key, Object arg1, Object arg2) {
        LogRecord warning = Errors.getResources(this.getWarningLocale()).getLogRecord(Level.WARNING, key, arg1, arg2);
        if (this.className != null) {
            warning.setSourceClassName(this.className);
        }
        if (this.methodName != null) {
            warning.setSourceMethodName(this.methodName);
        }
        this.logWarning(warning);
    }

    protected void logWarning(LogRecord warning) {
        if (this.logger != null) {
            Logger.getLogger(this.logger).log(warning);
        }
    }

    protected Locale getWarningLocale() {
        return Locale.getDefault();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName(this)).append('[').append(Utilities.getShortClassName(this.format));
        if (this.logger != null) {
            buffer.append(", logger=").append(this.logger);
        }
        return buffer.append(']').toString();
    }
}

