/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.geotools.resources.i18n.Logging;

final class CommonHandler
extends Handler {
    private final Map loggers = new HashMap();
    private final Log logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    private CommonHandler(String name, Log logger) {
        this.loggers.put(name, logger);
        this.logger = logger;
        this.setFormatter(new SimpleFormatter());
    }

    public static synchronized boolean install(String name) throws NoClassDefFoundError {
        Log log = LogFactory.getLog((String)name);
        if (log instanceof Jdk14Logger) {
            return false;
        }
        Logger root = Logger.getLogger(name);
        root.log(Logging.format(Level.CONFIG, 39));
        CommonHandler.removeAllHandlers(root);
        root.addHandler(new CommonHandler(name, log));
        root.setLevel(Level.ALL);
        root.setUseParentHandlers(false);
        return true;
    }

    private static void removeAllHandlers(Logger logger) {
        Handler[] handlers = logger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            logger.removeHandler(handlers[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Log getLog(String name) {
        Map map = this.loggers;
        synchronized (map) {
            Log log = (Log)this.loggers.get(name);
            if (log == null) {
                log = LogFactory.getLog((String)name);
                if (!$assertionsDisabled && log instanceof Jdk14Logger) {
                    throw new AssertionError();
                }
                this.loggers.put(name, log);
                Level level = log.isTraceEnabled() ? Level.FINEST : (log.isDebugEnabled() ? Level.FINER : (log.isInfoEnabled() ? Level.CONFIG : (log.isWarnEnabled() ? Level.WARNING : (log.isErrorEnabled() ? Level.SEVERE : (log.isFatalEnabled() ? Level.SEVERE : Level.OFF)))));
                Logger logger = Logger.getLogger(name);
                CommonHandler.removeAllHandlers(logger);
                logger.setUseParentHandlers(true);
                logger.setLevel(level);
            }
            return log;
        }
    }

    public void publish(LogRecord record) {
        String name = record.getLoggerName();
        Log log = name != null ? this.getLog(name) : this.logger;
        int level = record.getLevel().intValue();
        String message = this.getFormatter().formatMessage(record);
        Throwable throwable = record.getThrown();
        if (level == Level.OFF.intValue()) {
            return;
        }
        if (level >= Level.SEVERE.intValue()) {
            if (throwable != null) {
                log.error((Object)message, throwable);
            } else {
                log.error((Object)message);
            }
        } else if (level >= Level.WARNING.intValue()) {
            if (throwable != null) {
                log.warn((Object)message, throwable);
            } else {
                log.warn((Object)message);
            }
        } else if (level >= Level.CONFIG.intValue()) {
            if (throwable != null) {
                log.info((Object)message, throwable);
            } else {
                log.info((Object)message);
            }
        } else if (level >= Level.FINER.intValue()) {
            if (throwable != null) {
                log.debug((Object)message, throwable);
            } else {
                log.debug((Object)message);
            }
        } else if (throwable != null) {
            log.trace((Object)message, throwable);
        } else {
            log.trace((Object)message);
        }
    }

    public void flush() {
    }

    public void close() {
        this.flush();
    }

    static {
        $assertionsDisabled = !CommonHandler.class.desiredAssertionStatus();
    }
}

