/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.text.ChoiceFormat;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;

public final class XMath {
    public static final double LN10 = 2.302585092994046;
    private static final double[] POW10;
    static final /* synthetic */ boolean $assertionsDisabled;

    private XMath() {
    }

    public static double cbrt(double x) {
        return Math.pow(x, 0.3333333333333333);
    }

    public static double hypot(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    public static double log10(double x) {
        return Math.log(x) / 2.302585092994046;
    }

    public static double pow10(double x) {
        int ix = (int)x;
        if ((double)ix == x) {
            return XMath.pow10(ix);
        }
        return Math.pow(10.0, x);
    }

    public static strictfp double pow10(int x) {
        int nx;
        if (x >= 0) {
            if (x < POW10.length) {
                return POW10[x];
            }
        } else if (x != Integer.MIN_VALUE && (nx = -x) < POW10.length) {
            return 1.0 / POW10[nx];
        }
        try {
            return Double.parseDouble("1E" + x);
        }
        catch (NumberFormatException exception) {
            return StrictMath.pow(10.0, x);
        }
    }

    public static int sgn(double x) {
        if (x > 0.0) {
            return 1;
        }
        if (x < 0.0) {
            return -1;
        }
        return 0;
    }

    public static int sgn(float x) {
        if (x > 0.0f) {
            return 1;
        }
        if (x < 0.0f) {
            return -1;
        }
        return 0;
    }

    public static int sgn(long x) {
        if (x > 0L) {
            return 1;
        }
        if (x < 0L) {
            return -1;
        }
        return 0;
    }

    public static int sgn(int x) {
        if (x > 0) {
            return 1;
        }
        if (x < 0) {
            return -1;
        }
        return 0;
    }

    public static short sgn(short x) {
        if (x > 0) {
            return 1;
        }
        if (x < 0) {
            return -1;
        }
        return 0;
    }

    public static byte sgn(byte x) {
        if (x > 0) {
            return 1;
        }
        if (x < 0) {
            return -1;
        }
        return 0;
    }

    public static double round(double value, int flu) {
        double target = Math.rint(value);
        if (value != target) {
            boolean pos = value < target;
            double candidate = value;
            while (--flu >= 0) {
                candidate = pos ? XMath.next(candidate) : XMath.previous(candidate);
                if (candidate != target) continue;
                return target;
            }
        }
        return value;
    }

    public static double fixRoundingError(double value, int n) {
        double lower = value;
        double upper = value;
        n = XMath.countFractionDigits(value) - n;
        if (n > 0) {
            for (int i = 0; i < 4; ++i) {
                if (XMath.countFractionDigits(lower = XMath.previous(lower)) <= n) {
                    return lower;
                }
                if (XMath.countFractionDigits(upper = XMath.next(upper)) > n) continue;
                return upper;
            }
        }
        return value;
    }

    public static int countFractionDigits(double value) {
        int power;
        int upper;
        String asText = Double.toString(value);
        int exp = asText.indexOf(69);
        if (exp >= 0) {
            upper = exp;
            power = Integer.parseInt(asText.substring(exp + 1));
        } else {
            upper = asText.length();
            power = 0;
        }
        while (asText.charAt(--upper) == '0') {
        }
        return Math.max(upper - asText.indexOf(46) - power, 0);
    }

    private static float next(float f, boolean positive) {
        int SIGN = Integer.MIN_VALUE;
        int POSITIVEINFINITY = 2139095040;
        if (Float.isNaN(f)) {
            return f;
        }
        if (f == 0.0f) {
            float smallestPositiveFloat = Float.intBitsToFloat(1);
            return positive ? smallestPositiveFloat : -smallestPositiveFloat;
        }
        int bits = Float.floatToIntBits(f);
        int magnitude = bits & Integer.MAX_VALUE;
        if (bits > 0 == positive) {
            if (magnitude != 2139095040) {
                ++magnitude;
            }
        } else {
            --magnitude;
        }
        int signbit = bits & Integer.MIN_VALUE;
        return Float.intBitsToFloat(magnitude | signbit);
    }

    public static float next(float f) {
        return XMath.next(f, true);
    }

    public static float previous(float f) {
        return XMath.next(f, false);
    }

    public static double next(double f) {
        return ChoiceFormat.nextDouble(f);
    }

    public static double previous(double f) {
        return ChoiceFormat.previousDouble(f);
    }

    public static double rool(Class type, double value, int amount) throws IllegalArgumentException {
        if (Double.class.equals(type)) {
            if (amount < 0) {
                do {
                    value = XMath.previous(value);
                } while (++amount != 0);
            } else if (amount != 0) {
                do {
                    value = XMath.next(value);
                } while (--amount != 0);
            }
            return value;
        }
        if (Float.class.equals(type)) {
            float vf = (float)value;
            if (amount < 0) {
                do {
                    vf = XMath.previous(vf);
                } while (++amount != 0);
            } else if (amount != 0) {
                do {
                    vf = XMath.next(vf);
                } while (--amount != 0);
            }
            return vf;
        }
        if (XMath.isInteger(type)) {
            return value + (double)amount;
        }
        throw new IllegalArgumentException(Errors.format(143, Utilities.getShortName(type)));
    }

    public static float toNaN(int index) throws IndexOutOfBoundsException {
        if ((index += 0x200000) >= 0 && index <= 0x3FFFFF) {
            float value = Float.intBitsToFloat(2143289344 + index);
            if (!$assertionsDisabled && !Float.isNaN(value)) {
                throw new AssertionError(value);
            }
            return value;
        }
        throw new IndexOutOfBoundsException(Integer.toHexString(index));
    }

    public static boolean isReal(Class type) {
        return type != null && Double.class.equals(type) || Float.class.equals(type);
    }

    public static boolean isInteger(Class type) {
        return type != null && Long.class.equals(type) || Integer.class.equals(type) || Short.class.equals(type) || Byte.class.equals(type);
    }

    public static int getBitCount(Class type) {
        if (Double.class.equals(type)) {
            return 64;
        }
        if (Float.class.equals(type)) {
            return 32;
        }
        if (Long.class.equals(type)) {
            return 64;
        }
        if (Integer.class.equals(type)) {
            return 32;
        }
        if (Short.class.equals(type)) {
            return 16;
        }
        if (Byte.class.equals(type)) {
            return 8;
        }
        if (Character.class.equals(type)) {
            return 16;
        }
        if (Boolean.class.equals(type)) {
            return 1;
        }
        return 0;
    }

    public static Class primitiveToWrapper(Class type) {
        if (Character.TYPE.equals(type)) {
            return Character.class;
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class;
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(type)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(type)) {
            return Long.class;
        }
        if (Float.TYPE.equals(type)) {
            return Float.class;
        }
        if (Double.TYPE.equals(type)) {
            return Double.class;
        }
        return type;
    }

    public static Object valueOf(Class type, String value) throws IllegalArgumentException, NumberFormatException {
        if (value == null) {
            return null;
        }
        if (Double.class.equals(type)) {
            return Double.valueOf(value);
        }
        if (Float.class.equals(type)) {
            return Float.valueOf(value);
        }
        if (Long.class.equals(type)) {
            return Long.valueOf(value);
        }
        if (Integer.class.equals(type)) {
            return Integer.valueOf(value);
        }
        if (Short.class.equals(type)) {
            return Short.valueOf(value);
        }
        if (Byte.class.equals(type)) {
            return Byte.valueOf(value);
        }
        if (Boolean.class.equals(type)) {
            return Boolean.valueOf(value);
        }
        throw new IllegalArgumentException(Errors.format(135, type));
    }

    static {
        $assertionsDisabled = !XMath.class.desiredAssertionStatus();
        POW10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    }
}

