/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.spatial;

import java.util.Collection;
import java.util.List;
import org.geotools.metadata.iso.spatial.GridSpatialRepresentationImpl;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.Georeferenceable;
import org.opengis.metadata.spatial.GridSpatialRepresentation;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;

public class GeoreferenceableImpl
extends GridSpatialRepresentationImpl
implements Georeferenceable {
    private static final long serialVersionUID = 5203270142818028946L;
    private boolean controlPointAvailable;
    private boolean orientationParameterAvailable;
    private InternationalString orientationParameterDescription;
    private Record georeferencedParameters;
    private Collection parameterCitation;

    public GeoreferenceableImpl() {
    }

    public GeoreferenceableImpl(Georeferenceable source) {
        super((GridSpatialRepresentation)source);
    }

    public GeoreferenceableImpl(int numberOfDimensions, List axisDimensionsProperties, CellGeometry cellGeometry, boolean transformationParameterAvailable, boolean controlPointAvailable, boolean orientationParameterAvailable) {
        super(numberOfDimensions, axisDimensionsProperties, cellGeometry, transformationParameterAvailable);
        this.setControlPointAvailable(controlPointAvailable);
        this.setOrientationParameterAvailable(orientationParameterAvailable);
    }

    public boolean isControlPointAvailable() {
        return this.controlPointAvailable;
    }

    public synchronized void setControlPointAvailable(boolean newValue) {
        this.checkWritePermission();
        this.controlPointAvailable = newValue;
    }

    public boolean isOrientationParameterAvailable() {
        return this.orientationParameterAvailable;
    }

    public synchronized void setOrientationParameterAvailable(boolean newValue) {
        this.checkWritePermission();
        this.orientationParameterAvailable = newValue;
    }

    public InternationalString getOrientationParameterDescription() {
        return this.orientationParameterDescription;
    }

    public synchronized void setOrientationParameterDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.orientationParameterDescription = newValue;
    }

    public Object getParameters() {
        return this.getGeoreferencedParameters();
    }

    public Record getGeoreferencedParameters() {
        return this.georeferencedParameters;
    }

    public void setParameters(Object newValue) {
        this.setGeoreferencedParameters((Record)newValue);
    }

    public synchronized void setGeoreferencedParameters(Record newValue) {
        this.checkWritePermission();
        this.georeferencedParameters = newValue;
    }

    public synchronized Collection getParameterCitation() {
        this.parameterCitation = this.nonNullCollection(this.parameterCitation, Citation.class);
        return this.parameterCitation;
    }

    public synchronized void setParameterCitation(Collection newValues) {
        this.parameterCitation = this.copyCollection(newValues, this.parameterCitation, Citation.class);
    }
}

