/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.quality;

import java.util.Collection;
import java.util.Collections;
import javax.units.Unit;
import org.geotools.metadata.iso.quality.ResultImpl;
import org.geotools.util.CheckedArrayList;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.metadata.quality.Result;
import org.opengis.util.InternationalString;
import org.opengis.util.RecordType;

public class QuantitativeResultImpl
extends ResultImpl
implements QuantitativeResult {
    private static final long serialVersionUID = 1230713599561236060L;
    private Collection values;
    private RecordType valueType;
    private Unit valueUnit;
    private InternationalString errorStatistic;

    public QuantitativeResultImpl() {
    }

    public QuantitativeResultImpl(QuantitativeResult source) {
        super((Result)source);
    }

    public QuantitativeResultImpl(double[] values) {
        this.setValues(values);
    }

    public synchronized Collection getValues() {
        if (this.values == null) {
            this.values = this.isModifiable() ? new CheckedArrayList(Double.class) : Collections.EMPTY_LIST;
        }
        return this.values;
    }

    public synchronized void setValues(double[] newValues) {
        this.checkWritePermission();
        if (newValues == null) {
            this.values = null;
        } else {
            this.values = new CheckedArrayList(Double.class, newValues.length);
            for (int i = 0; i < newValues.length; ++i) {
                this.values.add(new Double(newValues[i]));
            }
        }
    }

    public synchronized void setValues(Collection newValues) {
        this.values = this.copyCollection(newValues, this.values, Double.class);
    }

    public RecordType getValueType() {
        return this.valueType;
    }

    public synchronized void setValueType(RecordType newValue) {
        this.checkWritePermission();
        this.valueType = newValue;
    }

    public Unit getValueUnit() {
        return this.valueUnit;
    }

    public synchronized void setValueUnit(Unit newValue) {
        this.checkWritePermission();
        this.valueUnit = newValue;
    }

    public InternationalString getErrorStatistic() {
        return this.errorStatistic;
    }

    public synchronized void setErrorStatistic(InternationalString newValue) {
        this.checkWritePermission();
        this.errorStatistic = newValue;
    }
}

