/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.identification;

import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.identification.RepresentativeFraction;

public class RepresentativeFractionImpl
extends Number
implements RepresentativeFraction {
    private static final long serialVersionUID = 7228422109144637537L;
    private final long denominator;

    public RepresentativeFractionImpl(long denominator) {
        this.denominator = denominator;
    }

    public static RepresentativeFraction fromScale(double scale) throws IllegalArgumentException {
        if (Math.abs(scale) <= 1.0 || scale == Double.POSITIVE_INFINITY) {
            return new RepresentativeFractionImpl(Math.round(1.0 / scale));
        }
        throw new IllegalArgumentException(Errors.format(42, "scale", new Double(scale)));
    }

    public double toScale() {
        return this.doubleValue();
    }

    public double doubleValue() {
        return 1.0 / (double)this.denominator;
    }

    public float floatValue() {
        return 1.0f / (float)this.denominator;
    }

    public long longValue() {
        return 0L;
    }

    public int intValue() {
        return 0;
    }

    public int getDenominator() {
        if (this.denominator < Integer.MIN_VALUE || this.denominator > Integer.MAX_VALUE) {
            throw new IllegalStateException();
        }
        return (int)this.denominator;
    }

    public boolean equals(Object object) {
        if (object instanceof RepresentativeFraction) {
            RepresentativeFraction that = (RepresentativeFraction)object;
            return this.denominator == (long)that.getDenominator();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.denominator;
    }
}

