/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.metadata.InvalidMetadataException;
import org.geotools.metadata.MetadataStandard;
import org.geotools.metadata.ModifiableMetadata;
import org.geotools.resources.i18n.Errors;
import org.opengis.util.Cloneable;

public class MetadataEntity
extends ModifiableMetadata
implements Serializable {
    private static final long serialVersionUID = 5730550742604669102L;

    protected MetadataEntity() {
    }

    protected MetadataEntity(Object source) throws ClassCastException {
        super(source);
    }

    public MetadataStandard getStandard() {
        return MetadataStandard.ISO_19115;
    }

    protected static Object unmodifiable(Object object) {
        if (object instanceof MetadataEntity) {
            return ((MetadataEntity)object).unmodifiable();
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (collection.isEmpty()) {
                return null;
            }
            if (collection instanceof Cloneable) {
                ArrayList<Object> buffer = (collection = (Collection)((Cloneable)collection).clone()) instanceof List ? (ArrayList<Object>)collection : new ArrayList<Object>(collection.size());
                int index = 0;
                boolean refill = false;
                Iterator it = collection.iterator();
                while (it.hasNext()) {
                    Object copy;
                    boolean changed;
                    Object original = it.next();
                    boolean bl = changed = original != (copy = MetadataEntity.unmodifiable(original));
                    if (buffer == collection) {
                        if (changed) {
                            buffer.set(index, copy);
                        }
                    } else {
                        buffer.add(copy);
                        refill |= changed;
                    }
                    ++index;
                }
                if (refill) {
                    collection.clear();
                    collection.addAll(buffer);
                }
                if (collection instanceof List) {
                    return Collections.unmodifiableList((List)collection);
                }
                if (collection instanceof Set) {
                    return Collections.unmodifiableSet((Set)collection);
                }
                return Collections.unmodifiableCollection(collection);
            }
            return collection;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (map.isEmpty()) {
                return null;
            }
            if (map instanceof Cloneable) {
                Map copy = (Map)((Cloneable)map).clone();
                copy.clear();
                Iterator it = map.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    copy.put(MetadataEntity.unmodifiable(entry.getKey()), MetadataEntity.unmodifiable(entry.getValue()));
                }
                return Collections.unmodifiableMap(copy);
            }
            return map;
        }
        return object;
    }

    protected static void ensureNonNull(String name, Object object) throws InvalidMetadataException {
        if (object == null) {
            throw new InvalidMetadataException(Errors.format(61, name));
        }
    }

    protected static void appendLineSeparator(StringBuffer buffer) {
        if (buffer.length() != 0) {
            buffer.append(System.getProperty("line.separator", "\n"));
        }
    }
}

