/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.geotools.metadata.ModifiableMetadata;
import org.geotools.metadata.UnmodifiableMetadataException;
import org.geotools.resources.Utilities;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;

final class PropertyAccessor {
    private static final String IS = "is";
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String[] EXCLUDES;
    private static final Map SHARED_GETTERS;
    final Class type;
    final Class implementation;
    private final Method[] getters;
    private final Method[] setters;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Cloneable;

    PropertyAccessor(Class implementation, Class type) {
        this.implementation = implementation;
        this.type = type;
        if (!$assertionsDisabled && !type.isAssignableFrom(implementation)) {
            throw new AssertionError(implementation);
        }
        this.getters = PropertyAccessor.getGetters(type);
        Method[] setters = null;
        Class[] arguments = new Class[1];
        for (int i = 0; i < this.getters.length; ++i) {
            Method setter;
            Method getter = this.getters[i];
            arguments[0] = getter.getReturnType();
            String name = getter.getName();
            int base = PropertyAccessor.prefix(name).length();
            if (name.length() > base) {
                char up;
                char lo = name.charAt(base);
                name = lo != (up = Character.toUpperCase(lo)) ? SET + up + name.substring(base + 1) : SET + name.substring(base);
            }
            try {
                setter = implementation.getMethod(name, arguments);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            if (setters == null) {
                setters = new Method[this.getters.length];
            }
            setters[i] = setter;
        }
        this.setters = setters;
    }

    static Class getType(Class implementation, String interfacePackage) {
        if (!implementation.isInterface()) {
            Class<?>[] interfaces = implementation.getInterfaces();
            int count = 0;
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> candidate = interfaces[i];
                if (!candidate.getName().startsWith(interfacePackage)) continue;
                interfaces[count++] = candidate;
            }
            if (count == 1) {
                return interfaces[0];
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method[] getGetters(Class type) {
        Map map = SHARED_GETTERS;
        synchronized (map) {
            Object[] getters = (Method[])SHARED_GETTERS.get(type);
            if (getters == null) {
                getters = type.getMethods();
                int count = 0;
                for (int i = 0; i < getters.length; ++i) {
                    String name;
                    Method candidate = getters[i];
                    if (candidate.getReturnType().equals(Void.TYPE) || candidate.getParameterTypes().length != 0 || (name = candidate.getName()).startsWith(SET) || PropertyAccessor.isExcluded(name)) continue;
                    getters[count++] = candidate;
                }
                getters = (Method[])XArray.resize(getters, count);
                SHARED_GETTERS.put(type, getters);
            }
            return getters;
        }
    }

    private static boolean isExcluded(String name) {
        for (int i = 0; i < EXCLUDES.length; ++i) {
            if (!name.equals(EXCLUDES[i])) continue;
            return true;
        }
        return false;
    }

    private static String prefix(String name) {
        if (name.startsWith(GET)) {
            return GET;
        }
        if (name.startsWith(IS)) {
            return IS;
        }
        if (name.startsWith(SET)) {
            return SET;
        }
        return "";
    }

    final int count() {
        return this.getters.length;
    }

    final int indexOf(String key) {
        key = key.trim();
        for (int i = 0; i < this.getters.length; ++i) {
            String name = this.getters[i].getName();
            int base = PropertyAccessor.prefix(name).length();
            int length = key.length();
            if (name.length() != base + length || !name.regionMatches(true, base, key, 0, length)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isAcronym(String name, int offset) {
        int length = name.length();
        while (offset < length) {
            if (!Character.isLowerCase(name.charAt(offset++))) continue;
            return false;
        }
        return true;
    }

    final String name(int index) {
        if (index >= 0 && index < this.getters.length) {
            String name = this.getters[index].getName();
            int base = PropertyAccessor.prefix(name).length();
            if (name.length() > base) {
                char lo;
                char up;
                name = PropertyAccessor.isAcronym(name, base) ? name.substring(base) : ((up = name.charAt(base)) != (lo = Character.toLowerCase(up)) ? lo + name.substring(base + 1) : name.substring(base));
            }
            return name;
        }
        return null;
    }

    final Class type(int index) {
        if (index >= 0 && index < this.getters.length) {
            return this.getters[index].getReturnType();
        }
        return null;
    }

    final boolean isWritable(int index) {
        return index >= 0 && index < this.getters.length && this.setters != null && this.setters[index] != null;
    }

    final Object get(int index, Object metadata) {
        return index >= 0 && index < this.getters.length ? PropertyAccessor.get(this.getters[index], metadata) : null;
    }

    private static Object get(Method method, Object metadata) {
        if (!$assertionsDisabled && method.getReturnType().equals(Void.TYPE)) {
            throw new AssertionError(method);
        }
        try {
            return method.invoke(metadata, (Object[])null);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
    }

    final Object set(int index, Object metadata, Object value) throws IllegalArgumentException {
        Method setter;
        if (index >= 0 && index < this.getters.length && this.setters != null && (setter = this.setters[index]) != null) {
            Object old = PropertyAccessor.get(this.getters[index], metadata);
            PropertyAccessor.set(setter, metadata, new Object[]{value});
            return old;
        }
        throw new IllegalArgumentException(Errors.format(167, "key"));
    }

    private static void set(Method method, Object metadata, Object[] arguments) {
        try {
            method.invoke(metadata, arguments);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
    }

    public boolean shallowEquals(Object metadata1, Object metadata2, boolean skipNulls) {
        if (!$assertionsDisabled && !this.type.isInstance(metadata1)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.type.isInstance(metadata2)) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.getters.length; ++i) {
            Method method = this.getters[i];
            Object value1 = PropertyAccessor.get(method, metadata1);
            Object value2 = PropertyAccessor.get(method, metadata2);
            boolean empty1 = PropertyAccessor.isEmpty(value1);
            boolean empty2 = PropertyAccessor.isEmpty(value2);
            if (empty1 && empty2 || Utilities.equals(value1, value2) || skipNulls && (empty1 || empty2)) continue;
            return false;
        }
        return true;
    }

    public boolean shallowCopy(Object source, Object target, boolean skipNulls) throws UnmodifiableMetadataException {
        boolean success = true;
        if (!$assertionsDisabled && !this.type.isInstance(source)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.implementation.isInstance(target)) {
            throw new AssertionError();
        }
        Object[] arguments = new Object[1];
        for (int i = 0; i < this.getters.length; ++i) {
            arguments[0] = PropertyAccessor.get(this.getters[i], source);
            if (skipNulls && PropertyAccessor.isEmpty(arguments[0])) continue;
            if (this.setters == null) {
                return false;
            }
            Method setter = this.setters[i];
            if (setter != null) {
                PropertyAccessor.set(setter, target, arguments);
                continue;
            }
            success = false;
        }
        return success;
    }

    final void freeze(Object metadata) {
        if (!$assertionsDisabled && !this.implementation.isInstance(metadata)) {
            throw new AssertionError();
        }
        if (this.setters != null) {
            Object[] arguments = new Object[1];
            for (int i = 0; i < this.getters.length; ++i) {
                Object target;
                Object source;
                Method setter = this.setters[i];
                if (setter == null || (source = PropertyAccessor.get(this.getters[i], metadata)) == (target = ModifiableMetadata.unmodifiable(source))) continue;
                arguments[0] = target;
                PropertyAccessor.set(setter, metadata, arguments);
            }
        }
    }

    final boolean isModifiable() {
        if (this.setters != null) {
            return true;
        }
        for (int i = 0; i < this.getters.length; ++i) {
            if (!(class$java$lang$Cloneable == null ? PropertyAccessor.class$("java.lang.Cloneable") : class$java$lang$Cloneable).isAssignableFrom(this.getters[i].getReturnType())) continue;
            return true;
        }
        return false;
    }

    public int hashCode(Object metadata) {
        if (!$assertionsDisabled && !this.type.isInstance(metadata)) {
            throw new AssertionError();
        }
        int code = 0;
        for (int i = 0; i < this.getters.length; ++i) {
            Object value = PropertyAccessor.get(this.getters[i], metadata);
            if (PropertyAccessor.isEmpty(value)) continue;
            code += value.hashCode();
        }
        return code;
    }

    public int count(Object metadata, int max) {
        if (!$assertionsDisabled && !this.type.isInstance(metadata)) {
            throw new AssertionError();
        }
        int count = 0;
        for (int i = 0; i < this.getters.length && (PropertyAccessor.isEmpty(PropertyAccessor.get(this.getters[i], metadata)) || ++count < max); ++i) {
        }
        return count;
    }

    static boolean isEmpty(Object value) {
        return value == null || value instanceof Collection && ((Collection)value).isEmpty() || value instanceof CharSequence && value.toString().trim().length() == 0 || value.getClass().isArray() && Array.getLength(value) == 0;
    }

    static {
        $assertionsDisabled = !PropertyAccessor.class.desiredAssertionStatus();
        EXCLUDES = new String[]{"clone", "finalize", "getClass", "hashCode", "notify", "notifyAll", "toString", "wait"};
        SHARED_GETTERS = new HashMap();
    }
}

