/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.metadata.AbstractMetadata;
import org.geotools.metadata.MetadataStandard;
import org.geotools.metadata.UnmodifiableMetadataException;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.CheckedArrayList;
import org.geotools.util.CheckedHashSet;
import org.geotools.util.logging.Logging;

public abstract class ModifiableMetadata
extends AbstractMetadata
implements Cloneable {
    private static final ModifiableMetadata FREEZING;
    private transient ModifiableMetadata unmodifiable;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ModifiableMetadata() {
    }

    protected ModifiableMetadata(Object source) throws ClassCastException, UnmodifiableMetadataException {
        super(source);
    }

    public final boolean isModifiable() {
        return this.unmodifiable != this;
    }

    public synchronized AbstractMetadata unmodifiable() {
        if (this.unmodifiable == null) {
            ModifiableMetadata candidate;
            try {
                candidate = (ModifiableMetadata)this.clone();
            }
            catch (CloneNotSupportedException exception) {
                Logging.unexpectedException(LOGGER, exception);
                return this;
            }
            candidate.freeze();
            this.unmodifiable = candidate;
        }
        if (!$assertionsDisabled && this.unmodifiable.isModifiable()) {
            throw new AssertionError();
        }
        return this.unmodifiable;
    }

    static Object unmodifiable(Object object) {
        if (object instanceof ModifiableMetadata) {
            return ((ModifiableMetadata)object).unmodifiable();
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (collection.isEmpty()) {
                return collection instanceof List ? Collections.EMPTY_LIST : Collections.EMPTY_SET;
            }
            Object[] array = collection.toArray();
            for (int i = 0; i < array.length; ++i) {
                array[i] = ModifiableMetadata.unmodifiable(array[i]);
            }
            List<Object> asList = Arrays.asList(array);
            if (collection instanceof Set) {
                return Collections.unmodifiableSet(new LinkedHashSet<Object>(asList));
            }
            return Collections.unmodifiableList(asList);
        }
        if (object instanceof Map) {
            LinkedHashMap map = (LinkedHashMap)object;
            if (map.isEmpty()) {
                return Collections.EMPTY_MAP;
            }
            map = new LinkedHashMap(map);
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                entry.setValue(ModifiableMetadata.unmodifiable(entry.getValue()));
            }
            return Collections.unmodifiableMap(map);
        }
        if (object instanceof org.opengis.util.Cloneable) {
            return ((org.opengis.util.Cloneable)object).clone();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void freeze() {
        ModifiableMetadata success = null;
        try {
            this.unmodifiable = FREEZING;
            this.getStandard().freeze(this);
            success = this;
        }
        finally {
            this.unmodifiable = success;
        }
    }

    protected void checkWritePermission() throws UnmodifiableMetadataException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (!this.isModifiable()) {
            throw new UnmodifiableMetadataException(Errors.format(200));
        }
        this.invalidate();
    }

    final void invalidate() {
        super.invalidate();
        this.unmodifiable = null;
    }

    private static boolean isModifiable(Collection collection) {
        if (!collection.isEmpty()) {
            try {
                collection.clear();
                return true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    protected final Collection copyCollection(Collection source, Collection target, Class elementType) throws UnmodifiableMetadataException {
        if (this.unmodifiable == FREEZING) {
            if (!$assertionsDisabled && ModifiableMetadata.isModifiable(source)) {
                throw new AssertionError();
            }
            return source;
        }
        this.checkWritePermission();
        if (source == null) {
            if (target != null) {
                target.clear();
            }
        } else {
            boolean isList = source instanceof List;
            if (target != null && target instanceof List == isList) {
                target.clear();
            } else {
                int capacity = source.size();
                if (isList) {
                    target = new CheckedArrayList(elementType, capacity);
                } else {
                    capacity = Math.round((float)capacity / 0.75f) + 1;
                    target = new CheckedHashSet(elementType, capacity);
                }
            }
            target.addAll(source);
        }
        return target;
    }

    protected final Collection nonNullCollection(Collection c, Class elementType) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (c != null) {
            return c;
        }
        if (this.isModifiable()) {
            return new CheckedHashSet(elementType);
        }
        return Collections.EMPTY_SET;
    }

    protected final List nonNullList(List c, Class elementType) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (c != null) {
            return c;
        }
        if (this.isModifiable()) {
            return new CheckedArrayList(elementType);
        }
        return Collections.EMPTY_LIST;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static {
        $assertionsDisabled = !ModifiableMetadata.class.desiredAssertionStatus();
        FREEZING = new Null();
    }

    private static final class Null
    extends ModifiableMetadata {
        private Null() {
        }

        public MetadataStandard getStandard() {
            return null;
        }
    }
}

