/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.geotools.factory.Factories;
import org.geotools.factory.FactoryIteratorProvider;
import org.geotools.factory.Hints;
import org.geotools.resources.Arguments;
import org.geotools.resources.Utilities;
import org.geotools.resources.XMath;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Version;
import org.geotools.util.logging.LoggerFactory;
import org.geotools.util.logging.Logging;

public final class GeoTools {
    private static final Version VERSION;
    private static final EventListenerList LISTENERS;
    private static final Map BINDINGS;
    public static final String CRS_AUTHORITY_EXTRA_DIRECTORY = "org.geotools.referencing.crs-directory";
    public static final String EPSG_DATA_SOURCE = "org.geotools.referencing.epsg-datasource";
    public static final String FORCE_LONGITUDE_FIRST_AXIS_ORDER = "org.geotools.referencing.forceXY";
    private static InitialContext context;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$geotools$factory$Hints$Key;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Number;

    private GeoTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bind(String property, RenderingHints.Key key) {
        Map map = BINDINGS;
        synchronized (map) {
            RenderingHints.Key old = BINDINGS.put(property, key);
            if (old == null) {
                return;
            }
            BINDINGS.put(property, old);
        }
        throw new IllegalArgumentException(Errors.format(42, "property", property));
    }

    public static Version getVersion() {
        return VERSION;
    }

    public void setLoggerFactory(LoggerFactory factory) {
        Logging.GEOTOOLS.setLoggerFactory(factory);
    }

    public static void init(Hints hints) {
        Logging log = Logging.GEOTOOLS;
        try {
            log.setLoggerFactory("org.geotools.util.logging.CommonsLoggerFactory");
        }
        catch (ClassNotFoundException commonsException) {
            try {
                log.setLoggerFactory("org.geotools.util.logging.Log4JLoggerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (log.getLoggerFactory() == null) {
            log.forceMonolineConsoleOutput();
        }
        if (hints != null) {
            Hints.putSystemDefault(hints);
        }
    }

    public static synchronized void init(InitialContext applicationContext) {
        context = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean scanForSystemHints(Hints hints) {
        if (!$assertionsDisabled && !Thread.holdsLock(hints)) {
            throw new AssertionError();
        }
        boolean changed = false;
        Map map = BINDINGS;
        synchronized (map) {
            Iterator it = BINDINGS.entrySet().iterator();
            while (it.hasNext()) {
                Object old;
                String property;
                Map.Entry entry = it.next();
                String propertyKey = (String)entry.getKey();
                try {
                    property = System.getProperty(propertyKey);
                }
                catch (SecurityException e) {
                    GeoTools.unexpectedException(e);
                    continue;
                }
                if (property == null) continue;
                Object value = property;
                RenderingHints.Key hintKey = (RenderingHints.Key)entry.getValue();
                if (hintKey.getClass().equals(class$org$geotools$factory$Hints$Key == null ? GeoTools.class$("org.geotools.factory.Hints$Key") : class$org$geotools$factory$Hints$Key)) {
                    Class type = ((Hints.Key)hintKey).getValueClass();
                    if (type.equals(class$java$lang$Boolean == null ? GeoTools.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                        value = Boolean.valueOf(property);
                    } else if ((class$java$lang$Number == null ? GeoTools.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(type)) {
                        try {
                            value = XMath.valueOf(type, property);
                        }
                        catch (NumberFormatException e) {
                            GeoTools.unexpectedException(e);
                            continue;
                        }
                    }
                }
                try {
                    old = hints.put(hintKey, value);
                }
                catch (IllegalArgumentException e) {
                    GeoTools.unexpectedException(e);
                    continue;
                }
                if (changed || Utilities.equals(old, value)) continue;
                changed = true;
            }
        }
        return changed;
    }

    private static void unexpectedException(Exception exception) {
        Logging.unexpectedException("org.geotools.factory", Hints.class, "scanSystemProperties", (Throwable)exception);
    }

    public static Hints getDefaultHints() {
        return Hints.getDefaults(false);
    }

    public static synchronized InitialContext getInitialContext(Hints hints) throws NamingException {
        if (context == null) {
            context = new InitialContext();
        }
        return context;
    }

    public static void addFactoryIteratorProvider(FactoryIteratorProvider provider) {
        Factories.addFactoryIteratorProvider(provider);
    }

    public static void removeFactoryIteratorProvider(FactoryIteratorProvider provider) {
        Factories.removeFactoryIteratorProvider(provider);
    }

    public static void addChangeListener(ChangeListener listener) {
        GeoTools.removeChangeListener(listener);
        LISTENERS.add(ChangeListener.class, listener);
    }

    public static void removeChangeListener(ChangeListener listener) {
        LISTENERS.remove(ChangeListener.class, listener);
    }

    public static void fireConfigurationChanged() {
        ChangeEvent event = new ChangeEvent(GeoTools.class);
        Object[] listeners = LISTENERS.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? GeoTools.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        args = arguments.getRemainingArguments(0);
        arguments.out.print("GeoTools version ");
        arguments.out.println(GeoTools.getVersion());
        Hints hints = GeoTools.getDefaultHints();
        if (hints != null && !hints.isEmpty()) {
            arguments.out.println(hints);
        }
    }

    static {
        $assertionsDisabled = !GeoTools.class.desiredAssertionStatus();
        VERSION = new Version("2.4.SNAPSHOT");
        LISTENERS = new EventListenerList();
        BINDINGS = new HashMap();
        GeoTools.bind(CRS_AUTHORITY_EXTRA_DIRECTORY, Hints.CRS_AUTHORITY_EXTRA_DIRECTORY);
        GeoTools.bind(EPSG_DATA_SOURCE, Hints.EPSG_DATA_SOURCE);
        GeoTools.bind(FORCE_LONGITUDE_FIRST_AXIS_ORDER, Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
    }
}

