/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.geotools.factory.FactoryIteratorProvider;
import org.geotools.factory.FactoryIteratorProviders;
import org.geotools.factory.Hints;
import org.geotools.resources.Arguments;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.geotools.util.Version;
import org.geotools.util.logging.LoggerFactory;
import org.geotools.util.logging.Logging;

public final class GeoTools {
    private static final Properties PROPS;
    private static final Version VERSION;
    private static final String BUILD_REVISION;
    private static final String BUILD_TIMESTAMP;
    private static final EventListenerList LISTENERS;
    private static final Map<String, RenderingHints.Key> BINDINGS;
    public static final String CRS_AUTHORITY_EXTRA_DIRECTORY = "org.geotools.referencing.crs-directory";
    public static final String EPSG_DATA_SOURCE = "org.geotools.referencing.epsg-datasource";
    public static final String FORCE_LONGITUDE_FIRST_AXIS_ORDER = "org.geotools.referencing.forceXY";
    public static final String RESAMPLE_TOLERANCE = "org.geotools.referencing.resampleTolerance";
    private static InitialContext context;
    private static final Set<ClassLoader> addedClassLoaders;

    private GeoTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bind(String property, RenderingHints.Key key) {
        Map<String, RenderingHints.Key> map = BINDINGS;
        synchronized (map) {
            RenderingHints.Key old = BINDINGS.put(property, key);
            if (old == null) {
                return;
            }
            BINDINGS.put(property, old);
        }
        throw new IllegalArgumentException(Errors.format(58, "property", property));
    }

    public static String getAboutInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(GeoTools.getEnvironmentInfo());
        sb.append(String.format("%n", new Object[0]));
        sb.append(GeoTools.getGeoToolsJarInfo());
        return sb.toString();
    }

    public static String getEnvironmentInfo() {
        String newline = String.format("%n", new Object[0]);
        String indent = "    ";
        StringBuilder sb = new StringBuilder();
        sb.append("GeoTools version ").append(GeoTools.getVersion().toString());
        if (sb.toString().endsWith("SNAPSHOT")) {
            sb.append(" (built from r").append(GeoTools.getBuildRevision().toString()).append(")");
        }
        sb.append(newline).append("Java version: ");
        sb.append(System.getProperty("java.version"));
        sb.append(newline).append("Operating system: ");
        sb.append(System.getProperty("os.name")).append(' ').append(System.getProperty("os.version"));
        return sb.toString();
    }

    public static String getGeoToolsJarInfo() {
        StringBuilder sb = new StringBuilder();
        String newline = String.format("%n", new Object[0]);
        String indent = "    ";
        sb.append("GeoTools jars on classpath:");
        for (String jarName : GeoTools.getGeoToolsJars()) {
            sb.append(newline).append("    ").append(jarName);
        }
        return sb.toString();
    }

    private static List<String> getGeoToolsJars() {
        Pattern pattern = Pattern.compile(".*\\/" + GeoTools.getVersion() + "\\/(gt-.*jar$)");
        ArrayList<String> jarNames = new ArrayList<String>();
        String pathSep = System.getProperty("path.separator");
        String classpath = System.getProperty("java.class.path");
        StringTokenizer st = new StringTokenizer(classpath, pathSep);
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            Matcher matcher = pattern.matcher(path);
            if (!matcher.find()) continue;
            jarNames.add(matcher.group(1));
        }
        Collections.sort(jarNames);
        return jarNames;
    }

    public static Version getVersion() {
        return VERSION;
    }

    public static String getBuildRevision() {
        return BUILD_REVISION;
    }

    public static String getBuildTimestamp() {
        return BUILD_TIMESTAMP;
    }

    public void setLoggerFactory(LoggerFactory factory) {
        Logging.GEOTOOLS.setLoggerFactory(factory);
    }

    public static void init(Hints hints) {
        Logging log = Logging.GEOTOOLS;
        try {
            log.setLoggerFactory("org.geotools.util.logging.CommonsLoggerFactory");
        }
        catch (ClassNotFoundException commonsException) {
            try {
                log.setLoggerFactory("org.geotools.util.logging.Log4JLoggerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (log.getLoggerFactory() == null) {
            log.forceMonolineConsoleOutput();
        }
        if (hints != null) {
            Hints.putSystemDefault(hints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(InitialContext applicationContext) {
        Class<GeoTools> clazz = GeoTools.class;
        synchronized (GeoTools.class) {
            context = applicationContext;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            GeoTools.fireConfigurationChanged();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean scanForSystemHints(Hints hints) {
        assert (Thread.holdsLock(hints));
        boolean changed = false;
        Map<String, RenderingHints.Key> map = BINDINGS;
        synchronized (map) {
            for (Map.Entry<String, RenderingHints.Key> entry : BINDINGS.entrySet()) {
                Object old;
                String property;
                String propertyKey = entry.getKey();
                try {
                    property = System.getProperty(propertyKey);
                }
                catch (SecurityException e) {
                    GeoTools.unexpectedException(e);
                    continue;
                }
                if (property == null) continue;
                Object value = property;
                RenderingHints.Key hintKey = entry.getValue();
                if (hintKey.getClass().equals(Hints.Key.class)) {
                    Class<?> type = ((Hints.Key)hintKey).getValueClass();
                    if (type.equals(Boolean.class)) {
                        value = Boolean.valueOf(property);
                    } else if (Number.class.isAssignableFrom(type)) {
                        try {
                            value = Classes.valueOf(type, property);
                        }
                        catch (NumberFormatException e) {
                            GeoTools.unexpectedException(e);
                            continue;
                        }
                    }
                }
                try {
                    old = hints.put(hintKey, value);
                }
                catch (IllegalArgumentException e) {
                    GeoTools.unexpectedException(e);
                    continue;
                }
                if (changed || Utilities.equals(old, value)) continue;
                changed = true;
            }
        }
        return changed;
    }

    private static void unexpectedException(Exception exception) {
        Logging.unexpectedException(Hints.class, "scanSystemProperties", exception);
    }

    public static Hints getDefaultHints() {
        return Hints.getDefaults(false);
    }

    public static Hints addDefaultHints(Hints hints) {
        Hints completed = GeoTools.getDefaultHints();
        if (hints != null) {
            completed.add(hints);
        }
        return completed;
    }

    public static synchronized InitialContext getInitialContext(Hints hints) throws NamingException {
        if (context == null) {
            context = new InitialContext();
        }
        return context;
    }

    public static String fixName(String name) {
        return GeoTools.fixName(null, name, null);
    }

    public static String fixName(Context context, String name) {
        return context != null ? GeoTools.fixName(context, name, null) : name;
    }

    private static String fixName(Context context, String name, Hints hints) {
        String fixed = null;
        if (name != null) {
            StringTokenizer tokens = new StringTokenizer(name, ":/");
            while (tokens.hasMoreTokens()) {
                String part = tokens.nextToken();
                if (fixed == null) {
                    fixed = part;
                    continue;
                }
                try {
                    if (context == null) {
                        context = GeoTools.getInitialContext(hints);
                    }
                    fixed = context.composeName(fixed, part);
                }
                catch (NamingException e) {
                    Logging.unexpectedException(GeoTools.class, "fixName", e);
                    return name;
                }
            }
        }
        return fixed;
    }

    public static void addFactoryIteratorProvider(FactoryIteratorProvider provider) {
        FactoryIteratorProviders.addFactoryIteratorProvider(provider);
    }

    public static void removeFactoryIteratorProvider(FactoryIteratorProvider provider) {
        FactoryIteratorProviders.removeFactoryIteratorProvider(provider);
    }

    public static void addChangeListener(ChangeListener listener) {
        GeoTools.removeChangeListener(listener);
        LISTENERS.add(ChangeListener.class, listener);
    }

    public static void removeChangeListener(ChangeListener listener) {
        LISTENERS.remove(ChangeListener.class, listener);
    }

    public static void fireConfigurationChanged() {
        ChangeEvent event = new ChangeEvent(GeoTools.class);
        Object[] listeners = LISTENERS.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public static void addClassLoader(ClassLoader classLoader) {
        addedClassLoaders.add(classLoader);
        GeoTools.fireConfigurationChanged();
    }

    static Set<ClassLoader> getClassLoaders() {
        return addedClassLoaders;
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        args = arguments.getRemainingArguments(0);
        arguments.out.print("GeoTools version ");
        arguments.out.println(GeoTools.getVersion());
        Hints hints = GeoTools.getDefaultHints();
        if (hints != null && !hints.isEmpty()) {
            arguments.out.println(hints);
        }
    }

    static {
        Properties props = new Properties();
        try {
            props.load(GeoTools.class.getResourceAsStream("GeoTools.properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        PROPS = props;
        VERSION = new Version(PROPS.getProperty("version", "8.0-M4"));
        BUILD_REVISION = PROPS.getProperty("build.revision", "-1");
        BUILD_TIMESTAMP = PROPS.getProperty("build.timestamp", "");
        LISTENERS = new EventListenerList();
        BINDINGS = new HashMap<String, RenderingHints.Key>();
        GeoTools.bind(CRS_AUTHORITY_EXTRA_DIRECTORY, Hints.CRS_AUTHORITY_EXTRA_DIRECTORY);
        GeoTools.bind(EPSG_DATA_SOURCE, Hints.EPSG_DATA_SOURCE);
        GeoTools.bind(FORCE_LONGITUDE_FIRST_AXIS_ORDER, Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
        GeoTools.bind(RESAMPLE_TOLERANCE, Hints.RESAMPLE_TOLERANCE);
        addedClassLoaders = Collections.synchronizedSet(new HashSet());
    }
}

