/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.text;

import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.IIOException;
import javax.media.jai.DeferredProperty;
import javax.media.jai.PropertySource;
import javax.swing.tree.TreeNode;
import org.geotools.coverage.io.AmbiguousMetadataException;
import org.geotools.coverage.io.MetadataException;
import org.geotools.image.io.metadata.GeographicMetadata;
import org.geotools.io.TableWriter;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.resources.Classes;
import org.geotools.resources.OptionalDependencies;
import org.geotools.resources.i18n.Errors;
import org.opengis.referencing.IdentifiedObject;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextMetadataParser {
    protected GeographicMetadata metadata;
    public static final Key COORDINATE_REFERENCE_SYSTEM = new Key("coordinate_reference_system");
    public static final Key COORDINATE_REFERENCE_SYSTEM_TYPE = new Key("coordinate_reference_system_type");
    public static final Key COORDINATE_SYSTEM = new Key("coordinate_system");
    public static final Key COORDINATE_SYSTEM_TYPE = new Key("coordinate_system_type");
    public static final Key UNIT = new Key("Unit");
    public static final Key DATUM = new Key("Datum");
    public static final Key DATUM_TYPE = new Key("Datum_type");
    public static final Key ELLIPSOID = new Key("Ellipsoid");
    public static final Key ELLIPSOID_UNIT = new Key("ellipsoid_unit");
    public static final Key OPERATION_METHOD = new Key("OperationMethod");
    public static final Key PROJECTION = new Key("Projection");
    public static final Key PRIME_MERIDIAN = new Key("prime_meridian");
    public static final Key GREENWICH_LONGITUDE = new Key("greenwich_longitude");
    public static final Key SEMI_MAJOR = new Key("semi_major");
    public static final Key SEMI_MINOR = new Key("semi_minor");
    public static final Key INVERSE_FLATTENING = new Key("inverse_flattening");
    public static final Key LATITUDE_OF_ORIGIN = new Key("latitude_of_origin");
    public static final Key CENTRAL_MERIDIAN = new Key("central_meridian");
    public static final Key FALSE_EASTING = new Key("false_easting");
    public static final Key FALSE_NORTHING = new Key("false_northing");
    public static final Key X_MINIMUM = new Key("XMinimum");
    public static final Key Y_MINIMUM = new Key("YMinimum");
    public static final Key Z_MINIMUM = new Key("ZMinimum");
    public static final Key X_MAXIMUM = new Key("XMaximum");
    public static final Key Y_MAXIMUM = new Key("YMaximum");
    public static final Key Z_MAXIMUM = new Key("ZMaximum");
    public static final Key X_RESOLUTION = new Key("XResolution");
    public static final Key Y_RESOLUTION = new Key("YResolution");
    public static final Key Z_RESOLUTION = new Key("ZResolution");
    public static final Key X_DIRECTION = new Key("XDirection");
    public static final Key Y_DIRECTION = new Key("YDirection");
    public static final Key Z_DIRECTION = new Key("ZDirection");
    public static final Key WIDTH = new Key("Width");
    public static final Key HEIGHT = new Key("Height");
    public static final Key DEPTH = new Key("Depth");
    private String source;
    private String separator = " = ";
    private String trimSeparator = "=";
    private String numberPattern;
    private String datePattern;
    private Map<String, Key> naming;
    private final ReferencingFactoryContainer factories;
    private Locale userLocale;

    public TextMetadataParser() {
        this(ReferencingFactoryContainer.instance(null));
    }

    public TextMetadataParser(ReferencingFactoryContainer factories) {
        this.factories = factories;
    }

    public String getSeparator() {
        return this.separator;
    }

    public synchronized void setSeparator(String separator) {
        this.trimSeparator = separator.trim();
        this.separator = separator;
    }

    public String getFormatPattern(Class<?> type) {
        if (Date.class.isAssignableFrom(type)) {
            return this.datePattern;
        }
        if (Number.class.isAssignableFrom(type)) {
            return this.numberPattern;
        }
        throw new IllegalArgumentException(Errors.format((int)187, type));
    }

    public synchronized void setFormatPattern(Class<?> type, String pattern) {
        if (Date.class.isAssignableFrom(type)) {
            this.datePattern = pattern;
            return;
        }
        if (Number.class.isAssignableFrom(type)) {
            this.numberPattern = pattern;
            return;
        }
        throw new IllegalArgumentException(Errors.format((int)187, type));
    }

    public synchronized void clear() {
        this.source = null;
    }

    public synchronized void load(File header) throws IOException {
        this.source = header.getPath();
        BufferedReader in = new BufferedReader(new FileReader(header));
        this.load(in);
        in.close();
    }

    public synchronized void load(URL header) throws IOException {
        this.source = header.getPath();
        BufferedReader in = new BufferedReader(new InputStreamReader(header.openStream()));
        this.load(in);
        in.close();
    }

    protected void load(BufferedReader in) throws IOException {
        String line;
        assert (Thread.holdsLock(this));
        HashSet<String> previousComments = new HashSet<String>();
        StringBuilder comments = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator", "\n");
        while ((line = in.readLine()) != null) {
            if (line.trim().length() == 0 || this.parseLine(line) || !previousComments.add(line)) continue;
            comments.append(line);
            comments.append(lineSeparator);
        }
        if (comments.length() != 0) {
            this.add((String)null, (Object)comments.toString());
        }
        this.putDone();
    }

    protected boolean parseLine(String line) throws IIOException {
        int index = line.indexOf(this.trimSeparator);
        if (index >= 0) {
            this.add(line.substring(0, index), (Object)line.substring(index + 1));
            return true;
        }
        return false;
    }

    public synchronized void add(RenderedImage image) throws AmbiguousMetadataException {
        if (image instanceof PropertySource) {
            this.add((PropertySource)image, null);
        } else {
            String[] names = image.getPropertyNames();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    this.add(name, image.getProperty(name));
                }
            }
        }
    }

    public synchronized void add(PropertySource properties, String prefix) throws AmbiguousMetadataException {
        String[] names;
        String[] stringArray = names = prefix != null ? properties.getPropertyNames(prefix) : properties.getPropertyNames();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                Class classe = properties.getPropertyClass(name);
                this.add(name, (Object)new DeferredProperty(properties, name, classe));
            }
        }
    }

    public synchronized void add(String alias, Object value) throws AmbiguousMetadataException {
        Key aliasAsKey;
        if (alias != null) {
            alias = alias.trim();
            aliasAsKey = new Key(alias);
        } else {
            aliasAsKey = null;
        }
        this.add(aliasAsKey, value);
    }

    private void add(Key aliasAsKey, Object value) throws AmbiguousMetadataException {
        assert (this.isValid());
        if (value == null || value == Image.UndefinedProperty) {
            return;
        }
        if (value instanceof CharSequence) {
            String text = TextMetadataParser.trim(value.toString().trim(), " ");
            if (text.length() == 0) {
                return;
            }
            value = text;
        }
        this.put(aliasAsKey, value);
    }

    public synchronized void addAlias(Key key, String alias) throws AmbiguousMetadataException {
        Key keyFound;
        alias = TextMetadataParser.trim(alias.trim(), " ");
        Key aliasAsKey = new Key(alias);
        if (this.naming == null) {
            this.naming = new LinkedHashMap<String, Key>();
        }
        if ((keyFound = this.naming.get(aliasAsKey)) == null) {
            keyFound = new Key(alias);
            this.naming.put(alias, keyFound);
        }
        assert (this.isValid());
    }

    private boolean isValid() {
        assert (Thread.holdsLock(this));
        if (this.naming != null) {
            for (Key key : this.naming.values()) {
                if (this.naming.keySet().contains(key.name)) continue;
                return false;
            }
        }
        return true;
    }

    private String toString(Object value, Key key, String alias) throws MetadataException {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value instanceof IdentifiedObject) {
            return ((IdentifiedObject)value).getName().getCode();
        }
        throw new MetadataException(Errors.getResources((Locale)this.userLocale).getString(22, (Object)Classes.getClass((Object)value)), key, alias);
    }

    public synchronized Set<String> getAlias(Key key) {
        Set<Map.Entry<String, Key>> entries;
        assert (this.isValid());
        if (this.naming != null && (entries = this.naming.entrySet()) != null) {
            HashSet<String> alias = new HashSet<String>();
            for (String aliasKey : alias) {
                if (!key.name.equalsIgnoreCase(aliasKey)) continue;
                alias.add(aliasKey);
            }
            return alias;
        }
        return null;
    }

    public String getSource() throws MetadataException {
        return this.source;
    }

    public Locale getLocale() {
        return Locale.US;
    }

    final synchronized void setUserLocale(Locale locale) {
        this.userLocale = locale;
    }

    protected GeographicMetadata getGeographicMetadata() {
        return this.metadata;
    }

    protected void setGeographicMetadata(GeographicMetadata metadata) {
        this.metadata = metadata;
    }

    protected abstract void put(Key var1, Object var2);

    protected abstract void putDone();

    public String toString() {
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringWriter buffer = new StringWriter();
        if (this.source != null) {
            buffer.write("[\"");
            buffer.write(this.source);
            buffer.write("\"]");
        }
        buffer.write(lineSeparator);
        buffer.write(123);
        buffer.write(lineSeparator);
        try {
            TableWriter table = new TableWriter((Writer)buffer, 2);
            table.setMultiLinesCells(true);
            table.nextColumn();
            table.write(OptionalDependencies.toString((TreeNode)OptionalDependencies.xmlToSwing((Node)this.metadata.getAsTree("geotools_coverage_1.0"))));
            table.flush();
        }
        catch (IOException exception) {
            buffer.write(exception.getLocalizedMessage());
        }
        buffer.write(125);
        buffer.write(lineSeparator);
        return buffer.toString();
    }

    static String trim(String str, String separator) {
        if (str != null) {
            str = str.trim();
            StringBuilder buffer = null;
            int i = str.length();
            block0: while (--i >= 0) {
                if (!Character.isSpaceChar(str.charAt(i))) continue;
                int upper = i;
                while (--i >= 0) {
                    if (Character.isSpaceChar(str.charAt(i))) continue;
                    if (buffer == null) {
                        buffer = new StringBuilder(str);
                    }
                    buffer.replace(i + 1, upper + 1, separator);
                    continue block0;
                }
                break block0;
            }
            if (buffer != null) {
                return buffer.toString();
            }
        }
        return str;
    }

    public static class Key
    implements Serializable {
        private static final long serialVersionUID = -6197070349689520675L;
        private final String name;
        private final String key;

        public Key(String name) {
            this.name = name = name.trim();
            this.key = TextMetadataParser.trim(name, "_").toLowerCase();
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object object) {
            return object != null && object.getClass().equals(this.getClass()) && this.key.equals(((Key)object).key);
        }
    }
}

