/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.text;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import javax.imageio.ImageReadParam;
import org.geotools.image.io.text.TextImageReader;
import org.geotools.io.LineFormat;
import org.geotools.resources.XArray;

final class TestReader
extends TextImageReader {
    private InputStream marked;

    public TestReader(TextImageReader.Spi provider) {
        super(provider);
    }

    public int getWidth(int imageIndex) {
        return 0;
    }

    public int getHeight(int imageIndex) {
        return 0;
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) {
        throw new UnsupportedOperationException();
    }

    private Reader getReader(int readAheadLimit) throws IllegalStateException, IOException {
        Object input = this.getInput();
        if (input instanceof Reader) {
            Reader reader = (Reader)input;
            if (!reader.markSupported()) {
                return null;
            }
            reader.mark(readAheadLimit);
            return reader;
        }
        InputStream stream = this.getInputStream();
        if (this.closeOnReset == null) {
            if (!stream.markSupported()) {
                return null;
            }
            stream.mark(readAheadLimit);
        }
        Reader reader = this.getInputStreamReader(stream);
        if (this.closeOnReset == stream) {
            this.closeOnReset = reader;
        }
        return reader;
    }

    final boolean canDecode(int readAheadLimit) throws IOException {
        Reader input = this.getReader(readAheadLimit);
        if (input == null) {
            return false;
        }
        TextImageReader.Spi spi = (TextImageReader.Spi)this.originatingProvider;
        char[] buffer = new char[readAheadLimit];
        int length = input.read(buffer);
        LineFormat parser = this.getLineFormat(0);
        Object rows = new double[16][];
        int rowCount = 0;
        int lower = 0;
        block2: while (lower < readAheadLimit) {
            char c = buffer[lower];
            if (c == '\r' || c == 'n') {
                ++lower;
                continue;
            }
            int upper = lower;
            while ((c = buffer[upper]) != '\r' && c != '\n') {
                if (++upper < readAheadLimit) continue;
                break block2;
            }
            String line = new String(buffer, lower, upper - lower);
            if (!this.isComment(line)) {
                try {
                    if (parser.setLine(line) != 0) {
                        if (rowCount == ((double[][])rows).length) {
                            rows = (double[][])XArray.resize((Object[])rows, (int)(((double[][])rows).length * 2));
                        }
                        rows[rowCount] = parser.getValues(rows[rowCount]);
                        ++rowCount;
                    }
                }
                catch (ParseException exception) {
                    return false;
                }
            }
            lower = upper;
        }
        if (this.originatingProvider instanceof TextImageReader.Spi) {
            rows = (double[][])XArray.resize((Object[])rows, (int)rowCount);
            return ((TextImageReader.Spi)this.originatingProvider).isValidContent((double[][])rows);
        }
        return true;
    }

    protected void close() throws IOException {
        if (this.marked != null) {
            this.marked.reset();
            this.marked = null;
        }
        super.close();
    }
}

