/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.image.io.mosaic.GridNode;
import org.geotools.image.io.mosaic.SelectedNode;
import org.geotools.image.io.mosaic.Tile;
import org.geotools.image.io.mosaic.TreeNode;
import org.geotools.resources.OptionalDependencies;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RTree {
    private static final Logger LOGGER = Logging.getLogger(RTree.class);
    private static final Level LEVEL = Level.FINER;
    protected final TreeNode root;
    protected Rectangle regionOfInterest;
    protected Dimension subsampling;
    protected boolean subsamplingChangeAllowed;
    private Dimension subsamplingCandidate;
    private final Set<Dimension> subsamplingDone;
    private final Queue<Dimension> subsamplingToTry;
    private final Map<Rectangle, SelectedNode> distinctBounds;
    boolean inUse;

    public RTree(TreeNode root) {
        this.root = root;
        this.subsamplingDone = new HashSet<Dimension>();
        this.subsamplingToTry = new LinkedList<Dimension>();
        this.distinctBounds = new HashMap<Rectangle, SelectedNode>();
    }

    public RTree clone() {
        return new RTree(this.root);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.root);
    }

    public Dimension getTileSize() {
        Dimension tileSize = new Dimension();
        for (TreeNode node : this.root) {
            GridNode child = (GridNode)node;
            int width = child.width / child.getXSubsampling();
            int height = child.height / child.getYSubsampling();
            if (width > tileSize.width) {
                tileSize.width = width;
            }
            if (height <= tileSize.height) continue;
            tileSize.height = height;
        }
        return tileSize;
    }

    public boolean intersects() {
        return ((GridNode)this.root).intersects(this.regionOfInterest, this.subsampling);
    }

    private static Dimension getSubsamplingFloor(TreeNode node, Dimension subsampling) {
        Dimension floor;
        Tile tile = node.tile;
        if (tile != null && (floor = tile.getSubsamplingFloor(subsampling)) != null) {
            return floor;
        }
        for (node = node.firstChildren(); node != null; node = node.nextSibling()) {
            floor = RTree.getSubsamplingFloor(node, subsampling);
            if (floor == null) continue;
            return floor;
        }
        return subsampling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tile> searchTiles() throws IOException {
        assert (this.subsamplingDone.isEmpty() && this.subsamplingToTry.isEmpty() && this.distinctBounds.isEmpty());
        Dimension bestSubsampling = this.subsamplingCandidate = this.subsampling;
        SelectedNode bestCandidate = null;
        int bestCandidateCount = 0;
        long lowestCost = Long.MAX_VALUE;
        try {
            Dimension floor;
            if (this.subsamplingChangeAllowed && (floor = RTree.getSubsamplingFloor(this.root, this.subsampling)) != this.subsampling) {
                this.subsamplingDone.add(this.subsampling);
                this.subsamplingToTry.add(this.subsampling);
                this.subsamplingCandidate = floor;
            }
            do {
                int candidateCount;
                SelectedNode candidate;
                if ((candidate = this.addTileCandidate(this.root, lowestCost)) == null) continue;
                try {
                    candidate.removeTrivialOverlaps(this.distinctBounds);
                    candidateCount = this.distinctBounds.size();
                }
                finally {
                    this.distinctBounds.clear();
                }
                if (bestCandidate != null && !candidate.isCheaperThan(bestCandidate)) continue;
                bestCandidate = candidate;
                bestCandidateCount = candidateCount;
                bestSubsampling = this.subsamplingCandidate;
                lowestCost = candidate.cost;
            } while ((this.subsamplingCandidate = this.subsamplingToTry.poll()) != null);
        }
        finally {
            this.subsamplingToTry.clear();
            this.subsamplingDone.clear();
        }
        this.subsampling.setSize(bestSubsampling);
        ArrayList<Tile> tiles = new ArrayList<Tile>(bestCandidateCount);
        if (bestCandidate != null) {
            assert (bestCandidate.checkValidity()) : bestCandidate.toTree();
            bestCandidate.getTiles(tiles);
            if (LOGGER.isLoggable(LEVEL)) {
                String lineSeparator = System.getProperty("line.separator", "\n");
                StringBuilder message = new StringBuilder("Tiles count: ").append(tiles.size()).append(lineSeparator);
                OptionalDependencies.format((javax.swing.tree.TreeNode)bestCandidate, (Appendable)message, (String)lineSeparator);
                LogRecord record = new LogRecord(LEVEL, message.toString());
                record.setSourceClassName("org.geotools.image.io.mosaic.TileManager");
                record.setSourceMethodName("getTiles");
                record.setLoggerName(LOGGER.getName());
                LOGGER.log(record);
            }
        }
        assert (tiles.isEmpty() == !this.intersects()) : tiles;
        return tiles;
    }

    private SelectedNode addTileCandidate(TreeNode node, long costLimit) throws IOException {
        long cost;
        if (!node.intersects(this.regionOfInterest)) {
            return null;
        }
        SelectedNode selected = null;
        Tile tile = node.tile;
        if (tile != null) {
            assert (node.equals(tile.getAbsoluteRegion())) : tile;
            Dimension floor = tile.getSubsamplingFloor(this.subsamplingCandidate);
            if (floor != null) {
                if (floor != this.subsamplingCandidate) {
                    if (this.subsamplingChangeAllowed && this.subsamplingDone.add(floor)) {
                        this.subsamplingToTry.add(floor);
                    }
                } else {
                    Rectangle readRegion = node.intersection(this.regionOfInterest);
                    selected = new SelectedNode(readRegion);
                    selected.tile = tile;
                    selected.cost = tile.countUnwantedPixelsFromAbsolute(readRegion, this.subsampling);
                }
            }
        }
        if (node.isLeaf()) {
            return selected;
        }
        if (selected == null) {
            selected = new SelectedNode(node.intersection(this.regionOfInterest));
            cost = selected.cost;
        } else {
            cost = selected.cost;
            if (cost == 0L || selected.equals(node) && !tile.isFinerThan(this.subsamplingCandidate)) {
                return selected;
            }
            if (cost < costLimit) {
                costLimit = cost;
            }
        }
        for (TreeNode child : node) {
            selected.addChild(this.addTileCandidate(child, costLimit));
            if (selected.cost - cost < costLimit) continue;
            if (selected.tile != null) {
                selected.removeChildren();
            }
            return selected;
        }
        selected.tile = null;
        selected.cost -= cost;
        if (selected.isLeaf()) {
            return null;
        }
        TreeNode child = selected.getChild();
        if (child != null && child.equals(selected)) {
            selected.removeChildren();
            selected = (SelectedNode)child;
        }
        return selected;
    }

    public String toString() {
        return OptionalDependencies.toString((javax.swing.tree.TreeNode)this.root);
    }
}

