/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.geotools.factory.GeoTools;
import org.geotools.image.io.ImageIOExt;
import org.geotools.image.io.mosaic.GridNode;
import org.geotools.image.io.mosaic.MosaicImageReadParam;
import org.geotools.image.io.mosaic.MosaicImageReader;
import org.geotools.image.io.mosaic.MosaicImageWriteParam;
import org.geotools.image.io.mosaic.Tile;
import org.geotools.image.io.mosaic.TileManager;
import org.geotools.image.io.mosaic.TileManagerFactory;
import org.geotools.image.io.mosaic.TileWritingPolicy;
import org.geotools.image.io.mosaic.TreeNode;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MosaicImageWriter
extends ImageWriter {
    private static final int FILL_VALUE = 0;
    private Level level = Level.FINE;
    private ExecutorService executor;

    public MosaicImageWriter() {
        this(null);
    }

    public MosaicImageWriter(ImageWriterSpi spi) {
        super(spi != null ? spi : Spi.DEFAULT);
    }

    public Level getLogLevel() {
        return this.level;
    }

    public void setLogLevel(Level level) {
        if (level == null) {
            level = Level.FINE;
        }
        this.level = level;
    }

    public TileManager[] getOutput() {
        TileManager[] managers = (TileManager[])super.getOutput();
        return managers != null ? (TileManager[])managers.clone() : null;
    }

    @Override
    public void setOutput(Object output) throws IllegalArgumentException {
        TileManager[] managers;
        try {
            managers = TileManagerFactory.DEFAULT.createFromObject(output);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage(), e);
        }
        super.setOutput(managers);
    }

    @Override
    public MosaicImageWriteParam getDefaultWriteParam() {
        return new MosaicImageWriteParam();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(IIOMetadata metadata, IIOImage image, ImageWriteParam param) throws IOException {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
        while (writers.hasNext()) {
            ImageWriter writer = writers.next();
            if (!this.filter(writer)) continue;
            File file = File.createTempFile("MIW", ".png");
            try {
                ImageOutputStream output = ImageIOExt.createImageOutputStream((RenderedImage)image.getRenderedImage(), (Object)file);
                writer.setOutput(output);
                writer.write(metadata, image, param);
                output.close();
                param = param instanceof MosaicImageWriteParam ? new MosaicImageWriteParam((MosaicImageWriteParam)param) : null;
                this.writeFromInput(file, 0, param);
            }
            finally {
                file.delete();
            }
            return;
        }
        throw new IIOException(Errors.format((int)135));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeFromInput(Object input, int inputIndex, ImageWriteParam param) throws IOException {
        boolean success;
        ImageReader reader = this.getImageReader(input);
        try {
            success = this.writeFromReader(reader, inputIndex, param);
            MosaicImageWriter.close(reader.getInput(), input);
        }
        finally {
            reader.dispose();
        }
        return success;
    }

    private boolean writeFromReader(ImageReader reader, int inputIndex, ImageWriteParam writeParam) throws IOException {
        boolean logReads;
        int bytesPerPixel;
        List<Tile> tiles;
        TileWritingPolicy policy;
        int outputIndex;
        this.clearAbortRequest();
        if (writeParam instanceof MosaicImageWriteParam) {
            MosaicImageWriteParam param = (MosaicImageWriteParam)writeParam;
            outputIndex = param.getOutputIndex();
            policy = param.getTileWritingPolicy();
        } else {
            outputIndex = 0;
            policy = TileWritingPolicy.OVERWRITE;
        }
        this.processImageStarted(outputIndex);
        TileManager[] managers = this.getOutput();
        if (managers == null) {
            throw new IllegalStateException(Errors.format((int)133));
        }
        if (policy.equals((Object)TileWritingPolicy.NO_WRITE)) {
            tiles = Collections.emptyList();
            bytesPerPixel = 1;
        } else {
            tiles = new LinkedList<Tile>(managers[outputIndex].getTiles());
            SampleModel model = reader.getRawImageType(inputIndex).getSampleModel();
            bytesPerPixel = Math.max(1, model.getNumBands() * DataBuffer.getDataTypeSize(model.getDataType()) / 8);
        }
        int initialTileCount = tiles.size();
        if (!policy.overwrite) {
            Iterator it = tiles.iterator();
            while (it.hasNext()) {
                File file;
                Tile tile = (Tile)it.next();
                Object input = tile.getInput();
                if (!(input instanceof File) || !(file = (File)input).isFile()) continue;
                it.remove();
            }
        }
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        }
        ArrayList tasks = new ArrayList();
        GridNode tree = new GridNode(tiles.toArray(new Tile[tiles.size()]));
        ImageReadParam readParam = reader.getDefaultReadParam();
        final Logger logger = Logging.getLogger(MosaicImageWriter.class);
        final boolean logWrites = logger.isLoggable(this.level);
        boolean bl = logReads = !(reader instanceof MosaicImageReader);
        if (!logReads) {
            ((MosaicImageReader)reader).setLogLevel(this.level);
        }
        if (writeParam != null) {
            if (writeParam.getSourceXSubsampling() != 1 || writeParam.getSubsamplingXOffset() != 0 || writeParam.getSourceYSubsampling() != 1 || writeParam.getSubsamplingYOffset() != 0 || writeParam.getSourceRegion() != null) {
                throw new IllegalArgumentException(Errors.format((int)172, (Object)"writeFromInput"));
            }
            readParam.setSourceBands(writeParam.getSourceBands());
        }
        long maximumMemory = this.getMaximumMemoryAllocation();
        int maximumPixelCount = (int)(maximumMemory / (long)bytesPerPixel);
        BufferedImage image = null;
        while (!tiles.isEmpty()) {
            if (this.abortRequested()) {
                this.processWriteAborted();
                return false;
            }
            this.processImageProgress((float)(initialTileCount - tiles.size()) * 100.0f / (float)initialTileCount);
            Dimension imageSubsampling = new Dimension();
            Tile imageTile = MosaicImageWriter.getEnclosingTile(tiles, tree, imageSubsampling, image != null ? new Dimension(image.getWidth(), image.getHeight()) : null, maximumPixelCount);
            Rectangle imageRegion = imageTile.getAbsoluteRegion();
            this.awaitTermination(tasks);
            if (image != null) {
                int width = imageRegion.width / imageSubsampling.width;
                int height = imageRegion.height / imageSubsampling.height;
                if (width == image.getWidth() && height == image.getHeight()) {
                    ImageUtilities.fill((WritableRenderedImage)image, (Number)0);
                    assert (this.isEmpty(image, new Rectangle(image.getWidth(), image.getHeight())));
                } else {
                    image = null;
                }
                maximumPixelCount = (int)(maximumMemory / (long)bytesPerPixel);
            }
            readParam.setDestination(image);
            readParam.setSourceRegion(imageRegion);
            readParam.setSourceSubsampling(imageSubsampling.width, imageSubsampling.height, 0, 0);
            if (readParam instanceof MosaicImageReadParam) {
                ((MosaicImageReadParam)readParam).setNullForEmptyImage(true);
            }
            if (logReads) {
                LogRecord record = this.getLogRecord(false, 126, imageTile);
                record.setLoggerName(logger.getName());
                logger.log(record);
            }
            System.gc();
            try {
                image = reader.read(inputIndex, readParam);
            }
            catch (OutOfMemoryError error) {
                if ((maximumPixelCount >>>= 1) == 0) {
                    throw error;
                }
                if (!logWrites) continue;
                LogRecord record = this.getLogRecord(true, 35, Float.valueOf((float)imageRegion.width * (float)imageRegion.height / 1048576.0f));
                record.setLoggerName(logger.getName());
                logger.log(record);
                continue;
            }
            assert (image == null || image.getWidth() * imageSubsampling.width == imageRegion.width && image.getHeight() * imageSubsampling.height == imageRegion.height) : imageTile;
            assert (tiles.contains(imageTile)) : imageTile;
            Iterator<Tile> it = tiles.iterator();
            while (it.hasNext()) {
                Rectangle sourceRegion;
                final Tile tile = it.next();
                Dimension subsampling = tile.getSubsampling();
                if (!MosaicImageWriter.isDivisor(subsampling, imageSubsampling) || !imageRegion.contains(sourceRegion = tile.getAbsoluteRegion())) continue;
                int xSubsampling = subsampling.width / imageSubsampling.width;
                int ySubsampling = subsampling.height / imageSubsampling.height;
                sourceRegion.translate(-imageRegion.x, -imageRegion.y);
                sourceRegion.x /= imageSubsampling.width;
                sourceRegion.y /= imageSubsampling.height;
                sourceRegion.width /= imageSubsampling.width;
                sourceRegion.height /= imageSubsampling.height;
                if (image != null && (policy.includeEmpty || !this.isEmpty(image, sourceRegion))) {
                    final ImageWriter writer = this.getImageWriter(tile, image);
                    final ImageWriteParam wp = writer.getDefaultWriteParam();
                    this.onTileWrite(tile, wp);
                    wp.setSourceRegion(sourceRegion);
                    wp.setSourceSubsampling(xSubsampling, ySubsampling, 0, 0);
                    final IIOImage iioImage = new IIOImage(image, null, null);
                    final Object tileInput = tile.getInput();
                    tasks.add(this.executor.submit(new Callable<Object>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Object call() throws IOException {
                            if (!MosaicImageWriter.this.abortRequested()) {
                                if (logWrites) {
                                    LogRecord record = MosaicImageWriter.this.getLogRecord(false, 191, tile);
                                    record.setLoggerName(logger.getName());
                                    logger.log(record);
                                }
                                boolean success = false;
                                try {
                                    writer.write(null, iioImage, wp);
                                    MosaicImageWriter.close(writer.getOutput(), tileInput);
                                    success = true;
                                }
                                finally {
                                    if (success) {
                                        writer.dispose();
                                    } else {
                                        Object output = writer.getOutput();
                                        writer.dispose();
                                        MosaicImageWriter.close(output, null);
                                        if (tileInput instanceof File) {
                                            ((File)tileInput).delete();
                                        }
                                    }
                                }
                            }
                            return null;
                        }
                    }));
                }
                it.remove();
                if (!tree.remove(tile)) {
                    throw new AssertionError(tile);
                }
            }
            assert (!tiles.contains(imageTile)) : imageTile;
        }
        this.awaitTermination(tasks);
        if (this.abortRequested()) {
            this.processWriteAborted();
            return false;
        }
        this.processImageComplete();
        return true;
    }

    private static void close(Object stream, Object user) throws IOException {
        if (stream != user) {
            if (stream instanceof Closeable) {
                ((Closeable)stream).close();
            } else if (stream instanceof ImageInputStream) {
                ((ImageInputStream)stream).close();
            }
        }
    }

    private final void awaitTermination(List<Future<?>> tasks) throws IOException {
        Throwable exception = null;
        for (int i = 0; i < tasks.size(); ++i) {
            Future<?> task = tasks.get(i);
            try {
                task.get();
                continue;
            }
            catch (ExecutionException e) {
                if (exception == null) {
                    exception = e.getCause();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.abort();
            int j = tasks.size();
            while (--j > i) {
                task = tasks.get(j);
                if (!task.cancel(false)) continue;
                tasks.remove(j);
            }
        }
        tasks.clear();
        if (exception != null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof Error) {
                throw (Error)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    private LogRecord getLogRecord(boolean log, int key, Object arg) {
        Loggings bundle = log ? Loggings.getResources((Locale)this.locale) : Vocabulary.getResources((Locale)this.locale);
        LogRecord record = bundle.getLogRecord(this.level, key, arg);
        record.setSourceClassName(MosaicImageWriter.class.getName());
        record.setSourceMethodName("writeFromInput");
        return record;
    }

    private static Tile getEnclosingTile(List<Tile> tiles, TreeNode tree, Dimension imageSubsampling, Dimension preferredSize, int maximumPixelCount) throws IOException {
        int area;
        if (preferredSize != null && (area = preferredSize.width * preferredSize.height) < maximumPixelCount / 2) {
            preferredSize = null;
        }
        HashSet<Dimension> subsamplingDone = tiles.size() > 24 ? new HashSet<Dimension>() : null;
        boolean selectedHasPreferredSize = false;
        int selectedCount = 0;
        Tile selectedTile = null;
        Tile fallbackTile = null;
        long fallbackArea = Long.MAX_VALUE;
        assert (tree.containsAll(tiles));
        block0: for (Tile tile : tiles) {
            boolean isPreferredSize;
            Rectangle region = tile.getAbsoluteRegion();
            Dimension subsampling = tile.getSubsampling();
            if (subsamplingDone != null && !subsamplingDone.add(subsampling)) continue;
            Collection<Tile> enclosed = tree.containedIn(region);
            assert (enclosed.contains(tile)) : tile;
            if (enclosed.size() <= selectedCount) {
                assert (selectedTile != null) : selectedCount;
                continue;
            }
            Dimension finestSubsampling = subsampling;
            int smallestPixelArea = subsampling.width * subsampling.height;
            for (Tile subtile : enclosed) {
                Dimension s = subtile.getSubsampling();
                int pixelArea = s.width * s.height;
                if (pixelArea >= smallestPixelArea) continue;
                smallestPixelArea = pixelArea;
                finestSubsampling = s;
            }
            long area2 = (long)region.width * (long)region.height;
            if ((area2 /= (long)smallestPixelArea) > (long)maximumPixelCount) {
                if (area2 >= fallbackArea) continue;
                fallbackArea = area2;
                fallbackTile = tile;
                continue;
            }
            Iterator<Tile> it = enclosed.iterator();
            while (it.hasNext()) {
                Tile subtile = it.next();
                Dimension s = subtile.getSubsampling();
                if (!MosaicImageWriter.isDivisor(subsampling, s)) {
                    it.remove();
                    if (!s.equals(finestSubsampling)) continue;
                    continue block0;
                }
                Rectangle subregion = subtile.getAbsoluteRegion();
                area2 = (long)subregion.width * (long)subregion.height;
                if ((area2 /= (long)smallestPixelArea) <= (long)maximumPixelCount) continue;
                it.remove();
                if (!s.equals(finestSubsampling)) continue;
                continue block0;
            }
            int tileCount = enclosed.size();
            boolean bl = isPreferredSize = preferredSize != null && region.width / finestSubsampling.width == preferredSize.width && region.height / finestSubsampling.height == preferredSize.height;
            if (selectedTile != null && tileCount <= selectedCount && (!isPreferredSize || selectedHasPreferredSize)) continue;
            selectedTile = tile;
            selectedCount = tileCount;
            selectedHasPreferredSize = isPreferredSize;
            imageSubsampling.setSize(finestSubsampling);
        }
        if (selectedTile == null) {
            selectedTile = fallbackTile;
            imageSubsampling.setSize(fallbackTile.getSubsampling());
        }
        return selectedTile;
    }

    private static boolean isDivisor(Dimension numerator, Dimension denominator) {
        return numerator.width % denominator.width == 0 && numerator.height % denominator.height == 0;
    }

    public long getMaximumMemoryAllocation() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long usedMemory = runtime.totalMemory() - runtime.freeMemory();
        return Math.min(0x8000000L, runtime.maxMemory() - 2L * usedMemory);
    }

    protected boolean filter(ImageReader reader) throws IOException {
        return true;
    }

    protected boolean filter(ImageWriter writer) throws IOException {
        return true;
    }

    private boolean isEmpty(BufferedImage image, Rectangle region) {
        int[] data = null;
        WritableRaster raster = image.getRaster();
        int xmax = region.x + region.width;
        int ymax = region.y + region.height;
        for (int y = region.y; y < ymax; ++y) {
            for (int x = region.x; x < xmax; ++x) {
                data = raster.getPixel(x, y, data);
                int i = data.length;
                while (--i >= 0) {
                    if (data[i] == 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void onTileWrite(Tile tile, ImageWriteParam parameters) throws IOException {
    }

    private ImageReader getImageReader(Object input) throws IOException {
        ImageReader reader;
        for (Class<?> type : MosaicImageReader.Spi.INPUT_TYPES) {
            if (!type.isInstance(input)) continue;
            reader = new MosaicImageReader();
            reader.setInput(input);
            if (!this.filter(reader)) break;
            return reader;
        }
        ImageInputStream stream = null;
        boolean createStream = false;
        do {
            Object candidate;
            if (createStream) {
                stream = ImageIO.createImageInputStream(input);
                if (stream == null) continue;
                candidate = stream;
            } else {
                candidate = input;
            }
            Iterator<ImageReader> readers = ImageIO.getImageReaders(candidate);
            while (readers.hasNext()) {
                reader = readers.next();
                reader.setInput(candidate);
                if (this.filter(reader)) {
                    return reader;
                }
                reader.dispose();
            }
        } while (createStream = !createStream);
        if (stream != null) {
            stream.close();
        }
        throw new IIOException(Errors.format((int)134));
    }

    private ImageWriter getImageWriter(Tile tile, RenderedImage image) throws IOException {
        Object output = tile.getInput();
        Class<?> outputType = output.getClass();
        ImageReaderSpi readerSpi = tile.getImageReaderSpi();
        Object[] formatNames = readerSpi.getFormatNames();
        String[] spiNames = readerSpi.getImageWriterSpiNames();
        ImageInputStream stream = null;
        if (spiNames != null) {
            IIORegistry registry = IIORegistry.getDefaultInstance();
            ImageWriterSpi[] providers = new ImageWriterSpi[spiNames.length];
            int count = 0;
            block2: for (String name : spiNames) {
                ImageWriterSpi spi;
                Object[] names;
                Class<?> spiType;
                try {
                    spiType = Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                Object candidate = registry.getServiceProviderByClass(spiType);
                if (!(candidate instanceof ImageWriterSpi) || !XArray.intersects((Object[])formatNames, (Object[])(names = (spi = (ImageWriterSpi)candidate).getFormatNames())) || !spi.canEncodeImage(image)) continue;
                providers[count++] = spi;
                for (Class<?> legalType : spi.getOutputTypes()) {
                    if (!legalType.isAssignableFrom(outputType)) continue;
                    ImageWriter writer = spi.createWriterInstance();
                    writer.setOutput(output);
                    if (this.filter(writer)) {
                        return writer;
                    }
                    writer.dispose();
                    continue block2;
                }
            }
            if (count != 0 && (stream = ImageIOExt.createImageOutputStream((RenderedImage)image, (Object)output)) != null) {
                Class<?> clazz = stream.getClass();
                block4: for (int i = 0; i < count; ++i) {
                    ImageWriterSpi spi = providers[i];
                    for (Class<?> legalType : spi.getOutputTypes()) {
                        if (!legalType.isAssignableFrom(clazz)) continue;
                        ImageWriter writer = spi.createWriterInstance();
                        writer.setOutput(stream);
                        if (this.filter(writer)) {
                            return writer;
                        }
                        writer.dispose();
                        continue block4;
                    }
                }
            }
        }
        for (String string : formatNames) {
            ArrayList<ImageWriter> writers = new ArrayList<ImageWriter>();
            Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName(string);
            block7: while (it.hasNext()) {
                ImageWriter writer = it.next();
                ImageWriterSpi spi = writer.getOriginatingProvider();
                if (spi == null || !spi.canEncodeImage(image)) {
                    writer.dispose();
                    continue;
                }
                writers.add(writer);
                for (Class<?> legalType : spi.getOutputTypes()) {
                    if (!legalType.isAssignableFrom(outputType)) continue;
                    writer.setOutput(output);
                    if (!this.filter(writer)) continue block7;
                    return writer;
                }
            }
            if (writers.isEmpty()) continue;
            if (stream == null && (stream = ImageIOExt.createImageOutputStream((RenderedImage)image, (Object)output)) == null) break;
            Class<?> streamType = stream.getClass();
            for (ImageWriter writer : writers) {
                ImageWriterSpi spi = writer.getOriginatingProvider();
                for (Class<?> legalType : spi.getOutputTypes()) {
                    if (!legalType.isAssignableFrom(streamType)) continue;
                    writer.setOutput(stream);
                    if (!this.filter(writer)) break;
                    return writer;
                }
                writer.dispose();
            }
        }
        if (stream != null) {
            stream.close();
        }
        throw new IIOException(Errors.format((int)135));
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public void dispose() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        super.dispose();
    }

    public static class Spi
    extends ImageWriterSpi {
        public static final Spi DEFAULT = new Spi();

        public Spi() {
            this.vendorName = "GeoTools";
            this.version = GeoTools.getVersion().toString();
            this.names = MosaicImageReader.Spi.NAMES;
            this.outputTypes = MosaicImageReader.Spi.INPUT_TYPES;
            this.pluginClassName = "org.geotools.image.io.mosaic.MosaicImageWriter";
        }

        public boolean canEncodeImage(ImageTypeSpecifier type) {
            return true;
        }

        public ImageWriter createWriterInstance(Object extension) throws IOException {
            return new MosaicImageWriter(this);
        }

        public String getDescription(Locale locale) {
            return "Mosaic Image Writer";
        }
    }
}

