/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.util.Map;
import java.util.WeakHashMap;
import javax.imageio.IIOParamController;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import org.geotools.image.io.mosaic.ImageTypePolicy;
import org.geotools.image.io.mosaic.MosaicController;
import org.geotools.image.io.mosaic.MosaicImageReader;

public class MosaicImageReadParam
extends ImageReadParam {
    private ImageTypePolicy imageTypePolicy;
    private boolean subsamplingChangeAllowed;
    private boolean nullForEmptyImage;
    final Map<ImageReader, ImageReadParam> readers = new WeakHashMap<ImageReader, ImageReadParam>();
    private Boolean hasController;

    public MosaicImageReadParam() {
        this(null);
        this.hasController = Boolean.FALSE;
    }

    protected MosaicImageReadParam(MosaicImageReader reader) {
        if (reader != null) {
            for (ImageReader tileReader : reader.getTileReaders()) {
                this.readers.put(tileReader, null);
            }
        }
        this.controller = this.defaultController = MosaicController.DEFAULT;
    }

    public boolean isSubsamplingChangeAllowed() {
        return this.subsamplingChangeAllowed;
    }

    public void setSubsamplingChangeAllowed(boolean allowed) {
        this.subsamplingChangeAllowed = allowed;
    }

    public boolean getNullForEmptyImage() {
        return this.nullForEmptyImage;
    }

    public void setNullForEmptyImage(boolean allowed) {
        this.nullForEmptyImage = allowed;
    }

    public ImageTypePolicy getImageTypePolicy() {
        return this.imageTypePolicy;
    }

    public void setImageTypePolicy(ImageTypePolicy policy) {
        this.imageTypePolicy = policy;
    }

    final ImageReadParam getCachedTileParameters(ImageReader reader) {
        ImageReadParam parameters = this.readers.get(reader);
        if (parameters == null) {
            parameters = this.getTileParameters(reader);
            this.readers.put(reader, parameters);
        }
        return parameters;
    }

    protected ImageReadParam getTileParameters(ImageReader reader) {
        ImageReadParam parameters = reader.getDefaultReadParam();
        parameters.setSourceBands(this.sourceBands);
        parameters.setDestinationBands(this.destinationBands);
        parameters.setSourceProgressivePasses(this.minProgressivePass, this.numProgressivePasses);
        return parameters;
    }

    public boolean hasController() {
        if (this.controller != this.defaultController) {
            return super.hasController();
        }
        if (this.hasController == null) {
            this.hasController = Boolean.FALSE;
            for (Map.Entry<ImageReader, ImageReadParam> entry : this.readers.entrySet()) {
                ImageReadParam parameters = entry.getValue();
                if (parameters == null) {
                    parameters = this.getTileParameters(entry.getKey());
                    entry.setValue(parameters);
                }
                if (!parameters.hasController()) continue;
                this.hasController = Boolean.TRUE;
                break;
            }
        }
        return this.hasController;
    }

    public IIOParamController getDefaultController() {
        return super.getDefaultController();
    }
}

