/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.image.io.mosaic.OverviewLevel;
import org.geotools.image.io.mosaic.Tile;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GridTileIterator
implements Iterator<Tile> {
    private OverviewLevel level;
    private int x;
    private int y;
    private Tile tile;

    GridTileIterator(OverviewLevel root) {
        this.level = root;
        this.advance();
    }

    private void advance() {
        while (this.level != null) {
            while (this.y < this.level.getNumYTiles()) {
                while (this.x < this.level.getNumXTiles()) {
                    try {
                        this.tile = this.level.getTile(this.x++, this.y);
                    }
                    catch (MalformedURLException e) {
                        Logging.unexpectedException(GridTileIterator.class, (String)"next", (Throwable)e);
                        continue;
                    }
                    if (this.tile == null) continue;
                    return;
                }
                this.x = 0;
                ++this.y;
            }
            this.y = 0;
            this.level = this.level.getFinerLevel();
        }
        this.tile = null;
    }

    @Override
    public boolean hasNext() {
        return this.level != null;
    }

    @Override
    public Tile next() throws NoSuchElementException {
        Tile tile = this.tile;
        if (tile == null) {
            throw new NoSuchElementException();
        }
        this.advance();
        return tile;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

