/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.geotools.image.io.GeographicImageReader;
import org.geotools.image.io.InputStreamAdapter;
import org.geotools.resources.Classes;
import org.geotools.util.logging.Logging;

public abstract class StreamImageReader
extends GeographicImageReader {
    protected Closeable closeOnReset;
    private InputStream stream;
    private long streamOrigin;

    protected StreamImageReader(ImageReaderSpi provider) {
        super(provider);
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        this.closeSilently();
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (input instanceof ImageInputStream) {
            try {
                this.streamOrigin = ((ImageInputStream)input).getStreamPosition();
            }
            catch (IOException exception) {
                this.streamOrigin = 0L;
                Logging.unexpectedException((Logger)LOGGER, StreamImageReader.class, (String)"setInput", (Throwable)exception);
            }
        }
    }

    protected long getStreamLength() throws IOException {
        Object input = this.getInput();
        if (input instanceof ImageInputStream) {
            long length = ((ImageInputStream)input).length();
            if (length >= 0L) {
                length -= this.streamOrigin;
            }
            return length;
        }
        if (input instanceof File) {
            return ((File)input).length();
        }
        if (input instanceof URL) {
            return ((URL)input).openConnection().getContentLength();
        }
        if (input instanceof URLConnection) {
            return ((URLConnection)input).getContentLength();
        }
        return -1L;
    }

    protected InputStream getInputStream() throws IllegalStateException, IOException {
        if (this.stream == null) {
            Object input = this.getInput();
            if (input == null) {
                throw new IllegalStateException(this.getErrorResources().getString(132));
            }
            if (input instanceof InputStream) {
                this.stream = (InputStream)input;
                this.closeOnReset = null;
            } else if (input instanceof ImageInputStream) {
                this.stream = new InputStreamAdapter((ImageInputStream)input);
                this.closeOnReset = null;
            } else if (input instanceof String) {
                this.stream = new FileInputStream((String)input);
                this.closeOnReset = this.stream;
            } else if (input instanceof File) {
                this.stream = new FileInputStream((File)input);
                this.closeOnReset = this.stream;
            } else if (input instanceof URI) {
                this.stream = ((URI)input).toURL().openStream();
                this.closeOnReset = this.stream;
            } else if (input instanceof URL) {
                this.stream = ((URL)input).openStream();
                this.closeOnReset = this.stream;
            } else if (input instanceof URLConnection) {
                this.stream = ((URLConnection)input).getInputStream();
                this.closeOnReset = this.stream;
            } else {
                throw new IllegalStateException(this.getErrorResources().getString(61, (Object)Classes.getClass((Object)input), InputStream.class));
            }
        }
        return this.stream;
    }

    protected void close() throws IOException {
        if (this.closeOnReset != null) {
            this.closeOnReset.close();
        }
        this.closeOnReset = null;
        this.stream = null;
        super.close();
    }

    private void closeSilently() {
        try {
            this.close();
        }
        catch (IOException exception) {
            Logging.unexpectedException((Logger)LOGGER, this.getClass(), (String)"close", (Throwable)exception);
        }
    }

    public void reset() {
        this.closeSilently();
        super.reset();
    }

    public void dispose() {
        this.closeSilently();
        super.dispose();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public static abstract class Spi
    extends ImageReaderSpi {
        private static final Class[] INPUT_TYPES = new Class[]{File.class, URI.class, URL.class, URLConnection.class, InputStream.class, ImageInputStream.class, String.class};

        public Spi() {
            this.inputTypes = INPUT_TYPES;
        }
    }
}

