/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.image.io.GeographicImageReadParam;
import org.geotools.image.io.Palette;
import org.geotools.image.io.PaletteFactory;
import org.geotools.image.io.SampleConverter;
import org.geotools.image.io.metadata.Band;
import org.geotools.image.io.metadata.GeographicMetadata;
import org.geotools.resources.IndexedResourceBundle;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Locales;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeographicImageReader
extends ImageReader {
    static final Logger LOGGER = Logging.getLogger((String)"org.geotools.image.io");
    private transient GeographicMetadata[] metadata;

    protected GeographicImageReader(ImageReaderSpi provider) {
        super(provider);
        this.availableLocales = Locales.getAvailableLocales();
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        this.metadata = null;
        super.setInput(input, seekForwardOnly, ignoreMetadata);
    }

    final IndexedResourceBundle getErrorResources() {
        return Errors.getResources((Locale)this.getLocale());
    }

    protected void checkImageIndex(int imageIndex) throws IOException, IndexOutOfBoundsException {
        int numImages = this.getNumImages(false);
        if (imageIndex < this.minIndex || imageIndex >= numImages && numImages >= 0) {
            throw new IndexOutOfBoundsException(this.indexOutOfBounds(imageIndex, this.minIndex, numImages));
        }
    }

    protected void checkBandIndex(int imageIndex, int bandIndex) throws IOException, IndexOutOfBoundsException {
        int numBands = this.getNumBands(imageIndex);
        if (bandIndex >= numBands || bandIndex < 0) {
            throw new IndexOutOfBoundsException(this.indexOutOfBounds(bandIndex, 0, numBands));
        }
    }

    private String indexOutOfBounds(int index, int lower, int upper) {
        return this.getErrorResources().getString(201, (Object)index, (Object)lower, (Object)(upper - 1));
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IllegalStateException, IOException {
        if (this.input != null) {
            return 1;
        }
        throw new IllegalStateException(this.getErrorResources().getString(132));
    }

    public int getNumBands(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return 1;
    }

    public int getDimension(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return 2;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeographicMetadata getGeographicMetadata(int imageIndex) throws IOException {
        GeographicMetadata parser;
        IIOMetadata candidate;
        GeographicMetadata parser2;
        if (this.metadata != null && imageIndex >= 0 && imageIndex < this.metadata.length && (parser2 = this.metadata[imageIndex]) != null) {
            return parser2;
        }
        boolean oldIgnore = this.ignoreMetadata;
        try {
            this.ignoreMetadata = false;
            candidate = this.getImageMetadata(imageIndex);
        }
        finally {
            this.ignoreMetadata = oldIgnore;
        }
        if (candidate == null) {
            return null;
        }
        if (candidate instanceof GeographicMetadata) {
            parser = (GeographicMetadata)candidate;
        } else {
            parser = new GeographicMetadata(this);
            parser.mergeTree(candidate);
        }
        if (this.metadata == null) {
            this.metadata = new GeographicMetadata[Math.max(imageIndex + 1, 4)];
        }
        if (imageIndex >= this.metadata.length) {
            this.metadata = (GeographicMetadata[])XArray.resize((Object[])this.metadata, (int)Math.max(imageIndex + 1, this.metadata.length * 2));
        }
        this.metadata[imageIndex] = parser;
        return parser;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        return Collections.singleton(this.getRawImageType(imageIndex)).iterator();
    }

    @Override
    public ImageTypeSpecifier getRawImageType(int imageIndex) throws IOException {
        return this.getRawImageType(imageIndex, this.getDefaultReadParam(), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected ImageTypeSpecifier getRawImageType(int imageIndex, ImageReadParam parameters, SampleConverter[] converters) throws IOException {
        long upper;
        long lower;
        Palette palette;
        int visibleBand;
        String paletteName;
        int[] targetBands;
        int[] sourceBands;
        long ceil;
        long floor;
        boolean isFloat;
        int dataType = this.getRawDataType(imageIndex);
        switch (dataType) {
            case 4: 
            case 5: 
            case 32: {
                isFloat = true;
                floor = Long.MIN_VALUE;
                ceil = Long.MAX_VALUE;
                break;
            }
            case 3: {
                isFloat = false;
                floor = Integer.MIN_VALUE;
                ceil = Integer.MAX_VALUE;
                break;
            }
            case 2: {
                isFloat = false;
                floor = -32768L;
                ceil = 32767L;
                break;
            }
            default: {
                isFloat = false;
                floor = 0L;
                ceil = (1L << DataBuffer.getDataTypeSize(dataType)) - 1L;
            }
        }
        if (parameters != null) {
            sourceBands = parameters.getSourceBands();
            targetBands = parameters.getDestinationBands();
        } else {
            sourceBands = null;
            targetBands = null;
        }
        if (parameters instanceof GeographicImageReadParam) {
            GeographicImageReadParam geoparam = (GeographicImageReadParam)parameters;
            paletteName = geoparam.getNonNullPaletteName();
            visibleBand = geoparam.getVisibleBand();
        } else {
            paletteName = "rainbow";
            visibleBand = 0;
        }
        int numBands = sourceBands != null ? sourceBands.length : (targetBands != null ? targetBands.length : this.getNumBands(imageIndex));
        NumberRange allRanges = null;
        NumberRange visibleRange = null;
        SampleConverter visibleConverter = SampleConverter.IDENTITY;
        double maximumFillValue = 0.0;
        GeographicMetadata metadata = this.getGeographicMetadata(imageIndex);
        if (metadata != null) {
            int numMetadataBands = metadata.getNumBands();
            for (int i = 0; i < numBands; ++i) {
                SampleConverter converter;
                int targetBand;
                double maximum;
                double minimum;
                NumberRange range;
                double[] nodataValues;
                block40: {
                    int sourceBand;
                    int n = sourceBand = sourceBands != null ? sourceBands[i] : i;
                    if (sourceBand < 0 || sourceBand >= numMetadataBands) {
                        if (numMetadataBands != 1) {
                            this.warningOccurred("getRawImageType", this.indexOutOfBounds(sourceBand, 0, numMetadataBands));
                        }
                        if (numMetadataBands == 0) break;
                    }
                    Band band = metadata.getBand(Math.min(sourceBand, numMetadataBands - 1));
                    nodataValues = band.getNoDataValues();
                    range = band.getValidRange();
                    if (range != null) {
                        double extent;
                        minimum = range.getMinimum();
                        maximum = range.getMaximum();
                        if (!isFloat) {
                            if (minimum == Double.NEGATIVE_INFINITY) {
                                minimum = floor;
                            }
                            if (maximum == Double.POSITIVE_INFINITY) {
                                maximum = ceil;
                            }
                        }
                        if ((extent = maximum - minimum) >= 0.0 && (isFloat || extent <= (double)(ceil - floor))) {
                            allRanges = allRanges != null ? allRanges.union((Range)range) : range;
                            break block40;
                        } else {
                            this.warningOccurred("getRawImageType", Errors.format((int)14, (Object)range.getMinValue(), (Object)range.getMaxValue()));
                            continue;
                        }
                    }
                    minimum = Double.NaN;
                    maximum = Double.NaN;
                }
                int n = targetBand = targetBands != null ? targetBands[i] : i;
                if (isFloat) {
                    converter = SampleConverter.createPadValuesMask(nodataValues);
                } else {
                    boolean isZeroValid = minimum <= 0.0 && maximum >= 0.0;
                    boolean collapsePadValues = false;
                    if (nodataValues != null && nodataValues.length != 0) {
                        double minFill;
                        double[] sorted = (double[])nodataValues.clone();
                        Arrays.sort(sorted);
                        double maxFill = minFill = sorted[0];
                        int indexMax = sorted.length;
                        while (--indexMax != 0 && Double.isNaN(maxFill = sorted[indexMax])) {
                        }
                        assert (minFill <= maxFill || Double.isNaN(minFill)) : maxFill;
                        if (targetBand == visibleBand && maxFill > maximumFillValue) {
                            maximumFillValue = maxFill;
                        }
                        if (minFill < (double)floor || maxFill > (double)ceil) {
                            collapsePadValues = true;
                        } else if (minimum >= 0.0) {
                            int k = Arrays.binarySearch(sorted, maximum);
                            k = k >= 0 ? ++k : (k ^= 0xFFFFFFFF);
                            if (k <= indexMax) {
                                double unusedSpace = Math.max(sorted[k] - maximum - 1.0, 0.0);
                                while (++k <= indexMax) {
                                    double delta = sorted[k] - sorted[k - 1] - 1.0;
                                    if (!(delta > 0.0)) continue;
                                    unusedSpace += delta;
                                }
                                int unused = (int)Math.min(Math.round(unusedSpace), Integer.MAX_VALUE);
                                collapsePadValues = this.collapseNoDataValues(isZeroValid, sorted, unused);
                            }
                        }
                    }
                    converter = minimum < (double)floor || maximum > (double)ceil ? SampleConverter.createOffset(1.0 - minimum, nodataValues) : (collapsePadValues ? (isZeroValid ? SampleConverter.createOffset(1.0 - minimum, nodataValues) : SampleConverter.createPadValuesMask(nodataValues)) : SampleConverter.IDENTITY);
                }
                if (converters != null && targetBand >= 0 && targetBand < converters.length) {
                    converters[targetBand] = converter;
                }
                if (targetBand != visibleBand) continue;
                visibleConverter = converter;
                visibleRange = range;
            }
        }
        if (visibleRange == null) {
            visibleRange = allRanges != null ? allRanges : new NumberRange(floor, ceil);
        }
        PaletteFactory factory = PaletteFactory.getDefault();
        factory.setWarningLocale(this.locale);
        if (isFloat) {
            assert (visibleConverter.getOffset() == 0.0) : visibleConverter;
            palette = factory.getContinuousPalette(paletteName, (float)visibleRange.getMinimum(), (float)visibleRange.getMaximum(), dataType, numBands, visibleBand);
            return palette.getImageTypeSpecifier();
        }
        double offset = visibleConverter.getOffset();
        double minimum = visibleRange.getMinimum();
        double maximum = visibleRange.getMaximum();
        if (minimum == Double.NEGATIVE_INFINITY) {
            lower = floor;
        } else {
            lower = Math.round(minimum + offset);
            if (!visibleRange.isMinIncluded()) {
                ++lower;
            }
        }
        if (maximum == Double.POSITIVE_INFINITY) {
            upper = ceil;
        } else {
            upper = Math.round(maximum + offset);
            if (visibleRange.isMaxIncluded()) {
                ++upper;
            }
        }
        long size = Math.max(upper, Math.round(maximumFillValue) + 1L);
        palette = factory.getPalette(paletteName, (int)Math.max(lower, Integer.MIN_VALUE), (int)Math.min(upper, Integer.MAX_VALUE), (int)Math.min(size, Integer.MAX_VALUE), numBands, visibleBand);
        return palette.getImageTypeSpecifier();
    }

    protected int getRawDataType(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return 4;
    }

    protected boolean collapseNoDataValues(boolean isZeroValid, double[] nodataValues, int unusedSpace) {
        return false;
    }

    protected BufferedImage getDestination(int imageIndex, ImageReadParam parameters, int width, int height, SampleConverter[] converters) throws IOException {
        ImageTypeSpecifier type = this.getRawImageType(imageIndex, parameters, converters);
        Set<ImageTypeSpecifier> spi = Collections.singleton(type);
        return GeographicImageReader.getDestination(parameters, spi.iterator(), width, height);
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new GeographicImageReadParam(this);
    }

    @Override
    public BufferedImage read(int imageIndex) throws IOException {
        return this.read(imageIndex, this.getDefaultReadParam());
    }

    protected static void flipVertically(ImageReadParam param, int srcHeight, Rectangle srcRegion) {
        int spaceLeft = srcRegion.y;
        srcRegion.y = srcHeight - (srcRegion.y + srcRegion.height);
        if (param != null) {
            int offset = (srcRegion.height - 1) % param.getSourceYSubsampling();
            srcRegion.y += offset;
            if ((offset -= spaceLeft) > 0) {
                srcRegion.height -= offset;
            }
        }
    }

    public void warningOccurred(LogRecord record) {
        if (this.warningListeners == null) {
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
        } else {
            this.processWarningOccurred(IndexedResourceBundle.format((LogRecord)record));
        }
    }

    private void warningOccurred(String method, String message) {
        LogRecord record = new LogRecord(Level.WARNING, message);
        record.setSourceClassName(GeographicImageReader.class.getName());
        record.setSourceMethodName(method);
        this.warningOccurred(record);
    }

    void close() throws IOException {
        this.metadata = null;
    }
}

