/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.util.Locale;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import org.geotools.resources.Classes;
import org.geotools.resources.IndexedResourceBundle;
import org.geotools.resources.i18n.Errors;

public class GeographicImageReadParam
extends ImageReadParam {
    public static final String DEFAULT_PALETTE_NAME = "rainbow";
    private String palette;
    private int visibleBand;
    private final Locale locale;

    public GeographicImageReadParam(ImageReader reader) {
        this.locale = reader != null ? reader.getLocale() : null;
    }

    private IndexedResourceBundle getErrorResources() {
        return Errors.getResources((Locale)this.locale);
    }

    private void ensureValidBand(int band) throws IllegalArgumentException {
        if (band < 0) {
            throw new IllegalArgumentException(this.getErrorResources().getString(7, (Object)band));
        }
    }

    public int getVisibleBand() {
        return this.visibleBand;
    }

    public void setVisibleBand(int visibleBand) throws IllegalArgumentException {
        this.ensureValidBand(visibleBand);
        this.visibleBand = visibleBand;
    }

    final String getNonNullPaletteName() {
        String palette = this.getPaletteName();
        return palette != null ? palette : DEFAULT_PALETTE_NAME;
    }

    public String getPaletteName() {
        return this.palette;
    }

    public void setPaletteName(String palette) {
        this.palette = palette;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName((Object)this));
        buffer.append('[');
        if (this.sourceRegion != null) {
            buffer.append("sourceRegion=(").append(this.sourceRegion.x).append(':').append(this.sourceRegion.x + this.sourceRegion.width).append(',').append(this.sourceRegion.y).append(':').append(this.sourceRegion.y + this.sourceRegion.height).append("), ");
        }
        if (this.sourceXSubsampling != 1 || this.sourceYSubsampling != 1) {
            buffer.append("subsampling=(").append(this.sourceXSubsampling).append(',').append(this.sourceYSubsampling).append("), ");
        }
        if (this.sourceBands != null) {
            buffer.append("sourceBands={");
            for (int i = 0; i < this.sourceBands.length; ++i) {
                if (i != 0) {
                    buffer.append(',');
                }
                buffer.append(this.sourceBands[i]);
            }
            buffer.append("}, ");
        }
        buffer.append("palette=\"").append(this.palette).append("\", ").append(']');
        return buffer.toString();
    }
}

