/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeExtent;
import com.esri.sde.sdk.client.SeFilter;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeQueryInfo;
import com.esri.sde.sdk.client.SeSqlConstruct;
import com.esri.sde.sdk.client.SeStreamOp;
import com.esri.sde.sdk.client.SeTable;
import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.data.FIDReader;
import org.geotools.arcsde.data.FeatureTypeInfo;
import org.geotools.arcsde.filter.FilterToSQLSDE;
import org.geotools.arcsde.filter.GeometryEncoderException;
import org.geotools.arcsde.filter.GeometryEncoderSDE;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.session.SdeRow;
import org.geotools.arcsde.versioning.ArcSdeVersionHandler;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

class ArcSDEQuery {
    private static final Logger LOGGER = Logging.getLogger((String)ArcSDEQuery.class.getName());
    final ISession session;
    private final SimpleFeatureType schema;
    private SeQuery query;
    private FilterSet filters;
    private final FIDReader fidReader;
    private Object[] previousRowValues;
    private final ArcSdeVersionHandler versioningHandler;
    private final String sortByClause;
    private SdeRow currentRow;

    private ArcSDEQuery(ISession session, SimpleFeatureType schema, FilterSet filterSet, String sortByClause, FIDReader fidReader, ArcSdeVersionHandler versioningHandler) throws DataSourceException {
        this.session = session;
        this.schema = schema;
        this.filters = filterSet;
        this.fidReader = fidReader;
        this.versioningHandler = versioningHandler;
        this.sortByClause = sortByClause;
    }

    public static ArcSDEQuery createQuery(ISession session, SimpleFeatureType fullSchema, Query query, FIDReader fidReader, ArcSdeVersionHandler versioningHandler) throws IOException {
        Filter filter = query.getFilter();
        LOGGER.fine("Creating new ArcSDEQuery");
        String typeName = fullSchema.getTypeName();
        SeTable sdeTable = session.getTable(typeName);
        SeLayer sdeLayer = fullSchema.getGeometryDescriptor() == null ? null : session.getLayer(typeName);
        FilterSet filters = new FilterSet(sdeTable, sdeLayer, filter, fullSchema, null, null, fidReader, session);
        Filter unsupportedFilter = filters.getUnsupportedFilter();
        String[] queryProperties = query.getPropertyNames();
        SimpleFeatureType querySchema = ArcSDEQuery.getQuerySchema(queryProperties, unsupportedFilter, fullSchema);
        String sortByClause = ArcSDEQuery.buildSortByClause(fullSchema, query.getSortBy(), fidReader);
        ArcSDEQuery sdeQuery = new ArcSDEQuery(session, querySchema, filters, sortByClause, fidReader, versioningHandler);
        return sdeQuery;
    }

    public static ArcSDEQuery createInprocessViewQuery(ISession session, SimpleFeatureType fullSchema, Query query, SeQueryInfo definitionQuery, PlainSelect viewSelectStatement) throws IOException {
        SeSqlConstruct construct;
        Filter filter = query.getFilter();
        FIDReader fidReader = FIDReader.NULL_READER;
        try {
            construct = definitionQuery.getConstruct();
        }
        catch (SeException e) {
            throw new ArcSdeException("shouldn't happen: " + e.getMessage(), e);
        }
        String[] tables = construct.getTables();
        String layerName = tables[0];
        if (layerName.indexOf(" AS") > 0) {
            layerName = layerName.substring(0, layerName.indexOf(" AS"));
        }
        SeTable sdeTable = session.getTable(layerName);
        SeLayer sdeLayer = fullSchema.getGeometryDescriptor() == null ? null : session.getLayer(layerName);
        FilterSet filters = new FilterSet(sdeTable, sdeLayer, filter, fullSchema, definitionQuery, viewSelectStatement, fidReader, session);
        Filter unsupportedFilter = filters.getUnsupportedFilter();
        String[] queryProperties = query.getPropertyNames();
        SimpleFeatureType querySchema = ArcSDEQuery.getQuerySchema(queryProperties, unsupportedFilter, fullSchema);
        ArcSDEQuery sdeQuery = new ArcSDEQuery(session, querySchema, filters, null, fidReader, ArcSdeVersionHandler.NONVERSIONED_HANDLER);
        return sdeQuery;
    }

    public static SimpleFeatureType getQuerySchema(String[] queryProperties, Filter unsupportedFilter, SimpleFeatureType fullSchema) throws DataSourceException {
        List<String> queryColumns = ArcSDEQuery.getQueryColumns(queryProperties, unsupportedFilter, fullSchema);
        String[] attNames = queryColumns.toArray(new String[queryColumns.size()]);
        try {
            SimpleFeatureType querySchema = DataUtilities.createSubType((SimpleFeatureType)fullSchema, (String[])attNames);
            return querySchema;
        }
        catch (SchemaException ex) {
            throw new DataSourceException("Some requested attributes do not match the table schema: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private static List<String> getQueryColumns(String[] queryProperties, Filter unsupportedFilter, SimpleFeatureType fullSchema) throws DataSourceException {
        ArrayList<String> columnNames;
        block4: {
            String[] filterAtts;
            block3: {
                columnNames = new ArrayList<String>();
                if (queryProperties != null && queryProperties.length != 0) break block3;
                List attNames = fullSchema.getAttributeDescriptors();
                for (AttributeDescriptor att : attNames) {
                    String attName = att.getLocalName();
                    if (attName.indexOf(":") != -1) {
                        attName = attName.substring(attName.indexOf(":") + 1);
                    }
                    columnNames.add(attName);
                }
                break block4;
            }
            columnNames.addAll(Arrays.asList(queryProperties));
            if (unsupportedFilter == null) break block4;
            FilterAttributeExtractor attExtractor = new FilterAttributeExtractor(fullSchema);
            unsupportedFilter.accept((FilterVisitor)attExtractor, null);
            for (String attName : filterAtts = attExtractor.getAttributeNames()) {
                if (columnNames.contains(attName)) continue;
                columnNames.add(attName);
            }
        }
        return columnNames;
    }

    public FIDReader getFidReader() {
        return this.fidReader;
    }

    private SeQuery getSeQuery() throws IOException {
        if (this.query == null) {
            try {
                String[] propsToQuery = this.fidReader.getPropertiesToFetch(this.schema);
                this.query = this.createSeQueryForFetch(propsToQuery);
            }
            catch (SeException e) {
                throw new ArcSdeException(e);
            }
        }
        return this.query;
    }

    private SeQuery createSeQueryForFetch(String[] propertyNames) throws SeException, IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("constructing new sql query with connection: " + this.session + ", propnames: " + Arrays.asList(propertyNames) + " sqlConstruct where clause: '" + this.filters.getSeSqlConstruct().getWhere() + "'");
        }
        SeQueryInfo qInfo = this.filters.getQueryInfo(propertyNames);
        if (this.sortByClause != null) {
            qInfo.setByClause(this.sortByClause);
        }
        SeFilter[] spatialConstraints = this.filters.getSpatialFilters();
        if (LOGGER.isLoggable(Level.FINER)) {
            String msg = "ArcSDE query is: " + this.toString(qInfo);
            LOGGER.finer(msg);
        }
        SeQuery seQuery = this.session.prepareQuery(qInfo, spatialConstraints, this.versioningHandler);
        return seQuery;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String buildSortByClause(SimpleFeatureType fullSchema, SortBy[] sortByAttributes, FIDReader fidReader) {
        if (sortByAttributes == null || sortByAttributes.length == 0) {
            return null;
        }
        StringBuilder byClause = new StringBuilder("ORDER BY ");
        for (int i = 0; i < sortByAttributes.length; ++i) {
            SortBy sortAtt = sortByAttributes[i];
            if (sortAtt == SortBy.NATURAL_ORDER || sortAtt == SortBy.REVERSE_ORDER) {
                if (!(fidReader instanceof FIDReader.SdeManagedFidReader) && !(fidReader instanceof FIDReader.UserManagedFidReader)) throw new IllegalArgumentException(sortAtt + " sorting is not supported for featureclasses" + " with no primary key");
                byClause.append(fidReader.getFidColumn()).append(" ");
                byClause.append(sortAtt == SortBy.NATURAL_ORDER ? "ASC" : "DESC");
            } else {
                PropertyName propertyName = sortAtt.getPropertyName();
                String attName = propertyName.getPropertyName();
                AttributeDescriptor descriptor = fullSchema.getDescriptor(attName);
                if (descriptor == null) {
                    throw new IllegalArgumentException(attName + " does not exist. Can't sort by it");
                }
                if (descriptor instanceof GeometryDescriptor) {
                    throw new IllegalArgumentException(attName + " is a geometry attribute. Can't sort by it");
                }
                byClause.append(attName).append(" ");
                byClause.append(sortAtt.getSortOrder() == SortOrder.ASCENDING ? "ASC" : "DESC");
            }
            if (i >= sortByAttributes.length - 1) continue;
            byClause.append(", ");
        }
        return byClause.toString();
    }

    private String toString(SeQueryInfo qInfo) {
        StringBuffer sb = new StringBuffer("SeQueryInfo[\n\tcolumns=");
        try {
            int i;
            SeSqlConstruct sql = qInfo.getConstruct();
            String[] tables = sql.getTables();
            String[] cols = qInfo.getColumns();
            String by = null;
            try {
                by = qInfo.getByClause();
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            String where = sql.getWhere();
            for (i = 0; cols != null && i < cols.length; ++i) {
                sb.append(cols[i]);
                if (i >= cols.length - 1) continue;
                sb.append(", ");
            }
            sb.append("\n\tTables=");
            for (i = 0; i < tables.length; ++i) {
                sb.append(tables[i]);
                if (i >= tables.length - 1) continue;
                sb.append(", ");
            }
            sb.append("\n\tWhere=");
            sb.append(where);
            sb.append("\n\tOrderBy=");
            sb.append(by);
        }
        catch (SeException e) {
            sb.append("Exception retrieving query info properties: " + e.getMessage());
        }
        sb.append("]");
        return sb.toString();
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public FilterSet getFilters() {
        return this.filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int calculateResultCount(ISession session, FeatureTypeInfo typeInfo, Query query, ArcSdeVersionHandler versioningHandler) throws IOException {
        int count;
        ArcSDEQuery countQuery = null;
        try {
            SimpleFeatureType fullSchema = typeInfo.getFeatureType();
            if (typeInfo.isInProcessView()) {
                SeQueryInfo definitionQuery = typeInfo.getSdeDefinitionQuery();
                PlainSelect viewSelectStatement = typeInfo.getDefinitionQuery();
                countQuery = ArcSDEQuery.createInprocessViewQuery(session, fullSchema, query, definitionQuery, viewSelectStatement);
            } else {
                FIDReader fidStrategy = typeInfo.getFidStrategy();
                countQuery = ArcSDEQuery.createQuery(session, fullSchema, query, fidStrategy, versioningHandler);
            }
            count = countQuery.calculateResultCount();
        }
        finally {
            if (countQuery != null) {
                countQuery.close();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Envelope calculateQueryExtent(ISession session, FeatureTypeInfo typeInfo, Query query, ArcSdeVersionHandler versioningHandler) throws IOException {
        ArcSDEQuery boundsQuery;
        SimpleFeatureType fullSchema = typeInfo.getFeatureType();
        GeometryDescriptor geometryDescriptor = fullSchema.getGeometryDescriptor();
        if (geometryDescriptor == null) {
            return null;
        }
        String defaultGeomAttName = geometryDescriptor.getLocalName();
        Query realQuery = new Query(query);
        realQuery.setPropertyNames(new String[]{defaultGeomAttName});
        if (typeInfo.isInProcessView()) {
            SeQueryInfo definitionQuery = typeInfo.getSdeDefinitionQuery();
            PlainSelect viewSelectStatement = typeInfo.getDefinitionQuery();
            boundsQuery = ArcSDEQuery.createInprocessViewQuery(session, fullSchema, realQuery, definitionQuery, viewSelectStatement);
        } else {
            FIDReader fidStrategy = typeInfo.getFidStrategy();
            boundsQuery = ArcSDEQuery.createQuery(session, fullSchema, realQuery, fidStrategy, versioningHandler);
        }
        Envelope queryExtent = null;
        try {
            Filter unsupportedFilter = boundsQuery.getFilters().getUnsupportedFilter();
            if (unsupportedFilter == Filter.INCLUDE) {
                queryExtent = boundsQuery.calculateQueryExtent();
            }
        }
        finally {
            boundsQuery.close();
        }
        return queryExtent;
    }

    public int calculateResultCount() throws IOException {
        SimpleFeatureType schema = this.schema;
        GeometryDescriptor geometryDescriptor = schema.getGeometryDescriptor();
        String colName = geometryDescriptor == null ? schema.getDescriptor(0).getLocalName() : geometryDescriptor.getLocalName();
        final SeQueryInfo qInfo = this.filters.getQueryInfo(new String[]{colName});
        final SeFilter[] spatialFilters = this.filters.getSpatialFilters();
        Command<Integer> countCmd = new Command<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer execute(ISession session, SeConnection connection) throws SeException, IOException {
                SeQuery query = new SeQuery(connection);
                try {
                    ArcSDEQuery.this.versioningHandler.setUpStream(session, (SeStreamOp)query);
                    if (spatialFilters != null && spatialFilters.length > 0) {
                        query.setSpatialConstraints(SeQuery.SE_OPTIMIZE, true, spatialFilters);
                    }
                    SeTable.SeTableStats tableStats = query.calculateTableStatistics("*", SeTable.SeTableStats.SE_COUNT_STATS, qInfo, 0);
                    int actualCount = tableStats.getCount();
                    Integer n = new Integer(actualCount);
                    return n;
                }
                finally {
                    query.close();
                }
            }
        };
        Integer count = (Integer)this.session.issue((Command)countCmd);
        return count;
    }

    public Envelope calculateQueryExtent() throws IOException {
        SeExtent extent;
        LOGGER.fine("Building a new SeQuery to consult it's resulting envelope");
        try {
            extent = (SeExtent)this.session.issue((Command)new Command<SeExtent>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public SeExtent execute(ISession session, SeConnection connection) throws SeException, IOException {
                    SeExtent extent;
                    String[] spatialCol = new String[]{ArcSDEQuery.this.schema.getGeometryDescriptor().getLocalName()};
                    SeSqlConstruct fullConstruct = ArcSDEQuery.this.filters.getQueryInfo(spatialCol).getConstruct();
                    String whereClause = fullConstruct.getWhere();
                    if (whereClause == null) {
                        whereClause = "1 = 1";
                    }
                    SeFilter[] spatialConstraints = ArcSDEQuery.this.filters.getSpatialFilters();
                    SeQuery extentQuery = new SeQuery(connection);
                    try {
                        ArcSDEQuery.this.versioningHandler.setUpStream(session, (SeStreamOp)extentQuery);
                        if (spatialConstraints.length > 0) {
                            extentQuery.setSpatialConstraints(SeQuery.SE_OPTIMIZE, false, spatialConstraints);
                        }
                        SeSqlConstruct sqlCons = new SeSqlConstruct();
                        sqlCons.setTables(fullConstruct.getTables());
                        sqlCons.setWhere(whereClause);
                        SeQueryInfo seQueryInfo = new SeQueryInfo();
                        seQueryInfo.setColumns(spatialCol);
                        seQueryInfo.setConstruct(sqlCons);
                        extent = extentQuery.calculateLayerExtent(seQueryInfo);
                    }
                    finally {
                        extentQuery.close();
                    }
                    return extent;
                }
            });
        }
        catch (IOException ex) {
            SeException sdeEx;
            String tables;
            SeSqlConstruct sqlCons = this.filters.getSeSqlConstruct();
            String sql = sqlCons == null ? null : sqlCons.getWhere();
            String string = tables = sqlCons == null ? null : Arrays.asList(sqlCons.getTables()).toString();
            if (ex.getCause() instanceof SeException && (sdeEx = (SeException)ex.getCause()).getSeError().getSdeError() == -288) {
                LOGGER.severe("ArcSDE is complaining that your 'LOGFILE SYSTEM TABLES DO NOT EXIST'.  This is an ignorable error.");
            }
            LOGGER.log(Level.SEVERE, "***********************\ntables: " + tables + "\nfilter: " + this.filters.getGeometryFilter() + "\nSQL: " + sql, ex);
            throw ex;
        }
        Envelope envelope = new Envelope(extent.getMinX(), extent.getMaxX(), extent.getMinY(), extent.getMaxY());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("got extent: " + extent + ", built envelope: " + envelope);
        }
        return envelope;
    }

    private static void close(SeQuery query, ISession session) throws IOException {
        if (query == null) {
            return;
        }
        session.close((SeStreamOp)query);
    }

    public void close() throws IOException {
        ArcSDEQuery.close(this.query, this.session);
        this.query = null;
    }

    public void execute() throws IOException {
        final SeQuery seQuery = this.getSeQuery();
        this.session.issue((Command)new Command<Void>(){

            public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                seQuery.execute();
                return null;
            }
        });
    }

    public SdeRow fetch() throws IOException, IllegalStateException {
        if (this.query == null) {
            throw new IllegalStateException("query closed or not yet executed");
        }
        SeQuery seQuery = this.getSeQuery();
        try {
            this.currentRow = this.session.fetch(seQuery);
        }
        catch (IOException e) {
            this.close();
            String msg = "Error fetching row for " + this.schema.getTypeName() + "[";
            msg = msg + "\nFilter: " + this.filters.sourceFilter;
            msg = msg + "\n where clause sent: " + this.filters.sdeSqlConstruct.getWhere();
            msg = msg + "\ngeometry filter:" + this.filters.geometryFilter;
            LOGGER.log(Level.WARNING, msg, e);
            throw e;
        }
        catch (Exception e) {
            this.close();
            LOGGER.log(Level.SEVERE, "fetching row: " + e.getMessage(), e);
            throw new DataSourceException("fetching row: " + e.getMessage(), (Throwable)e);
        }
        if (this.currentRow != null) {
            this.currentRow.setPreviousValues(this.previousRowValues);
            this.previousRowValues = this.currentRow.getAll();
        }
        return this.currentRow;
    }

    public void setSpatialConstraints(SeFilter[] filters) throws IOException {
        try {
            this.getSeQuery().setSpatialConstraints(SeQuery.SE_OPTIMIZE, false, filters);
        }
        catch (SeException e) {
            throw new ArcSdeException(e);
        }
    }

    public String toString() {
        return "Schema: " + this.schema.getTypeName() + ", query: " + this.query;
    }

    public static class FilterSet {
        private SeQueryInfo definitionQuery;
        private PlainSelect layerSelectStatement;
        private FIDReader fidReader;
        private final SeLayer sdeLayer;
        private final SeTable sdeTable;
        private final Filter sourceFilter;
        private Filter _sqlFilter;
        private Filter geometryFilter;
        private Filter unsupportedFilter;
        private FilterToSQLSDE _sqlEncoder;
        private SeFilter[] sdeSpatialFilters;
        private SeSqlConstruct sdeSqlConstruct;
        private SimpleFeatureType featureType;
        private final ISession conn;

        public FilterSet(SeTable table, SeLayer sdeLayer, Filter sourceFilter, SimpleFeatureType ft, SeQueryInfo definitionQuery, PlainSelect layerSelectStatement, FIDReader fidReader, ISession session) {
            this.conn = session;
            assert (table != null);
            assert (sourceFilter != null);
            assert (ft != null);
            this.sdeTable = table;
            this.sdeLayer = sdeLayer;
            this.sourceFilter = sourceFilter;
            this.featureType = ft;
            this.definitionQuery = definitionQuery;
            this.layerSelectStatement = layerSelectStatement;
            this.fidReader = fidReader;
            this.createGeotoolsFilters();
        }

        private void createGeotoolsFilters() {
            FilterToSQLSDE sqlEncoder = this.getSqlEncoder();
            PostPreProcessFilterSplittingVisitor unpacker = new PostPreProcessFilterSplittingVisitor(sqlEncoder.getCapabilities(), this.featureType, null);
            this.sourceFilter.accept((FilterVisitor)unpacker, null);
            SimplifyingFilterVisitor filterSimplifier = new SimplifyingFilterVisitor();
            String typeName = this.featureType.getTypeName();
            SimplifyingFilterVisitor.TypeNameDotNumberFidValidator validator = new SimplifyingFilterVisitor.TypeNameDotNumberFidValidator(typeName);
            filterSimplifier.setFIDValidator((SimplifyingFilterVisitor.FIDValidator)validator);
            this._sqlFilter = unpacker.getFilterPre();
            this._sqlFilter = (Filter)this._sqlFilter.accept((FilterVisitor)filterSimplifier, null);
            if (LOGGER.isLoggable(Level.FINE) && this._sqlFilter != null) {
                LOGGER.fine("SQL portion of SDE Query: '" + this._sqlFilter + "'");
            }
            Filter remainingFilter = unpacker.getFilterPost();
            unpacker = new PostPreProcessFilterSplittingVisitor(GeometryEncoderSDE.getCapabilities(), this.featureType, null);
            remainingFilter.accept((FilterVisitor)unpacker, null);
            this.geometryFilter = unpacker.getFilterPre();
            this.geometryFilter = (Filter)this.geometryFilter.accept((FilterVisitor)filterSimplifier, null);
            if (LOGGER.isLoggable(Level.FINE) && this.geometryFilter != null) {
                LOGGER.fine("Spatial-Filter portion of SDE Query: '" + this.geometryFilter + "'");
            }
            this.unsupportedFilter = unpacker.getFilterPost();
            this.unsupportedFilter = (Filter)this.unsupportedFilter.accept((FilterVisitor)filterSimplifier, null);
            if (LOGGER.isLoggable(Level.FINE) && this.unsupportedFilter != null) {
                LOGGER.fine("Unsupported (and therefore ignored) portion of SDE Query: '" + this.unsupportedFilter + "'");
            }
        }

        public SeQueryInfo getQueryInfo(String[] unqualifiedPropertyNames) throws IOException {
            assert (unqualifiedPropertyNames != null);
            String byClause = null;
            SeSqlConstruct plainSqlConstruct = this.getSeSqlConstruct();
            String where = plainSqlConstruct.getWhere();
            try {
                int queriedAttCount;
                String[] tables;
                if (this.definitionQuery == null) {
                    tables = new String[]{this.sdeTable.getQualifiedName()};
                } else {
                    tables = this.definitionQuery.getConstruct().getTables();
                    String joinWhere = this.definitionQuery.getConstruct().getWhere();
                    where = where == null ? joinWhere : (joinWhere == null ? where : joinWhere + " AND " + where);
                    try {
                        byClause = this.definitionQuery.getByClause();
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
                SeQueryInfo qInfo = new SeQueryInfo();
                SeSqlConstruct sqlConstruct = new SeSqlConstruct();
                sqlConstruct.setTables(tables);
                if (where != null && where.length() > 0) {
                    sqlConstruct.setWhere(where);
                }
                if ((queriedAttCount = unqualifiedPropertyNames.length) > 0) {
                    String[] sdeAttNames = new String[queriedAttCount];
                    FilterToSQLSDE sqlEncoder = this.getSqlEncoder();
                    for (int i = 0; i < queriedAttCount; ++i) {
                        String coldef;
                        String attName = unqualifiedPropertyNames[i];
                        sdeAttNames[i] = coldef = sqlEncoder.getColumnDefinition(attName);
                    }
                    qInfo.setColumns(sdeAttNames);
                }
                qInfo.setConstruct(sqlConstruct);
                if (byClause != null) {
                    qInfo.setByClause(byClause);
                }
                return qInfo;
            }
            catch (SeException e) {
                throw new ArcSdeException(e);
            }
        }

        public SeSqlConstruct getSeSqlConstruct() throws DataSourceException {
            if (this.sdeSqlConstruct == null) {
                String layerName = this.sdeTable.getQualifiedName();
                this.sdeSqlConstruct = new SeSqlConstruct(layerName);
                Filter sqlFilter = this.getSqlFilter();
                if (!Filter.INCLUDE.equals(sqlFilter)) {
                    String whereClause = null;
                    FilterToSQLSDE sqlEncoder = this.getSqlEncoder();
                    try {
                        whereClause = sqlEncoder.encodeToString(sqlFilter);
                    }
                    catch (FilterToSQLException sqle) {
                        String message = "Geometry encoder error: " + sqle.getMessage();
                        throw new DataSourceException(message, (Throwable)sqle);
                    }
                    LOGGER.fine("ArcSDE where clause '" + whereClause + "'");
                    this.sdeSqlConstruct.setWhere(whereClause);
                }
            }
            return this.sdeSqlConstruct;
        }

        public SeFilter[] getSpatialFilters() throws DataSourceException {
            if (this.sdeSpatialFilters == null) {
                GeometryEncoderSDE geometryEncoder = new GeometryEncoderSDE(this.sdeLayer, this.featureType);
                try {
                    geometryEncoder.encode(this.getGeometryFilter());
                }
                catch (GeometryEncoderException e) {
                    throw new DataSourceException("Error parsing geometry filters: " + e.getMessage(), (Throwable)e);
                }
                this.sdeSpatialFilters = geometryEncoder.getSpatialFilters();
            }
            return this.sdeSpatialFilters;
        }

        public Filter getSqlFilter() {
            return this._sqlFilter == null ? Filter.INCLUDE : this._sqlFilter;
        }

        public Filter getGeometryFilter() {
            return this.geometryFilter == null ? Filter.INCLUDE : this.geometryFilter;
        }

        public Filter getUnsupportedFilter() {
            return this.unsupportedFilter == null ? Filter.INCLUDE : this.unsupportedFilter;
        }

        private FilterToSQLSDE getSqlEncoder() {
            if (this._sqlEncoder == null) {
                String layerName = this.sdeTable.getQualifiedName();
                String fidColumn = this.fidReader.getFidColumn();
                this._sqlEncoder = new FilterToSQLSDE(layerName, fidColumn, this.featureType, this.layerSelectStatement, this.conn);
            }
            return this._sqlEncoder;
        }
    }
}

