/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.geotools.arcsde.ArcSDEDataStoreFactory;
import org.geotools.arcsde.data.ArcSDEDataStore;
import org.geotools.arcsde.data.ArcSDEDataStoreConfig;
import org.geotools.arcsde.jndi.ArcSDEConnectionFactory;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.arcsde.session.ISessionPool;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.util.logging.Logging;

public class ArcSDEJNDIDataStoreFactory
implements DataStoreFactorySpi {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde");
    private final ArcSDEDataStoreFactory delegateFactory = new ArcSDEDataStoreFactory();
    public static final DataAccessFactory.Param JNDI_REFNAME = new DataAccessFactory.Param("ArcSDE_jndiReferenceName", String.class, "JNDI context path", true, (Object)"java:comp/env/geotools/arcsde");
    private static final String J2EE_ROOT_CONTEXT = "java:comp/env/";

    public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
        String jndiName = (String)JNDI_REFNAME.lookUp(params);
        Object lookup = this.lookupJndiResource(jndiName);
        ISessionPool sessionPool = this.getSessionPool(jndiName, lookup);
        String nsUri = (String)ArcSDEDataStoreFactory.NAMESPACE_PARAM.lookUp(params);
        String version = (String)ArcSDEDataStoreFactory.VERSION_PARAM.lookUp(params);
        Boolean allowNonSpatialTables = (Boolean)ArcSDEDataStoreFactory.ALLOW_NON_SPATIAL_PARAM.lookUp(params);
        boolean nonSpatial = allowNonSpatialTables == null ? false : allowNonSpatialTables;
        ArcSDEConnectionConfig connectionConfig = sessionPool.getConfig();
        ArcSDEDataStoreConfig dsConfig = new ArcSDEDataStoreConfig(connectionConfig, nsUri, version, nonSpatial);
        LOGGER.info("Creating ArcSDE JNDI DataStore with shared session pool for " + dsConfig);
        ArcSDEDataStore dataStore = this.delegateFactory.createDataStore(dsConfig, sessionPool);
        return dataStore;
    }

    private ISessionPool getSessionPool(String jndiName, Object lookup) throws IOException, DataSourceException {
        ISessionPool sessionPool;
        if (lookup instanceof ISessionPool) {
            LOGGER.info("Creating JNDI ArcSDE DataStore with shared session pool for " + lookup);
            sessionPool = (ISessionPool)lookup;
        } else if (lookup instanceof Map) {
            HashMap<String, String> map = new HashMap<String, String>();
            Map props = (Map)lookup;
            for (Map.Entry e : props.entrySet()) {
                String key = String.valueOf(e.getKey());
                Object value = e.getValue();
                map.put(key, value == null ? null : String.valueOf(e.getValue()));
            }
            ArcSDEConnectionFactory factory = new ArcSDEConnectionFactory();
            sessionPool = factory.getInstance(map);
        } else {
            throw new DataSourceException("Unknown JNDI resource on path " + jndiName + ". Expected one of [" + ArcSDEConnectionConfig.class.getName() + ", " + ISessionPool.class.getName() + "] but got " + lookup.getClass().getName() + " (" + lookup + ")");
        }
        return sessionPool;
    }

    private Object lookupJndiResource(String jndiName) throws IOException {
        InitialContext ctx;
        if (jndiName == null) {
            throw new IOException("Missing " + ArcSDEJNDIDataStoreFactory.JNDI_REFNAME.description);
        }
        try {
            ctx = GeoTools.getInitialContext((Hints)GeoTools.getDefaultHints());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        Object lookup = null;
        try {
            lookup = ctx.lookup(jndiName);
        }
        catch (NamingException e1) {
            try {
                if (!jndiName.startsWith(J2EE_ROOT_CONTEXT)) {
                    lookup = ctx.lookup(J2EE_ROOT_CONTEXT + jndiName);
                    LOGGER.warning("Using java:comp/env/" + jndiName + " instead of " + jndiName + " would avoid an unnecessary JNDI lookup");
                }
            }
            catch (NamingException e2) {
                // empty catch block
            }
        }
        if (lookup == null) {
            throw new IOException("Cannot find JNDI data source: " + jndiName);
        }
        return lookup;
    }

    public boolean canProcess(Map<String, Serializable> params) {
        String lookUpKey;
        if (params == null) {
            return false;
        }
        try {
            lookUpKey = (String)JNDI_REFNAME.lookUp(params);
        }
        catch (IOException e) {
            return false;
        }
        return lookUpKey != null;
    }

    public String getDescription() {
        return this.delegateFactory.getDescription() + " (JNDI)";
    }

    public String getDisplayName() {
        return this.delegateFactory.getDisplayName() + " (JNDI)";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{JNDI_REFNAME, ArcSDEDataStoreFactory.NAMESPACE_PARAM, ArcSDEDataStoreFactory.VERSION_PARAM, ArcSDEDataStoreFactory.ALLOW_NON_SPATIAL_PARAM};
    }

    public boolean isAvailable() {
        try {
            GeoTools.getInitialContext((Hints)GeoTools.getDefaultHints());
        }
        catch (NamingException e) {
            return false;
        }
        return this.delegateFactory.isAvailable();
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return this.delegateFactory.getImplementationHints();
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        throw new UnsupportedOperationException("ArcSDE PlugIn does not support createNewDataStore");
    }
}

