/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.utils;

import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XmlElement {
    private final Element root;
    private static final long serialVersionUID = 1L;
    private static final XMLOutputter OUTPUTTER = new XMLOutputter(Format.getCompactFormat());

    public XmlElement(String name) {
        this.root = new Element(name);
    }

    public Element getRoot() {
        return this.root;
    }

    private XmlElement() {
        this.root = null;
    }

    protected void add(String nodename, String nodetext) {
        this.add(nodename, (Content)new Text(nodetext));
    }

    protected void add(String nodename, Content nodetext) {
        Element el = new Element(nodename);
        el.setContent(nodetext);
        this.addContent((Content)el);
    }

    protected void set(String nodename, String nodetext) {
        this.set(nodename, (Content)new Text(nodetext));
    }

    protected void set(String nodename, Content nodeContent) {
        Element el = ElementUtils.contains(this.getRoot(), nodename);
        if (el == null) {
            this.add(nodename, nodeContent);
        } else {
            el.setContent(nodeContent);
        }
    }

    protected Element addContent(Content child) {
        return this.root.addContent(child);
    }

    public boolean isEmpty() {
        return this.root.getChildren().isEmpty();
    }

    public boolean remove(String key) {
        Element el = ElementUtils.contains(this.root, key);
        if (el != null) {
            return ElementUtils.remove(this.root, el);
        }
        return false;
    }

    public String toString() {
        return OUTPUTTER.outputString(this.root);
    }
}

