/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.metadata.virtualtable;

import it.geosolutions.geoserver.rest.encoder.metadata.virtualtable.VTParameter;
import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import it.geosolutions.geoserver.rest.encoder.utils.XmlElement;
import org.jdom.Element;
import org.jdom.filter.Filter;

public class VTParameterEncoder
extends XmlElement {
    public static Filter getFilterByName(String name) {
        return new filterByName(name);
    }

    public VTParameterEncoder() {
        super("parameter");
    }

    public VTParameterEncoder(String name, String defaultValue, String regexpValidator) {
        super("parameter");
        this.setup(name, defaultValue, regexpValidator);
    }

    protected void setup(String name, String defaultValue, String regexpValidator) {
        this.setName(name);
        this.setDefaultValue(defaultValue);
        this.setRegexpValidator(regexpValidator);
    }

    protected void setMember(VTParameter type, String value) {
        this.set(type.toString(), value);
    }

    public void setName(String name) {
        this.setMember(VTParameter.name, name);
    }

    public void setDefaultValue(String value) {
        this.setMember(VTParameter.defaultValue, value);
    }

    public void setRegexpValidator(String validator) {
        this.setMember(VTParameter.regexpValidator, validator);
    }

    protected boolean delMember(VTParameter type) {
        return ElementUtils.remove(this.getRoot(), this.getRoot().getChild(type.toString()));
    }

    public boolean delName() {
        return this.delMember(VTParameter.name);
    }

    public boolean delDefaultValue() {
        return this.delMember(VTParameter.defaultValue);
    }

    public boolean delRegexpValidator() {
        return this.delMember(VTParameter.regexpValidator);
    }

    protected String getMember(VTParameter type) {
        Element el = this.getRoot().getChild(type.toString());
        if (el != null) {
            return el.getTextTrim();
        }
        return null;
    }

    public String getName() {
        return this.getMember(VTParameter.name);
    }

    public String getDefaultValue() {
        return this.getMember(VTParameter.defaultValue);
    }

    public String getRegexpValidator() {
        return this.getMember(VTParameter.regexpValidator);
    }

    private static class filterByName
    implements Filter {
        private final String key;
        private static final long serialVersionUID = 1L;

        public filterByName(String name) {
            this.key = name;
        }

        public boolean matches(Object obj) {
            Element el = ((Element)obj).getChild(VTParameter.name.toString());
            return el != null && el.getTextTrim().equals(this.key);
        }
    }
}

