/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.metadata;

import it.geosolutions.geoserver.rest.encoder.utils.XmlElement;
import java.math.BigDecimal;

public class GSDimensionInfoEncoder
extends XmlElement {
    public static final String DIMENSIONINFO = "dimensionInfo";
    public static final String RESOLUTION = "resolution";
    public static final String PRESENTATION = "presentation";
    private boolean enabled;

    public GSDimensionInfoEncoder(boolean enabled) {
        super(DIMENSIONINFO);
        this.add("enabled", enabled ? "true" : "false");
        this.enabled = enabled;
    }

    public GSDimensionInfoEncoder() {
        super(DIMENSIONINFO);
        this.add("enabled", "false");
        this.enabled = Boolean.FALSE;
    }

    public void setEnabled(boolean enabled) {
        this.set("enabled", "true");
        this.enabled = Boolean.TRUE;
    }

    protected void addPresentation(Presentation pres) {
        if (this.enabled) {
            this.add(PRESENTATION, pres.toString());
        }
    }

    public void setPresentation(Presentation pres) {
        if (this.enabled) {
            this.set(PRESENTATION, pres.toString());
            this.remove(RESOLUTION);
        }
    }

    protected void addPresentation(PresentationDiscrete pres, BigDecimal interval) {
        if (this.enabled) {
            this.add(PRESENTATION, pres.toString());
            this.add(RESOLUTION, String.valueOf(interval));
        }
    }

    public void setPresentation(PresentationDiscrete pres, BigDecimal interval) {
        if (this.enabled) {
            this.set(PRESENTATION, pres.toString());
            this.set(RESOLUTION, String.valueOf(interval));
        }
    }

    public static enum PresentationDiscrete {
        DISCRETE_INTERVAL;

    }

    public static enum Presentation {
        LIST,
        CONTINUOUS_INTERVAL;

    }
}

