/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.coverage;

import it.geosolutions.geoserver.rest.encoder.coverage.GSCoverageEncoder;
import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import it.geosolutions.geoserver.rest.encoder.utils.NestedElementEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.filter.Filter;

public class GSJP2KEncoder
extends GSCoverageEncoder {
    private static final String STRING = "string";
    private static final String ENTRY = "entry";
    private final NestedElementEncoder parameters = new NestedElementEncoder("parameters");
    private static final String useMultithreading = "USE_MULTITHREADING";
    private static final Filter useMultithreadingFilter = new parametersFilter("USE_MULTITHREADING");
    private static final String SUGGESTED_TILE_SIZE = "SUGGESTED_TILE_SIZE";
    private static final Filter SUGGESTED_TILE_SIZEFilter = new parametersFilter("SUGGESTED_TILE_SIZE");
    private static final String USE_JAI_IMAGEREAD = "USE_JAI_IMAGEREAD";
    private static final Filter USE_JAI_IMAGEREADFilter = new parametersFilter("USE_JAI_IMAGEREAD");

    public GSJP2KEncoder() {
        this.addContent((Content)this.parameters.getRoot());
    }

    private final boolean removeParameter(Filter filter) {
        Iterator<Element> it = ElementUtils.search(this.getRoot(), filter).iterator();
        if (it.hasNext()) {
            Element el = it.next();
            return ElementUtils.remove(el, el);
        }
        return false;
    }

    private final Element getParameter(Filter filter) {
        Iterator<Element> it = ElementUtils.search(this.getRoot(), filter).iterator();
        if (it.hasNext()) {
            Element el = it.next();
            return ElementUtils.contains(el, el);
        }
        return null;
    }

    protected void addUseMultithreading(boolean val) {
        ArrayList<Element> list = new ArrayList<Element>(2);
        list.add(new Element(STRING).setText(useMultithreading));
        list.add(new Element(STRING).setText(val ? "true" : "false"));
        this.parameters.add(null, list);
    }

    public void setUseMultithreading(boolean val) {
        this.removeParameter(useMultithreadingFilter);
        this.addUseMultithreading(val);
    }

    public Boolean getUseMultithreading() {
        Element el = this.getParameter(useMultithreadingFilter);
        if (el != null) {
            List values = el.getChildren();
            for (Element elm : values) {
                String value = elm.getValue();
                if (value.equalsIgnoreCase(useMultithreading)) continue;
                return Boolean.valueOf(value);
            }
        }
        return null;
    }

    protected void addSuggestedTileSize(String val) {
        ArrayList<Element> list = new ArrayList<Element>(2);
        list.add(new Element(STRING).setText(SUGGESTED_TILE_SIZE));
        list.add(new Element(STRING).setText(val));
        this.parameters.add(null, list);
    }

    public void setSuggestedTileSize(String val) {
        this.removeParameter(SUGGESTED_TILE_SIZEFilter);
        this.addSuggestedTileSize(val);
    }

    public String getSuggestedTileSize() {
        Element el = this.getParameter(SUGGESTED_TILE_SIZEFilter);
        if (el != null) {
            List values = el.getChildren();
            for (Element elm : values) {
                String value = elm.getValue();
                if (value.equalsIgnoreCase(SUGGESTED_TILE_SIZE)) continue;
                return value;
            }
        }
        return null;
    }

    protected void addUseJaiImageRead(boolean val) {
        ArrayList<Element> list = new ArrayList<Element>(2);
        list.add(new Element(STRING).setText(USE_JAI_IMAGEREAD));
        list.add(new Element(STRING).setText(val ? "true" : "false"));
        this.parameters.add(null, list);
    }

    public void setUseJaiImageRead(boolean val) {
        this.removeParameter(USE_JAI_IMAGEREADFilter);
        this.addUseJaiImageRead(val);
    }

    public Boolean getUseJaiImageRead() {
        Element el = this.getParameter(USE_JAI_IMAGEREADFilter);
        if (el != null) {
            List values = el.getChildren();
            for (Element elm : values) {
                String value = elm.getValue();
                if (value.equalsIgnoreCase(USE_JAI_IMAGEREAD)) continue;
                return Boolean.valueOf(value);
            }
        }
        return null;
    }

    static class parametersFilter
    implements Filter {
        final String name;
        private static final long serialVersionUID = 1L;

        public parametersFilter(String name) {
            this.name = name;
        }

        public boolean matches(Object obj) {
            if (obj instanceof Element && ((Element)obj).getName().equals(GSJP2KEncoder.ENTRY)) {
                List values = ((Element)obj).getChildren(GSJP2KEncoder.STRING);
                for (Element el : values) {
                    if (el == null) {
                        return false;
                    }
                    if (!el.getText().equals(this.name)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

