/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder;

import it.geosolutions.geoserver.rest.encoder.GSLayerGroupEncoder;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;

public class GSLayerGroupEncoder23
extends GSLayerGroupEncoder {
    public static final String MODE_SINGLE = "SINGLE";
    public static final String MODE_NAMED = "NAMED";
    public static final String MODE_CONTAINER = "CONTAINER";
    public static final String MODE_EO = "EO";
    private static final Set<String> modes = new HashSet<String>();
    private Element titleElem;
    private Element abstractElem;
    private Element modeElem;
    private Element rootLayerElem;
    private Element rootLayerStyleElem;

    public void setTitle(String title) {
        this.titleElem = this.elem("title", title);
    }

    public void setAbstract(String abstractTxt) {
        this.abstractElem = this.elem("abstractTxt", abstractTxt);
    }

    public void setMode(String mode) {
        if (!modes.contains(mode)) {
            throw new IllegalArgumentException("Invalid mode: " + mode);
        }
        this.modeElem = this.elem("mode", mode);
    }

    public void setRootLayer(String layer, String style) {
        this.rootLayerElem = this.elem("rootLayer", this.elem("name", layer));
        this.rootLayerStyleElem = this.elem("rootLayerStyle", this.elem("name", style));
    }

    @Override
    public void addLayer(String layer, String styleName) {
        this.initPublishables("publishables");
        this.publishablesElem.addContent((Content)new Element("published").setAttribute("type", "layer").addContent((Content)this.elem("name", layer)));
        Element style = new Element("style");
        this.stylesElem.addContent((Content)style);
        if (styleName != null) {
            style.addContent((Content)this.elem("name", styleName));
        }
    }

    public void addLayerGroup(String group) {
        this.initPublishables("publishables");
        this.publishablesElem.addContent((Content)new Element("published").setAttribute("type", "layerGroup").addContent((Content)this.elem("name", group)));
        this.stylesElem.addContent((Content)new Element("style"));
    }

    @Override
    public String toString() {
        this.addToRoot(this.titleElem, this.abstractElem, this.modeElem, this.rootLayerElem, this.rootLayerStyleElem);
        return super.toString();
    }

    static {
        modes.add(MODE_SINGLE);
        modes.add(MODE_NAMED);
        modes.add(MODE_CONTAINER);
        modes.add(MODE_EO);
    }
}

