/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder;

import it.geosolutions.geoserver.rest.decoder.RESTCoverage;
import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import it.geosolutions.geoserver.rest.encoder.feature.FeatureTypeAttribute;
import it.geosolutions.geoserver.rest.encoder.feature.GSAttributeEncoder;
import it.geosolutions.geoserver.rest.encoder.metadatalink.GSMetadataLinkInfoEncoder;
import it.geosolutions.geoserver.rest.encoder.metadatalink.ResourceMetadataLinkInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.Namespace;

public class RESTResource {
    protected final Element rootElem;

    public static RESTResource build(String response) {
        Element elem = JDOMBuilder.buildElement(response);
        return elem == null ? null : new RESTCoverage(elem);
    }

    public RESTResource(Element resource) {
        this.rootElem = resource;
    }

    public String getName() {
        return this.rootElem.getChildText("name");
    }

    public String getTitle() {
        return this.rootElem.getChildText("title");
    }

    public String getNativeName() {
        return this.rootElem.getChildText("nativeName");
    }

    public String getAbstract() {
        return this.rootElem.getChildText("abstract");
    }

    public String getNameSpace() {
        return this.rootElem.getChild("namespace").getChildText("name");
    }

    public String getStoreName() {
        return this.rootElem.getChild("store").getChildText("name");
    }

    public String getStoreType() {
        return this.rootElem.getChild("store").getAttributeValue("class");
    }

    public String getStoreUrl() {
        Element store = this.rootElem.getChild("store");
        Element atom = store.getChild("link", Namespace.getNamespace((String)"atom", (String)"http://www.w3.org/2005/Atom"));
        return atom.getAttributeValue("href");
    }

    public String getCRS() {
        Element elBBox = this.rootElem.getChild("latLonBoundingBox");
        return elBBox.getChildText("crs");
    }

    protected double getLatLonEdge(String edge) {
        Element elBBox = this.rootElem.getChild("latLonBoundingBox");
        return Double.parseDouble(elBBox.getChildText(edge));
    }

    public double getMinX() {
        return this.getLatLonEdge("minx");
    }

    public double getMaxX() {
        return this.getLatLonEdge("maxx");
    }

    public double getMinY() {
        return this.getLatLonEdge("miny");
    }

    public double getMaxY() {
        return this.getLatLonEdge("maxy");
    }

    public List<Map<FeatureTypeAttribute, String>> getAttributeList() {
        ArrayList attrsList = null;
        Element attrsRoot = this.rootElem.getChild("attributes");
        List attrs = attrsRoot.getChildren();
        if (attrs != null) {
            attrsList = new ArrayList(attrs.size());
            for (Element attr : attrs) {
                HashMap<FeatureTypeAttribute, String> attrsMap = new HashMap<FeatureTypeAttribute, String>();
                attrsList.add(attrsMap);
                for (FeatureTypeAttribute at : FeatureTypeAttribute.values()) {
                    String key = at.toString();
                    attrsMap.put(at, attr.getChildText(key));
                }
            }
        }
        return attrsList;
    }

    public List<GSAttributeEncoder> getEncodedAttributeList() {
        ArrayList<GSAttributeEncoder> attrsList = null;
        Element attrsRoot = this.rootElem.getChild("attributes");
        List attrs = attrsRoot.getChildren();
        if (attrs != null) {
            attrsList = new ArrayList<GSAttributeEncoder>(attrs.size());
            for (Element attr : attrs) {
                GSAttributeEncoder attrEnc = new GSAttributeEncoder();
                for (FeatureTypeAttribute at : FeatureTypeAttribute.values()) {
                    String key = at.toString();
                    attrEnc.setAttribute(at, attr.getChildText(key));
                }
                attrsList.add(attrEnc);
            }
        }
        return attrsList;
    }

    public List<GSMetadataLinkInfoEncoder> getEncodedMetadataLinkInfoList() {
        ArrayList<GSMetadataLinkInfoEncoder> metaLinksList = null;
        Element metaLinksRoot = this.rootElem.getChild("metadataLinks");
        List metaLinks = metaLinksRoot.getChildren();
        if (metaLinks != null) {
            metaLinksList = new ArrayList<GSMetadataLinkInfoEncoder>(metaLinks.size());
            for (Element metaLink : metaLinks) {
                GSMetadataLinkInfoEncoder metaLinkEnc = new GSMetadataLinkInfoEncoder();
                metaLinkEnc.setType(metaLink.getChildText(ResourceMetadataLinkInfo.type.name()));
                metaLinkEnc.setMetadataType(metaLink.getChildText(ResourceMetadataLinkInfo.metadataType.name()));
                metaLinkEnc.setContent(metaLink.getChildText(ResourceMetadataLinkInfo.content.name()));
                metaLinksList.add(metaLinkEnc);
            }
        }
        return metaLinksList;
    }
}

