/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jdom.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElementUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementUtils.class);

    public static boolean remove(Element root, Element el) throws IllegalArgumentException {
        if (root == null || el == null) {
            throw new IllegalArgumentException("Bad arguments: root=" + root + " element=" + el);
        }
        if (root.equals((Object)el)) {
            el.detach();
            el.removeContent();
            el = null;
            return true;
        }
        Element search = ElementUtils.contains(root, el);
        if (search != null) {
            return ElementUtils.remove(search, el);
        }
        return false;
    }

    public static List<Element> search(Element root, Filter filter, int depth) throws IllegalArgumentException {
        if (root == null || filter == null) {
            throw new IllegalArgumentException("Bad arguments: root=" + root + " filter=" + filter + " depth=" + depth);
        }
        ArrayList<Element> ret = new ArrayList<Element>();
        if (filter.matches((Object)root)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("LOCATED-> name:" + root.getName() + " text:" + root.getText());
            }
            ret.add(root);
        }
        if (depth != 0) {
            List childrenList = root.getContent();
            for (Object obj : childrenList) {
                if (!(obj instanceof Element)) continue;
                Element childEl = (Element)obj;
                ret.addAll(ElementUtils.search(childEl, filter, depth - 1));
            }
        }
        return ret;
    }

    public static List<Element> search(Element root, Filter filter) {
        if (root == null || filter == null) {
            throw new IllegalArgumentException("Bad arguments: root=" + root + " filter=" + filter);
        }
        ArrayList<Element> ret = new ArrayList<Element>();
        if (filter.matches((Object)root)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("LOCATED-> name:" + root.getName() + " text:" + root.getText());
            }
            ret.add(root);
        }
        Iterator it = root.getDescendants(filter);
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof Element)) continue;
            Element el = (Element)obj;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("LOCATED-> name:" + el.getName() + " text:" + el.getText());
            }
            ret.add(el);
        }
        return ret;
    }

    public static Element contains(Element root, Filter filter) throws IllegalArgumentException {
        if (root == null || filter == null) {
            throw new IllegalArgumentException("Bad arguments: root=" + root + " name=" + filter);
        }
        Iterator<Element> it = ElementUtils.search(root, filter).iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public static Element contains(Element root, final String name, final String val) throws IllegalArgumentException {
        if (root == null || name == null || val == null) {
            throw new IllegalArgumentException("Bad arguments: root=" + root + " name=" + name + " val=" + val);
        }
        Filter filter = new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean matches(Object obj) {
                Element el;
                return obj instanceof Element && (el = (Element)obj).getName().equals(name) && el.getText().equals(val);
            }
        };
        Iterator<Element> it = ElementUtils.search(root, filter).iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public static Element contains(Element root, String name) {
        return ElementUtils.contains(root, name, -1);
    }

    public static Element contains(Element root, final String name, int deep) throws IllegalArgumentException {
        if (root == null || name == null) {
            throw new IllegalArgumentException("Bad arguments: root=" + root + " name=" + name);
        }
        Filter filter = new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean matches(Object obj) {
                Element el;
                return obj instanceof Element && (el = (Element)obj).getName().equals(name);
            }
        };
        Iterator<Element> it = ElementUtils.search(root, filter, deep).iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public static Element contains(Element root, final Element el) throws IllegalArgumentException {
        if (root == null || el == null) {
            throw new IllegalArgumentException("Bad arguments: root=" + root + " element=" + el);
        }
        Filter filter = new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean matches(Object obj) {
                Element element;
                return obj instanceof Element && (element = (Element)obj).equals((Object)el);
            }
        };
        Iterator<Element> it = ElementUtils.search(root, filter).iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }
}

