/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.datastore;

import it.geosolutions.geoserver.rest.decoder.RESTDataStore;
import it.geosolutions.geoserver.rest.encoder.datastore.GSAbstractDatastoreEncoder;

public class GSOracleNGDatastoreEncoder
extends GSAbstractDatastoreEncoder {
    static final String TYPE = "Oracle NG";
    static final int DEFAULT_MIN_CONNECTIONS = 1;
    static final int DEFAULT_MAX_CONNECTIONS = 10;
    static final int DEFAULT_FETCH_SIZE = 1000;
    static final int DEFAULT_CONNECTION_TIMEOUT = 20;
    static final boolean DEFAULT_LOOSE_BBOX = true;
    static final boolean DEFAULT_PREPARED_STATEMENTS = true;
    static final int DEFAULT_MAX_OPEN_PREPARED_STATEMENTS = 50;

    public GSOracleNGDatastoreEncoder(String name, String database) {
        super(name);
        this.setType(TYPE);
        this.setDatabase(database);
        this.setMinConnections(1);
        this.setMaxConnections(10);
        this.setFetchSize(1000);
        this.setConnectionTimeout(20);
        this.setLooseBBox(true);
        this.setPreparedStatements(true);
        this.setMaxOpenPreparedStatements(50);
    }

    public GSOracleNGDatastoreEncoder(RESTDataStore store) {
        super(store);
        GSOracleNGDatastoreEncoder.ensureValidDatabase(store.getConnectionParameters().get("database"));
    }

    public void setHost(String host) {
        this.connectionParameters.set("host", host);
    }

    public void setPort(int port) {
        this.connectionParameters.set("port", Integer.toString(port));
    }

    public void setNamespace(String namespace) {
        this.connectionParameters.set("namespace", namespace);
    }

    public void setDatabase(String database) {
        this.connectionParameters.set("database", database);
    }

    public void setSchema(String schema) {
        this.connectionParameters.set("schema", schema);
    }

    public void setUser(String user) {
        this.connectionParameters.set("user", user);
    }

    public void setPassword(String password) {
        this.connectionParameters.set("passwd", password);
    }

    public void setJndiReferenceName(String jndiReferenceName) {
        this.connectionParameters.set("jndiReferenceName", jndiReferenceName);
    }

    public void setExposePrimaryKeys(boolean exposePrimaryKeys) {
        this.connectionParameters.set("Expose primary keys", Boolean.toString(exposePrimaryKeys));
    }

    public void setMaxConnections(int maxConnections) {
        this.connectionParameters.set("max connections", Integer.toString(maxConnections));
    }

    public void setMinConnections(int minConnections) {
        this.connectionParameters.set("min connections", Integer.toString(minConnections));
    }

    public void setFetchSize(int fetchSize) {
        this.connectionParameters.set("fetch size", Integer.toString(fetchSize));
    }

    public void setConnectionTimeout(int seconds) {
        this.connectionParameters.set("Connection timeout", Integer.toString(seconds));
    }

    public void setValidateConnections(boolean validateConnections) {
        this.connectionParameters.set("validate connections", Boolean.toString(validateConnections));
    }

    public void setPrimaryKeyMetadataTable(String primaryKeyMetadataTable) {
        this.connectionParameters.set("Primary key metadata table", primaryKeyMetadataTable);
    }

    public void setLooseBBox(boolean looseBBox) {
        this.connectionParameters.set("Loose bbox", Boolean.toString(looseBBox));
    }

    public void setPreparedStatements(boolean preparedStatements) {
        this.connectionParameters.set("preparedStatements", Boolean.toString(preparedStatements));
    }

    public void setMaxOpenPreparedStatements(int maxOpenPreparedStatements) {
        this.connectionParameters.set("Max open prepared statements", Integer.toString(maxOpenPreparedStatements));
    }

    private static void ensureValidDatabase(String database) {
        if (database == null || database.length() == 0) {
            throw new IllegalArgumentException("Oracle store database cannot be null or empty");
        }
    }

    @Override
    protected String getValidType() {
        return TYPE;
    }
}

