/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder.datastore;

import it.geosolutions.geoserver.rest.decoder.RESTDataStore;
import it.geosolutions.geoserver.rest.encoder.datastore.GSAbstractDatastoreEncoder;
import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;

public class GSArcSDEDatastoreEncoder
extends GSAbstractDatastoreEncoder {
    static final String TYPE = "ArcSDE";
    static final String DEFAULT_DB_TYPE = "arcsde";
    static final int DEFAULT_PORT = 5151;
    static final int DEFAULT_MIN_CONNECTIONS = 2;
    static final int DEFAULT_MAX_CONNECTIONS = 6;
    static final int DEFAULT_CONNECTION_TIMEOUT = 500;
    static final boolean DEFAULT_ALLOW_NON_SPATIAL_TABLES = false;

    public GSArcSDEDatastoreEncoder(String name, String server, String user) {
        super(name);
        this.setServer(server);
        this.setUser(user);
        this.setDbType(DEFAULT_DB_TYPE);
        this.setPort(5151);
        this.setMinConnections(2);
        this.setMaxConnections(6);
        this.setConnectionTimeout(500);
        this.setAllowNonSpatialTables(false);
    }

    public GSArcSDEDatastoreEncoder(RESTDataStore store) {
        super(store);
        GSArcSDEDatastoreEncoder.ensureValidServer(store.getConnectionParameters().get("server"));
        GSArcSDEDatastoreEncoder.ensureValidUser(store.getConnectionParameters().get("user"));
    }

    public void setDbType(String dbtype) {
        this.connectionParameters.set("dbtype", dbtype);
    }

    public String getDbType() {
        return ElementUtils.contains(this.connectionParameters.getRoot(), "dbtype").getTextTrim();
    }

    public void setServer(String server) {
        GSArcSDEDatastoreEncoder.ensureValidServer(server);
        this.connectionParameters.set("server", server);
    }

    public String getServer() {
        return ElementUtils.contains(this.connectionParameters.getRoot(), "server").getTextTrim();
    }

    public void setPort(int port) {
        this.connectionParameters.set("port", Integer.toString(port));
    }

    public int getPort() {
        return Integer.parseInt(ElementUtils.contains(this.connectionParameters.getRoot(), "port").getTextTrim());
    }

    public void setInstance(String instance) {
        this.connectionParameters.set("instance", instance);
    }

    public String getInstance() {
        return ElementUtils.contains(this.connectionParameters.getRoot(), "instance").getTextTrim();
    }

    public void setUser(String user) {
        GSArcSDEDatastoreEncoder.ensureValidUser(user);
        this.connectionParameters.set("user", user);
    }

    public String getUser() {
        return ElementUtils.contains(this.connectionParameters.getRoot(), "user").getTextTrim();
    }

    public void setPassword(String password) {
        this.connectionParameters.set("password", password);
    }

    public String getPassword() {
        return ElementUtils.contains(this.connectionParameters.getRoot(), "password").getTextTrim();
    }

    public void setNamespace(String namespace) {
        this.connectionParameters.set("namespace", namespace);
    }

    public String getNamespace() {
        return ElementUtils.contains(this.connectionParameters.getRoot(), "namespace").getTextTrim();
    }

    public void setMinConnections(int minConnections) {
        this.connectionParameters.set("pool.minConnections", Integer.toString(minConnections));
    }

    public int getMinConnections() {
        return Integer.parseInt(ElementUtils.contains(this.connectionParameters.getRoot(), "pool.minConnections").getTextTrim());
    }

    public void setMaxConnections(int maxConnections) {
        this.connectionParameters.set("pool.maxConnections", Integer.toString(maxConnections));
    }

    public int getMaxConnections() {
        return Integer.parseInt(ElementUtils.contains(this.connectionParameters.getRoot(), "pool.maxConnections").getTextTrim());
    }

    public void setConnectionTimeout(int seconds) {
        this.connectionParameters.set("pool.timeOut", Integer.toString(seconds));
    }

    public int getConnectionTimeout() {
        return Integer.parseInt(ElementUtils.contains(this.connectionParameters.getRoot(), "pool.timeOut").getTextTrim());
    }

    public void setAllowNonSpatialTables(boolean allowNonSpatialTables) {
        this.connectionParameters.set("datastore.allowNonSpatialTables", Boolean.toString(allowNonSpatialTables));
    }

    public boolean getAllowNonSpatialTables() {
        return Boolean.parseBoolean(ElementUtils.contains(this.connectionParameters.getRoot(), "datastore.allowNonSpatialTables").getTextTrim());
    }

    private static void ensureValidServer(String server) {
        if (server == null || server.length() == 0) {
            throw new IllegalArgumentException("ArcSDE store server name cannot be null or empty");
        }
    }

    private static void ensureValidUser(String user) {
        if (user == null || user.length() == 0) {
            throw new IllegalArgumentException("ArcSDE store user name cannot be null or empty");
        }
    }

    @Override
    protected String getValidType() {
        return TYPE;
    }
}

