/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.encoder;

import it.geosolutions.geoserver.rest.encoder.utils.ElementUtils;
import it.geosolutions.geoserver.rest.encoder.utils.NestedElementEncoder;
import it.geosolutions.geoserver.rest.encoder.utils.PropertyXMLEncoder;
import it.geosolutions.geoserver.rest.encoder.utils.XmlElement;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.filter.Filter;

public abstract class GSResourceEncoder
extends PropertyXMLEncoder {
    public static final String NAME = "name";
    public static final String METADATA = "metadata";
    public static final String KEYWORDS = "keywords";
    private final GSMetadataEncoder metadata = new GSMetadataEncoder();
    private final Element keywordsListEncoder = new Element("keywords");
    private static final String PROJECTIONPOLICY = "projectionPolicy";
    private static final String DESCRIPTION = "description";
    private static final String ABSTRACT = "abstract";
    private static final String TITLE = "title";
    private static final String SRS = "srs";
    private static final String NATIVECRS = "nativeCRS";
    private static final String LATLONBBMINX = "latLonBoundingBox/minx";
    private static final String LATLONBBMAXX = "latLonBoundingBox/maxx";
    private static final String LATLONBBMINY = "latLonBoundingBox/miny";
    private static final String LATLONBBMAXY = "latLonBoundingBox/maxy";
    private static final String LATLONBBCRS = "latLonBoundingBox/crs";
    private static final String NATIVEBBMINX = "nativeBoundingBox/minx";
    private static final String NATIVEBBMAXX = "nativeBoundingBox/maxx";
    private static final String NATIVEBBMINY = "nativeBoundingBox/miny";
    private static final String NATIVEBBMAXY = "nativeBoundingBox/maxy";
    private static final String NATIVEBBCRS = "nativeBoundingBox/crs";

    protected GSResourceEncoder(String rootName) {
        super(rootName);
        this.add("enabled", "true");
        this.addContent((Content)this.metadata.getRoot());
        this.addContent((Content)this.keywordsListEncoder);
    }

    public void setEnabled(boolean enabled) {
        this.set("enabled", enabled ? "true" : "false");
    }

    protected void addMetadata(String key, XmlElement dimensionInfo) {
        this.metadata.add(key, dimensionInfo.getRoot());
    }

    public void setMetadata(String key, XmlElement dimensionInfo) {
        this.metadata.set(key, dimensionInfo.getRoot());
    }

    public boolean delMetadata(String key) {
        return this.metadata.remove(key);
    }

    public void addKeyword(String keyword) {
        Element el = new Element("string");
        el.setText(keyword);
        this.keywordsListEncoder.addContent((Content)el);
    }

    public boolean delKeyword(final String keyword) {
        Element el = new Element("string");
        el.setText(keyword);
        return this.keywordsListEncoder.removeContent(new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean matches(Object obj) {
                return ((Element)obj).getText().equals(keyword);
            }
        }).size() != 0;
    }

    protected void addProjectionPolicy(ProjectionPolicy policy) {
        this.add(PROJECTIONPOLICY, policy.toString());
    }

    public void setProjectionPolicy(ProjectionPolicy policy) {
        this.set(PROJECTIONPOLICY, policy.toString());
    }

    protected void addName(String name) {
        this.add(NAME, name);
    }

    public void setName(String name) {
        this.set(NAME, name);
    }

    public String getName() {
        Element nameNode = ElementUtils.contains(this.getRoot(), NAME, 1);
        if (nameNode != null) {
            return nameNode.getText();
        }
        return null;
    }

    protected void addDescription(String description) {
        this.add(DESCRIPTION, description);
    }

    public void setDescription(String description) {
        this.set(DESCRIPTION, description);
    }

    protected void addAbstract(String _abstract) {
        this.add(ABSTRACT, _abstract);
    }

    public void setAbstract(String _abstract) {
        this.set(ABSTRACT, _abstract);
    }

    protected void addTitle(String title) {
        this.add(TITLE, title);
    }

    public void setTitle(String title) {
        this.set(TITLE, title);
    }

    protected void addSRS(String srs) {
        this.add(SRS, srs);
    }

    public void setSRS(String srs) {
        this.set(SRS, srs);
    }

    protected void addNativeCRS(String nativeCRS) {
        this.add(NATIVECRS, nativeCRS);
    }

    public void setNativeCRS(String nativeCRS) {
        this.set(NATIVECRS, nativeCRS);
    }

    protected void addLatLonBoundingBox(double minx, double miny, double maxx, double maxy, String crs) {
        this.add(LATLONBBMINX, String.valueOf(minx));
        this.add(LATLONBBMINY, String.valueOf(miny));
        this.add(LATLONBBMAXY, String.valueOf(maxy));
        this.add(LATLONBBMAXX, String.valueOf(maxx));
        this.add(LATLONBBCRS, crs);
    }

    public void setLatLonBoundingBox(double minx, double miny, double maxx, double maxy, String crs) {
        this.set(LATLONBBMINX, String.valueOf(minx));
        this.set(LATLONBBMAXY, String.valueOf(maxy));
        this.set(LATLONBBMAXX, String.valueOf(maxx));
        this.set(LATLONBBMINY, String.valueOf(miny));
        this.set(LATLONBBCRS, crs);
    }

    protected void addNativeBoundingBox(double minx, double miny, double maxx, double maxy, String crs) {
        this.add(NATIVEBBMINX, String.valueOf(minx));
        this.add(NATIVEBBMAXY, String.valueOf(maxy));
        this.add(NATIVEBBMAXX, String.valueOf(maxx));
        this.add(NATIVEBBMINY, String.valueOf(miny));
        this.add(NATIVEBBCRS, crs);
    }

    public void setNativeBoundingBox(double minx, double miny, double maxx, double maxy, String crs) {
        this.set(NATIVEBBMINX, String.valueOf(minx));
        this.set(NATIVEBBMAXY, String.valueOf(maxy));
        this.set(NATIVEBBMAXX, String.valueOf(maxx));
        this.set(NATIVEBBMINY, String.valueOf(miny));
        this.set(NATIVEBBCRS, crs);
    }

    public static enum ProjectionPolicy {
        REPROJECT_TO_DECLARED,
        FORCE_DECLARED,
        NONE;

    }

    private class GSMetadataEncoder
    extends NestedElementEncoder {
        public GSMetadataEncoder() {
            super(GSResourceEncoder.METADATA);
        }
    }
}

