/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder;

import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import it.geosolutions.geoserver.rest.decoder.utils.NameLinkElem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class RESTWorkspaceList
implements Iterable<RESTShortWorkspace> {
    private final List<Element> wsList;

    public static RESTWorkspaceList build(String response) {
        if (response == null) {
            return null;
        }
        Element elem = JDOMBuilder.buildElement(response);
        if (elem != null) {
            return new RESTWorkspaceList(elem);
        }
        return null;
    }

    protected RESTWorkspaceList(Element wslistroot) {
        ArrayList<Element> tmpList = new ArrayList<Element>();
        for (Element wselem : wslistroot.getChildren("workspace")) {
            tmpList.add(wselem);
        }
        this.wsList = Collections.unmodifiableList(tmpList);
    }

    public int size() {
        return this.wsList.size();
    }

    public boolean isEmpty() {
        return this.wsList.isEmpty();
    }

    public RESTShortWorkspace get(int index) {
        return new RESTShortWorkspace(this.wsList.get(index));
    }

    @Override
    public Iterator<RESTShortWorkspace> iterator() {
        return new RESTWSListIterator(this.wsList);
    }

    public static class RESTShortWorkspace
    extends NameLinkElem {
        public RESTShortWorkspace(Element elem) {
            super(elem);
        }
    }

    private static class RESTWSListIterator
    implements Iterator<RESTShortWorkspace> {
        private final Iterator<Element> iter;

        public RESTWSListIterator(List<Element> orig) {
            this.iter = orig.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public RESTShortWorkspace next() {
            return new RESTShortWorkspace(this.iter.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

