/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geoserver.rest.decoder;

import it.geosolutions.geoserver.rest.decoder.utils.JDOMBuilder;
import org.jdom.Element;
import org.jdom.Namespace;

public class RESTLayer {
    private final Element layerElem;

    public static RESTLayer build(String response) {
        if (response == null) {
            return null;
        }
        Element pb = JDOMBuilder.buildElement(response);
        if (pb != null) {
            return new RESTLayer(pb);
        }
        return null;
    }

    public RESTLayer(Element layerElem) {
        this.layerElem = layerElem;
    }

    public String getName() {
        return this.layerElem.getChildText("name");
    }

    public String getTypeString() {
        return this.layerElem.getChildText("type");
    }

    public Type getType() {
        return Type.get(this.getTypeString());
    }

    public String getDefaultStyle() {
        Element defaultStyle = this.layerElem.getChild("defaultStyle");
        return defaultStyle == null ? null : defaultStyle.getChildText("name");
    }

    public String getTitle() {
        Element resource = this.layerElem.getChild("resource");
        return resource.getChildText("title");
    }

    public String getAbstract() {
        Element resource = this.layerElem.getChild("resource");
        return resource.getChildText("abstract");
    }

    public String getNameSpace() {
        Element resource = this.layerElem.getChild("resource");
        return resource.getChild("namespace").getChildText("name");
    }

    public String getResourceUrl() {
        Element resource = this.layerElem.getChild("resource");
        Element atom = resource.getChild("link", Namespace.getNamespace((String)"atom", (String)"http://www.w3.org/2005/Atom"));
        return atom.getAttributeValue("href");
    }

    public static enum Type {
        VECTOR("VECTOR"),
        RASTER("RASTER"),
        UNKNOWN(null);

        private final String restName;

        private Type(String restName) {
            this.restName = restName;
        }

        public static Type get(String restName) {
            for (Type type : Type.values()) {
                if (type == UNKNOWN || !type.restName.equals(restName)) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

